package java.io {
import java.lang.Double;
import java.lang.Float;
import java.lang.JavaArray;
dynamic public class DataOutputStream extends OutputStream implements DataOutput {
  public var out: OutputStream;
  public function DataOutputStream(out: OutputStream) {
    this.out = out;
    return;
  }
  public override function close__(): void {
    out.close__();
    return;
  }
  public override function flush__(): void {
    out.flush__();
    return;
  }
  public override function write___3BII(b: JavaArray, off: int, len: int): void {
    out.write___3BII(b, off, len);
    return;
  }
  public override function write__I(b: int): void {
    out.write__I(b);
    return;
  }
  public function writeBoolean__Z(v: Boolean): void {
    this.write__I(v ? 1 : 0);
    return;
  }
  public function writeByte__I(v: int): void {
    out.write__I(v);
    return;
  }
  public function writeChar__I(v: int): void {
    out.write__I(v >> 8);
    out.write__I(v);
    return;
  }
  public function writeChars__Ljava_lang_String_2(s: String): void {
    var length: int = Object(s).length__();
    for (var i: int = 0; i < length; i++) {
      var v: int = Object(s).charAt__I(i);
      out.write__I(v >> 8);
      out.write__I(v);
    }
    return;
  }
  public function writeDouble__D(v: Number): void {
    this.writeLong__J(Double.doubleToLongBits__D(v));
    return;
  }
  public function writeFloat__F(v: Number): void {
    this.writeInt__I(Float.floatToIntBits__F(v));
    return;
  }
  public function writeInt__I(v: int): void {
    out.write__I(v >> 24);
    out.write__I(v >> 16);
    out.write__I(v >> 8);
    out.write__I(v);
    return;
  }
  public function writeLong__J(v: Number): void {
    this.writeInt__I(int((v >> 32)));
    this.writeInt__I(int(v));
    return;
  }
  public function writeShort__I(v: int): void {
    out.write__I(v >> 8);
    out.write__I(v);
    return;
  }
  public function writeUTF__Ljava_lang_String_2(s: String): void {
    var buffer: JavaArray = new JavaArray("[B").lengths(Object(s).length__() * 2 + 2);
    var len: int = this.convert__Ljava_lang_String_2_3B(s, buffer);
    out.write___3BII(buffer, 0, len);
    return;
  }
  private function convert__Ljava_lang_String_2_3B(s: String, buffer: JavaArray): int {
    buffer.array.writeUTF(s);
    return buffer.array.position;
  }
}
}
