package java.io {
import flash.utils.ByteArray;
import java.lang.NullPointerException;
import java.lang.System;
import java.lang.Math__;
import java.lang.IndexOutOfBoundsException;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class InputStreamReader extends Reader {
  private var in_java_io_InputStreamReader: InputStream;
  private var encoding: String;
  private var pos: int;
  private var count: int;
  private var buffer: JavaArray = new JavaArray("[B").lengths(BUFFER_SIZE);
  public static var BUFFER_SIZE: int = 4096;
  public function InputStreamReader__Ljava_io_InputStream_2(in_1: InputStream): Object {
    if (in_1 === null)
      throw new NullPointerException(new Arguments(java.lang.NullPointerException.NullPointerException__, []));
    this.in_java_io_InputStreamReader = in_1;
    this.encoding = System.getProperty__Ljava_lang_String_2("file.encoding");
    return this;
  }
  public function InputStreamReader__Ljava_io_InputStream_2Ljava_lang_String_2(in_1: InputStream, encoding: String): Object {
    if (in_1 === null)
      throw new NullPointerException(new Arguments(java.lang.NullPointerException.NullPointerException__, []));
    this.in_java_io_InputStreamReader = in_1;
    this.encoding = encoding;
    return this;
  }
  public override function close__(): void {
    in_java_io_InputStreamReader.close__();
    return;
  }
  public function getArray__(): ByteArray {
    return buffer.array as ByteArray;
  }
  private function convert___3CIILjava_lang_String_2(cbuf: JavaArray, off: int, len: int, encoding_1: String): int {
    if (count == 0)
      return 0;
    var array: ByteArray = this.getArray__();
    array.position = pos;
    var toRead: int = len * 6;
    if (toRead > count)
      toRead = count;
    var str: String = array.readMultiByte(toRead, encoding_1);
    array.position = pos;
    var read: int = Object(str).length__() < len ? Object(str).length__() : len;
    if (Object(str).length__() > 0) {
      for (var i: int = 0; i < read; i++) {
        cbuf[off++] = Object(str).charAt__I(i);
      }
      array.writeMultiByte(Object(str).substring__II(0, read), encoding_1);
      count -= array.position - pos;
      pos = array.position;
    }
    return read;
  }
  private function fill__I(length: int): int {
    if (count > 0)
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(buffer, pos, buffer, 0, count);
    pos = 0;
    var read: int = in_java_io_InputStreamReader.read___3BII(buffer, count, Math__.min__II(length, buffer.length - count));
    if (read < 0) {
      if (count > 0)
        throw new IOException(new Arguments(java.io.IOException.IOException__, []));
    } else {
      count += read;
    }
    return read;
  }
  public override function mark__I(readAheadLimit: int): void {
    in_java_io_InputStreamReader.mark__I(readAheadLimit);
  }
  public override function read__(): int {
    var result: JavaArray = new JavaArray("[C").lengths(1);
    var read: int = this.read___3C(result);
    if (read < 0)
      return -1;
    return result[0];
  }
  public override function read___3CII(cbuf: JavaArray, off: int, len: int): int {
    if (off < 0 || len < 0 || off >= cbuf.length || off + len > cbuf.length) {
      throw new IndexOutOfBoundsException(new Arguments(java.lang.IndexOutOfBoundsException.IndexOutOfBoundsException__, []));
    }
    var read: int = 0;
    while (read < len) {
      var converted: int = this.convert___3CIILjava_lang_String_2(cbuf, off, len - read, encoding);
      if (converted == 0) {
        if (this.fill__I((len - read) * 6) < 0) {
          if (read == 0)
            return -1;
          break;
        }
      } else {
        off += converted;
        read += converted;
      }
    }
    return read;
  }
  public override function ready__(): Boolean {
    return count > 0 || in_java_io_InputStreamReader.available__() > 0;
  }
  public override function reset__(): void {
    in_java_io_InputStreamReader.reset__();
  }
  public override function skip__J(n: Number): Number {
    return super.skip__J(n);
  }
  public function InputStreamReader(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is InputStream) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is InputStream && vargs[1] is String) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        var superArgs: Arguments;
        superArgs = new Arguments(java.io.Reader.Reader__, []);
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        superArgs = new Arguments(java.io.Reader.Reader__, []);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        InputStreamReader__Ljava_io_InputStream_2(args0[0]);
        break;
      case 1:
        InputStreamReader__Ljava_io_InputStream_2Ljava_lang_String_2(args1[0], args1[1]);
        break;
    }
  }
  public static const InputStreamReader__Ljava_io_InputStream_2 : int = 0;
  public static const InputStreamReader__Ljava_io_InputStream_2Ljava_lang_String_2 : int = 1;
}
}
