package java.io {
import java.lang.NullPointerException;
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class OutputStreamWriter extends Writer {
  private var out: OutputStream;
  private var encoding: String;
  public function OutputStreamWriter__Ljava_io_OutputStream_2(out: OutputStream): Object {
    if (out === null)
      throw new NullPointerException(new Arguments(java.lang.NullPointerException.NullPointerException__, []));
    this.out = out;
    this.encoding = System.getProperty__Ljava_lang_String_2("file.encoding");
    return this;
  }
  public function OutputStreamWriter__Ljava_io_OutputStream_2Ljava_lang_String_2(out: OutputStream, encoding: String): Object {
    if (out === null)
      throw new NullPointerException(new Arguments(java.lang.NullPointerException.NullPointerException__, []));
    this.out = out;
    this.encoding = encoding;
    return this;
  }
  public override function close__(): void {
    out.close__();
    return;
  }
  private function convert__Ljava_lang_String_2Ljava_lang_String_2_3B(s: String, encoding_1: String, buffer: JavaArray): int {
    buffer.array.writeMultiByte(s, encoding);
    return buffer.array.position;
  }
  public override function flush__(): void {
    out.flush__();
    return;
  }
  public function write__I(c: int): void {
    this.write__Ljava_lang_String_2(Object(String).valueOf__C(uint(c)));
    return;
  }
  public override function write___3CII(cbuf: JavaArray, off: int, len: int): void {
    this.write__Ljava_lang_String_2(Object(String).valueOf___3CII(cbuf, off, len));
    return;
  }
  public override function write__Ljava_lang_String_2II(str: String, off: int, len: int): void {
    var buffer: JavaArray = new JavaArray("[B").lengths(Object(str).length__() * 2);
    var count: int = this.convert__Ljava_lang_String_2Ljava_lang_String_2_3B(str, encoding, buffer);
    out.write___3BII(buffer, 0, count);
    return;
  }
  public function OutputStreamWriter(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is OutputStream) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is OutputStream && vargs[1] is String) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        var superArgs: Arguments;
        superArgs = new Arguments(java.io.Writer.Writer__, []);
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        superArgs = new Arguments(java.io.Writer.Writer__, []);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        OutputStreamWriter__Ljava_io_OutputStream_2(args0[0]);
        break;
      case 1:
        OutputStreamWriter__Ljava_io_OutputStream_2Ljava_lang_String_2(args1[0], args1[1]);
        break;
    }
  }
  public static const OutputStreamWriter__Ljava_io_OutputStream_2 : int = 0;
  public static const OutputStreamWriter__Ljava_io_OutputStream_2Ljava_lang_String_2 : int = 1;
}
}
