package java.io {
import java.lang.NullPointerException;
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class PrintStream extends OutputStream {
  private var out: OutputStream;
  private var error: Boolean;
  private var delimiter: String;
  private var encoding: String;
  public function PrintStream(out: OutputStream) {
    if (out === null)
      throw new NullPointerException(new Arguments(java.lang.NullPointerException.NullPointerException__, []));
    this.out = out;
    return;
  }
  public function checkError__(): Boolean {
    this.flush__();
    return error;
  }
  public override function close__(): void {
    try {
      out.flush__();
      out.close__();
    } catch (e : IOException) {
      this.setError__();
    }
    return;
  }
  private function convert__Ljava_lang_String_2Ljava_lang_String_2_3B(s: String, encoding_1: String, buffer: JavaArray): int {
    buffer.array.writeMultiByte(s, encoding);
    return buffer.array.position;
  }
  public override function flush__(): void {
    try {
      out.flush__();
    } catch (e : IOException) {
      this.setError__();
    }
    return;
  }
  private function newline__(): void {
    if (delimiter === null)
      delimiter = System.getProperty__Ljava_lang_String_2("line.separator");
    this.print__Ljava_lang_String_2(delimiter);
    return;
  }
  public function print__Z(b: Boolean): void {
    this.print__Ljava_lang_String_2(Object(String).valueOf__Z(b));
    return;
  }
  public function print__C(c: uint): void {
    this.print__Ljava_lang_String_2(Object(String).valueOf__C(c));
    return;
  }
  public function print___3C(s: JavaArray): void {
    if (s === null)
      throw new NullPointerException(new Arguments(java.lang.NullPointerException.NullPointerException__, []));
    this.print__Ljava_lang_String_2(Object(String).valueOf___3C(s));
    return;
  }
  public function print__D(d: Number): void {
    this.print__Ljava_lang_String_2(Object(String).valueOf__D(d));
    return;
  }
  public function print__F(f: Number): void {
    this.print__Ljava_lang_String_2(Object(String).valueOf__F(f));
    return;
  }
  public function print__I(i: int): void {
    this.print__Ljava_lang_String_2(Object(String).valueOf__I(i));
    return;
  }
  public function print__J(l: Number): void {
    this.print__Ljava_lang_String_2(Object(String).valueOf__J(l));
    return;
  }
  public function print__Ljava_lang_Object_2(obj: Object): void {
    this.print__Ljava_lang_String_2(Object(String).valueOf__Ljava_lang_Object_2(obj));
    return;
  }
  public function print__Ljava_lang_String_2(s: String): void {
    if (encoding === null)
      encoding = System.getProperty__Ljava_lang_String_2("file.encoding");
    if (s === null)
      s = "null";
    var buffer: JavaArray = new JavaArray("[B").lengths(Object(s).length__() * 2);
    var len: int = this.convert__Ljava_lang_String_2Ljava_lang_String_2_3B(s, encoding, buffer);
    this.write___3BII(buffer, 0, len);
    return;
  }
  public function println__(): void {
    this.newline__();
    return;
  }
  public function println__Z(b: Boolean): void {
    this.println__Ljava_lang_String_2(Object(String).valueOf__Z(b));
    return;
  }
  public function println__C(c: uint): void {
    this.println__Ljava_lang_String_2(Object(String).valueOf__C(c));
    return;
  }
  public function println___3C(s: JavaArray): void {
    if (s === null)
      throw new NullPointerException(new Arguments(java.lang.NullPointerException.NullPointerException__, []));
    this.println__Ljava_lang_String_2(Object(String).valueOf___3C(s));
    return;
  }
  public function println__D(d: Number): void {
    this.println__Ljava_lang_String_2(Object(String).valueOf__D(d));
    return;
  }
  public function println__F(f: Number): void {
    this.println__Ljava_lang_String_2(Object(String).valueOf__F(f));
    return;
  }
  public function println__I(i: int): void {
    this.println__Ljava_lang_String_2(Object(String).valueOf__I(i));
    return;
  }
  public function println__J(l: Number): void {
    this.println__Ljava_lang_String_2(Object(String).valueOf__J(l));
    return;
  }
  public function println__Ljava_lang_Object_2(obj: Object): void {
    this.println__Ljava_lang_String_2(Object(String).valueOf__Ljava_lang_Object_2(obj));
    return;
  }
  public function println__Ljava_lang_String_2(s: String): void {
    this.print__Ljava_lang_String_2(s);
    this.newline__();
    return;
  }
  public function setError__(): void {
    error = true;
    return;
  }
  public override function write__I(b: int): void {
    try {
      out.write__I(b);
    } catch (e : IOException) {
      this.setError__();
    }
    return;
  }
  public override function write___3BII(b: JavaArray, off: int, len: int): void {
    try {
      out.write___3BII(b, off, len);
    } catch (e : IOException) {
      this.setError__();
    }
    return;
  }
}
}
