package java.io {
import java.lang.NullPointerException;
import java.lang.IllegalArgumentException;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Reader {
  public var lock: Object;
  public function Reader__(): Object {
    lock = this;
    return this;
  }
  public function Reader__Ljava_lang_Object_2(lock: Object): Object {
    if (lock === null)
      throw new NullPointerException(new Arguments(java.lang.NullPointerException.NullPointerException__, []));
    this.lock = lock;
    return this;
  }
  public function close__(): void { } // abstract
  public function mark__I(readAheadLimit: int): void {
    throw new IOException(new Arguments(java.io.IOException.IOException__, []));
    return;
  }
  public function markSupported__(): Boolean {
    return false;
  }
  public function read__(): int {
    var buffer: JavaArray = new JavaArray("[C").lengths(1);
    {
      var read: int = this.read___3C(buffer);
      if (read == -1)
        return -1;
      return buffer[0];
    }
    return 0;
  }
  public function read___3C(cbuf: JavaArray): int {
    return this.read___3CII(cbuf, 0, cbuf.length);
  }
  public function read___3CII(cbuf: JavaArray, off: int, len: int): int { // abstract
    return 0;
  }
  public function ready__(): Boolean {
    return false;
  }
  public function reset__(): void {
    throw new IOException(new Arguments(java.io.IOException.IOException__, []));
  }
  public function skip__J(n: Number): Number {
    if (n <= 0)
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__, []));
    var len: int = n < 512 ? int(n) : 512;
    var buffer: JavaArray = new JavaArray("[C").lengths(len);
    var skipped: int = 0;
    while (skipped < n) {
      var read: int = this.read___3CII(buffer, 0, len);
      if (read == -1)
        break;
      skipped += read;
      if (read < len)
        break;
      if (n - skipped > buffer.length) {
        len = int(n) - skipped;
      }
    }
    return skipped;
  }
  public function Reader(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Object) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Reader__();
        break;
      case 1:
        Reader__Ljava_lang_Object_2(args1[0]);
        break;
    }
  }
  public static const Reader__ : int = 0;
  public static const Reader__Ljava_lang_Object_2 : int = 1;
}
}
