package java.lang {
import java.io.Serializable;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Character implements Comparable, Serializable {
  public static var TYPE: java.lang.Class__ = new java.lang.Class__(new Arguments(java.lang.Class__.Class____Ljava_lang_String_2, ["char"]));
  public static const DIRECTIONALITY_RIGHT_TO_LEFT_ARABIC: int = 2;
  public static const DIRECTIONALITY_UNDEFINED: int = -1;
  public static const MIN_RADIX: int = 2;
  public static const MAX_RADIX: int = 36;
  public static const MIN_VALUE: uint = 0;
  public static const MAX_VALUE: uint = 65535;
  public static const MIN_SURROGATE: uint = 55296;
  public static const MAX_SURROGATE: uint = 57343;
  public static const MIN_LOW_SURROGATE: uint = 56320;
  public static const MAX_LOW_SURROGATE: uint = 57343;
  public static const MIN_HIGH_SURROGATE: uint = 55296;
  public static const MAX_HIGH_SURROGATE: uint = 56319;
  public static const MIN_SUPPLEMENTARY_CODE_POINT: int = 0x10000;
  public static const MIN_CODE_POINT: int = 0x0000;
  public static const MAX_CODE_POINT: int = 0x10FFFF;
  public static const SIZE: int = 16;
  private var value: uint;
  public static function isWhitespace__C(ch: uint): Boolean {
    return isSpace__C(ch);
  }
  public static function isJavaLetter__C(ch: uint): Boolean {
    return isLetter__C(ch) || ch == 36 || ch == 95;
  }
  public static function isJavaLetterOrDigit__C(ch: uint): Boolean {
    return isJavaLetter__C(ch) || isDigit__C(ch);
  }
  public static function isJavaIdentifierStart__C(ch: uint): Boolean {
    return isJavaLetter__C(ch);
  }
  public static function isJavaIdentifierPart__C(ch: uint): Boolean {
    return isJavaLetterOrDigit__C(ch);
  }
  public static function charCount__I(codePoint: int): int {
    return codePoint >= 65536 ? 2 : 1;
  }
  public static function codePointAt___3CI(a: JavaArray, index: int): int {
    return codePointAt__Ljava_lang_CharSequence_2II(new Character$CharSequenceAdapter(new Arguments(java.lang.Character$CharSequenceAdapter.Character$CharSequenceAdapter___3C, [a])), index, a.length);
  }
  public static function codePointAt___3CII(a: JavaArray, index: int, limit: int): int {
    return codePointAt__Ljava_lang_CharSequence_2II(new Character$CharSequenceAdapter(new Arguments(java.lang.Character$CharSequenceAdapter.Character$CharSequenceAdapter___3C, [a])), index, limit);
  }
  public static function codePointAt__Ljava_lang_CharSequence_2I(seq: CharSequence, index: int): int {
    return codePointAt__Ljava_lang_CharSequence_2II(seq, index, seq.length__());
  }
  public static function codePointBefore___3CI(a: JavaArray, index: int): int {
    return codePointBefore__Ljava_lang_CharSequence_2II(new Character$CharSequenceAdapter(new Arguments(java.lang.Character$CharSequenceAdapter.Character$CharSequenceAdapter___3C, [a])), index, 0);
  }
  public static function codePointBefore___3CII(a: JavaArray, index: int, start: int): int {
    return codePointBefore__Ljava_lang_CharSequence_2II(new Character$CharSequenceAdapter(new Arguments(java.lang.Character$CharSequenceAdapter.Character$CharSequenceAdapter___3C, [a])), index, start);
  }
  public static function codePointBefore__Ljava_lang_CharSequence_2I(cs: CharSequence, index: int): int {
    return codePointBefore__Ljava_lang_CharSequence_2II(cs, index, 0);
  }
  public static function codePointCount___3CII(a: JavaArray, offset: int, count: int): int {
    return codePointCount__Ljava_lang_CharSequence_2II(new Character$CharSequenceAdapter(new Arguments(java.lang.Character$CharSequenceAdapter.Character$CharSequenceAdapter___3C, [a])), offset, offset + count);
  }
  public static function codePointCount__Ljava_lang_CharSequence_2II(seq: CharSequence, beginIndex: int, endIndex: int): int {
    var count: int = 0;
    for (var idx: int = beginIndex; idx < endIndex;) {
      var ch: uint = seq.charAt__I(idx++);
      if (isHighSurrogate__C(ch) && idx < endIndex && (isLowSurrogate__C(seq.charAt__I(idx)))) {
        ++idx;
      }
      ++count;
    }
    return count;
  }
  public static function digit__CI(c: uint, radix: int): int {
    if (radix < 2 || radix > 36) {
      return -1;
    }
    if (c >= 48 && c < 48 + Math__.min__II(radix, 10)) {
      return c - 48;
    }
    if (c >= 97 && c < (radix + 97 - 10)) {
      return c - 97 + 10;
    }
    if (c >= 65 && c < (radix + 65 - 10)) {
      return c - 65 + 10;
    }
    return -1;
  }
  public static function forDigit__II(digit: int, radix: int): uint {
    if (radix < 2 || radix > 36) {
      return 0;
    }
    if (digit < 0 || digit >= radix) {
      return 0;
    }
    var baseTenMax: int = 10;
    if (digit < 10) {
      return uint((48 + digit));
    } else {
      return uint((97 + digit - 10));
    }
    return 0;
  }
  public static function getDirectionality__C(ch: uint): int {
    return -1;
  }
  public static function hashCode__C(c: uint): int {
    return c;
  }
  public static function isDigit__C(c: uint): Boolean {
    return (null != String.fromCharCode(c).match(/\d/));
  }
  public static function isHighSurrogate__C(ch: uint): Boolean {
    return ch >= 55296 && ch <= 56319;
  }
  public static function isLetter__C(c: uint): Boolean {
    return (null != String.fromCharCode(c).match(/[A-Z]/i));
  }
  public static function isLetterOrDigit__C(c: uint): Boolean {
    return (null != String.fromCharCode(c).match(/[A-Z\d]/i));
  }
  public static function isLowerCase__C(c: uint): Boolean {
    return toLowerCase__C(c) == c && isLetter__C(c);
  }
  public static function isLowSurrogate__C(ch: uint): Boolean {
    return ch >= 56320 && ch <= 57343;
  }
  public static function isSpace__C(c: uint): Boolean {
    switch (c) {
      case 32 :
        return true;
      case 10 :
        return true;
      case 9 :
        return true;
      case 12 :
        return true;
      case 13 :
        return true;
      default :
        return false;
    }
  }
  public static function isSupplementaryCodePoint__I(codePoint: int): Boolean {
    return codePoint >= 65536 && codePoint <= 1114111;
  }
  public static function isSurrogatePair__CC(highSurrogate: uint, lowSurrogate: uint): Boolean {
    return isHighSurrogate__C(highSurrogate) && isLowSurrogate__C(lowSurrogate);
  }
  public static function isUpperCase__C(c: uint): Boolean {
    return toUpperCase__C(c) == c && isLetter__C(c);
  }
  public static function isValidCodePoint__I(codePoint: int): Boolean {
    return codePoint >= 0 && codePoint <= 1114111;
  }
  public static function offsetByCodePoints___3CIIII(a: JavaArray, start: int, count: int, index: int, codePointOffset: int): int {
    return offsetByCodePoints__Ljava_lang_CharSequence_2II(new Character$CharSequenceAdapter(new Arguments(java.lang.Character$CharSequenceAdapter.Character$CharSequenceAdapter___3CII, [a, start, count])), index, codePointOffset);
  }
  public static function offsetByCodePoints__Ljava_lang_CharSequence_2II(seq: CharSequence, index: int, codePointOffset: int): int {
    if (codePointOffset < 0) {
      while (codePointOffset < 0) {
        --index;
        if (isLowSurrogate__C(seq.charAt__I(index)) && isHighSurrogate__C(seq.charAt__I(index - 1))) {
          --index;
        }
        ++codePointOffset;
      }
    } else {
      while (codePointOffset > 0) {
        if (isHighSurrogate__C(seq.charAt__I(index)) && isLowSurrogate__C(seq.charAt__I(index + 1))) {
          ++index;
        }
        ++index;
        --codePointOffset;
      }
    }
    return index;
  }
  public static function toChars__I(codePoint: int): JavaArray {
    if (codePoint < 0 || codePoint > 1114111) {
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__, []));
    }
    if (codePoint >= 65536) {
      return new JavaArray("[C").values(getHighSurrogate__I(codePoint), getLowSurrogate__I(codePoint));
    } else {
      return new JavaArray("[C").values(uint(codePoint));
    }
    return null;
  }
  public static function toChars__I_3CI(codePoint: int, dst: JavaArray, dstIndex: int): int {
    if (codePoint < 0 || codePoint > 1114111) {
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__, []));
    }
    if (codePoint >= 65536) {
      dst[dstIndex++] = getHighSurrogate__I(codePoint);
      dst[dstIndex] = getLowSurrogate__I(codePoint);
      return 2;
    } else {
      dst[dstIndex] = uint(codePoint);
      return 1;
    }
    return 0;
  }
  public static function toCodePoint__CC(highSurrogate: uint, lowSurrogate: uint): int {
    return 65536 + ((highSurrogate & 1023) << 10) + (lowSurrogate & 1023);
  }
  public static function toLowerCase__C(c: uint): uint {
    return String.fromCharCode(c).toLowerCase().charCodeAt(0);
  }
  public static function toString__C(x: uint): String {
    return Object(String).valueOf__C(x);
  }
  public static function toUpperCase__C(c: uint): uint {
    return String.fromCharCode(c).toUpperCase().charCodeAt(0);
  }
  public static function valueOf__C(c: uint): Character {
    if (c < 128) {
      var result: Character = Character$BoxedValues.access$0()[c];
      if (result === null) {
        result = Character$BoxedValues.access$0()[c] = new Character(c);
      }
      return result;
    }
    return new Character(c);
  }
  public static function codePointAt__Ljava_lang_CharSequence_2II(cs: CharSequence, index: int, limit: int): int {
    var hiSurrogate: uint = cs.charAt__I(index++);
    var loSurrogate: uint;
    if (isHighSurrogate__C(hiSurrogate) && index < limit && isLowSurrogate__C(loSurrogate = cs.charAt__I(index))) {
      return toCodePoint__CC(hiSurrogate, loSurrogate);
    }
    return hiSurrogate;
  }
  public static function codePointBefore__Ljava_lang_CharSequence_2II(cs: CharSequence, index: int, start: int): int {
    var loSurrogate: uint = cs.charAt__I(--index);
    var highSurrogate: uint;
    if (isLowSurrogate__C(loSurrogate) && index > start && isHighSurrogate__C(highSurrogate = cs.charAt__I(index - 1))) {
      return toCodePoint__CC(highSurrogate, loSurrogate);
    }
    return loSurrogate;
  }
  public static function getHighSurrogate__I(codePoint: int): uint {
    return uint((55296 + (((codePoint - 65536) >> 10) & 1023)));
  }
  public static function getLowSurrogate__I(codePoint: int): uint {
    return uint((56320 + ((codePoint - 65536) & 1023)));
  }
  public function Character(value: uint) {
    this.value = value;
    return;
  }
  public function charValue__(): uint {
    return value;
  }
  public function compareTo__Ljava_lang_Character_2(c: Character): int {
    return value - c.value;
  }
  public function equals__Ljava_lang_Object_2(o: Object): Boolean {
    return (o is Character) && ((Character(o)).value == value);
  }
  public function hashCode__(): int {
    return Character.hashCode__C(value);
  }
  public function toString__(): String {
    return Object(String).valueOf__C(value);
  }
  public function compareTo__Ljava_lang_Object_2(arg0: Object): int {
    return arg0.compareTo__Ljava_lang_Character_2();
  }
}
}
