package java.lang {
import flash.utils.ByteArray;
import java.lang.Arguments;
dynamic public class Double extends Number__ implements Comparable {
  public static var TYPE: java.lang.Class__ = new java.lang.Class__(new Arguments(java.lang.Class__.Class____Ljava_lang_String_2, ["double"]));
  public static const MAX_VALUE: Number = 1.7976931348623157E308;
  public static const MIN_VALUE: Number = 4.9E-324;
  public static const MIN_NORMAL: Number = 2.2250738585072014E-308;
  public static const MAX_EXPONENT: int = 1023;
  public static const MIN_EXPONENT: int = -1022;
  public static const NaN: Number = 0.0 / 0.0;
  public static const NEGATIVE_INFINITY: Number = -1.0 / 0.0;
  public static const POSITIVE_INFINITY: Number = 1.0 / 0.0;
  public static const SIZE: int = 64;
  private var value: Number = 0;
  public static function longBitsToDouble__J(bits: Number): Number {
    var array: ByteArray = new ByteArray();
    array.writeInt(int((bits >> 32)));
    array.writeInt(int(bits));
    return array.readDouble();
  }
  public static function doubleToLongBits__D(value: Number): Number {
    var array: ByteArray = new ByteArray();
    array.writeDouble(value);
    return Number(array.readInt()) << 32 | array.readInt();
  }
  public static function compare__DD(x: Number, y: Number): int {
    if (x < y) {
      return -1;
    } else if (x > y) {
      return 1;
    } else {
      return 0;
    }
    return 0;
  }
  public static function hashCode__D(d: Number): int {
    return int(d);
  }
  public static function isInfinite__D(x: Number): Boolean {
    return !isFinite(x);
  }
  public static function isNaN__D(x: Number): Boolean {
    return isNaN(x);
  }
  public static function parseDouble__Ljava_lang_String_2(s: String): Number {
    return Number__.__parseAndValidateDouble__Ljava_lang_String_2(s);
  }
  public static function toString__D(b: Number): String {
    return Object(String).valueOf__D(b);
  }
  public static function valueOf__D(d: Number): Double {
    return new Double(new Arguments(java.lang.Double.Double__D, [d]));
  }
  public static function valueOf__Ljava_lang_String_2(s: String): Double {
    return new Double(new Arguments(java.lang.Double.Double__D, [parseDouble__Ljava_lang_String_2(s)]));
  }
  public function Double__D(value: Number): Object {
    this.value = value;
    return this;
  }
  public function Double__Ljava_lang_String_2(s: String): Object {
    value = Double.parseDouble__Ljava_lang_String_2(s);
    return this;
  }
  public override function byteValue__(): int {
    return int(value);
  }
  public function compareTo__Ljava_lang_Double_2(b: Double): int {
    if (value < b.value) {
      return -1;
    } else if (value > b.value) {
      return 1;
    } else {
      return 0;
    }
    return 0;
  }
  public override function doubleValue__(): Number {
    return value;
  }
  public function equals__Ljava_lang_Object_2(o: Object): Boolean {
    return (o is Double) && ((Double(o)).value == value);
  }
  public override function floatValue__(): Number {
    return Number(value);
  }
  public function hashCode__(): int {
    return Double.hashCode__D(value);
  }
  public override function intValue__(): int {
    return int(value);
  }
  public function isInfinite__(): Boolean {
    return Double.isInfinite__D(value);
  }
  public function isNaN__(): Boolean {
    return Double.isNaN__D(value);
  }
  public override function longValue__(): Number {
    return Number(value);
  }
  public override function shortValue__(): int {
    return int(value);
  }
  public function toString__(): String {
    return Double.toString__D(value);
  }
  public function compareTo__Ljava_lang_Object_2(arg0: Object): int {
    return arg0.compareTo__Ljava_lang_Double_2();
  }
  public function Double(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is Number) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is String) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Double__D(args0[0]);
        break;
      case 1:
        Double__Ljava_lang_String_2(args1[0]);
        break;
    }
  }
  public static const Double__D : int = 0;
  public static const Double__Ljava_lang_String_2 : int = 1;
}
}
