package java.lang {
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Integer extends Number__ implements Comparable {
  public static var TYPE: java.lang.Class__ = new java.lang.Class__(new Arguments(java.lang.Class__.Class____Ljava_lang_String_2, ["int"]));
  public static const MAX_VALUE: int = 0x7fffffff;
  public static const MIN_VALUE: int = -2147483648;
  public static const SIZE: int = 32;
  private var value: int;
  public static function bitCount__I(x: int): int {
    x -= ((x >> 1) & 0x55555555);
    x = (((x >> 2) & 0x33333333) + (x & 0x33333333));
    x = (((x >> 4) + x) & 0x0f0f0f0f);
    x += (x >> 8);
    x += (x >> 16);
    return x & 0x0000003f;
  }
  public static function decode__Ljava_lang_String_2(s: String): Integer {
    return new Integer(new Arguments(java.lang.Integer.Integer__I, [int(Number__.__decodeAndValidateInt__Ljava_lang_String_2II(s, -2147483648, 2147483647))]));
  }
  public static function hashCode__I(i: int): int {
    return i;
  }
  public static function highestOneBit__I(i: int): int {
    if (i < 0) {
      return -2147483648;
    } else if (i == 0) {
      return 0;
    } else {
      var rtn: int;
      for (rtn = 0x40000000; (rtn & i) == 0; rtn >>= 1) {
      }
      return rtn;
    }
    return 0;
  }
  public static function lowestOneBit__I(i: int): int {
    return i & -i;
  }
  public static function numberOfLeadingZeros__I(i: int): int {
    if (i < 0) {
      return 0;
    } else if (i == 0) {
      return 32;
    } else {
      return 32 - 1 - int(Math__.floor__D(Math__.log__D(i) / Math__.log__D(2.0)));
    }
    return 0;
  }
  public static function numberOfTrailingZeros__I(i: int): int {
    if (i == 0) {
      return 32;
    } else {
      var rtn: int = 0;
      for (var r: int = 1; (r & i) == 0; r <<= 1) {
        rtn++;
      }
      return rtn;
    }
    return 0;
  }
  public static function parseInt__Ljava_lang_String_2(s: String): int {
    return parseInt__Ljava_lang_String_2I(s, 10);
  }
  public static function parseInt__Ljava_lang_String_2I(s: String, radix: int): int {
    return Number__.__parseAndValidateInt__Ljava_lang_String_2III(s, radix, -2147483648, 2147483647);
  }
  public static function reverse__I(i: int): int {
    var nibbles: JavaArray = Integer$ReverseNibbles.access$0();
    return (nibbles[i >>> 28]) | (nibbles[(i >> 24) & 0xf] << 4) | (nibbles[(i >> 20) & 0xf] << 8) | (nibbles[(i >> 16) & 0xf] << 12) | (nibbles[(i >> 12) & 0xf] << 16) | (nibbles[(i >> 8) & 0xf] << 20) | (nibbles[(i >> 4) & 0xf] << 24) | (nibbles[i & 0xf] << 28);
  }
  public static function reverseBytes__I(i: int): int {
    return ((i & 0xff) << 24) | ((i & 0xff00) << 8) | ((i & 0xff0000) >> 8) | ((i & 0xff000000) >>> 24);
  }
  public static function rotateLeft__II(i: int, distance: int): int {
    while (distance-- > 0) {
      i = i << 1 | ((i < 0) ? 1 : 0);
    }
    return i;
  }
  public static function rotateRight__II(i: int, distance: int): int {
    var ui: int = i & 2147483647;
    var carry: int = (i < 0) ? 0x40000000 : 0;
    while (distance-- > 0) {
      var nextcarry: int = ui & 1;
      ui = carry | (ui >> 1);
      carry = (nextcarry == 0) ? 0 : 0x40000000;
    }
    if (carry != 0) {
      ui = ui | -2147483648;
    }
    return ui;
  }
  public static function signum__I(i: int): int {
    if (i == 0) {
      return 0;
    } else if (i < 0) {
      return -1;
    } else {
      return 1;
    }
    return 0;
  }
  public static function toBinaryString__I(value: int): String {
    return toPowerOfTwoString__II(value, 1);
  }
  public static function toHexString__I(value: int): String {
    return toPowerOfTwoString__II(value, 4);
  }
  public static function toOctalString__I(value: int): String {
    return toPowerOfTwoString__II(value, 3);
  }
  public static function toString__I(value: int): String {
    return Object(String).valueOf__I(value);
  }
  public static function toString__II(value: int, radix: int): String {
    if (radix == 10 || radix < 2 || radix > 36) {
      return Object(String).valueOf__I(value);
    }
    var bufSize: int = 33;
    var buf: JavaArray = new JavaArray("[C").lengths(33);
    var pos: int = 33 - 1;
    if (value >= 0) {
      while (value >= radix) {
        buf[pos--] = Number$__Digits.digits[value % radix];
        value /= radix;
      }
      buf[pos] = Number$__Digits.digits[value];
    } else {
      while (value <= -radix) {
        buf[pos--] = Number$__Digits.digits[-(value % radix)];
        value /= radix;
      }
      buf[pos--] = Number$__Digits.digits[-value];
      buf[pos] = 45;
    }
    return Object(String).valueOf___3CII(buf, pos, 33);
  }
  public static function valueOf__I(i: int): Integer {
    if (i > -129 && i < 128) {
      var rebase: int = i + 128;
      var result: Integer = Integer$BoxedValues.access$0()[rebase];
      if (result === null) {
        result = Integer$BoxedValues.access$0()[rebase] = new Integer(new Arguments(java.lang.Integer.Integer__I, [i]));
      }
      return result;
    }
    return new Integer(new Arguments(java.lang.Integer.Integer__I, [i]));
  }
  public static function valueOf__Ljava_lang_String_2(s: String): Integer {
    return new Integer(new Arguments(java.lang.Integer.Integer__I, [parseInt__Ljava_lang_String_2(s)]));
  }
  public static function valueOf__Ljava_lang_String_2I(s: String, radix: int): Integer {
    return new Integer(new Arguments(java.lang.Integer.Integer__I, [parseInt__Ljava_lang_String_2I(s, radix)]));
  }
  private static function toPowerOfTwoString__II(value: int, shift: int): String {
    var bufSize: int = int(32 / shift);
    var bitMask: int = (1 << shift) - 1;
    var buf: JavaArray = new JavaArray("[C").lengths(bufSize);
    var pos: int = bufSize - 1;
    if (value >= 0) {
      while (value > bitMask) {
        buf[pos--] = Number$__Digits.digits[value & bitMask];
        value >>= shift;
      }
    } else {
      while (pos > 0) {
        buf[pos--] = Number$__Digits.digits[value & bitMask];
        value >>= shift;
      }
    }
    buf[pos] = Number$__Digits.digits[value & bitMask];
    return Object(String).valueOf___3CII(buf, pos, bufSize - pos);
  }
  public function Integer__I(value: int): Object {
    this.value = value;
    return this;
  }
  public function Integer__Ljava_lang_String_2(s: String): Object {
    value = Integer.parseInt__Ljava_lang_String_2(s);
    return this;
  }
  public override function byteValue__(): int {
    return int(value);
  }
  public function compareTo__Ljava_lang_Integer_2(b: Integer): int {
    if (value < b.value) {
      return -1;
    } else if (value > b.value) {
      return 1;
    } else {
      return 0;
    }
    return 0;
  }
  public override function doubleValue__(): Number {
    return value;
  }
  public function equals__Ljava_lang_Object_2(o: Object): Boolean {
    return (o is Integer) && ((Integer(o)).value == value);
  }
  public override function floatValue__(): Number {
    return value;
  }
  public function hashCode__(): int {
    return Integer.hashCode__I(value);
  }
  public override function intValue__(): int {
    return value;
  }
  public override function longValue__(): Number {
    return value;
  }
  public override function shortValue__(): int {
    return int(value);
  }
  public function toString__(): String {
    return Integer.toString__I(value);
  }
  public function compareTo__Ljava_lang_Object_2(arg0: Object): int {
    return arg0.compareTo__Ljava_lang_Integer_2();
  }
  public function Integer(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is int) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is String) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Integer__I(args0[0]);
        break;
      case 1:
        Integer__Ljava_lang_String_2(args1[0]);
        break;
    }
  }
  public static const Integer__I : int = 0;
  public static const Integer__Ljava_lang_String_2 : int = 1;
}
}
