package java.lang {
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Long extends Number__ implements Comparable {
  public static var TYPE: java.lang.Class__ = new java.lang.Class__(new Arguments(java.lang.Class__.Class____Ljava_lang_String_2, ["long"]));
  public static const MAX_VALUE: Number = 9223372036854775807;
  public static const MIN_VALUE: Number = -9223372036854775808;
  public static const SIZE: int = 64;
  private var value: Number = 0;
  public static function bitCount__J(i: Number): int {
    var high: int = int((i >> 32));
    var low: int = int(i);
    return Integer.bitCount__I(high) + Integer.bitCount__I(low);
  }
  public static function decode__Ljava_lang_String_2(s: String): Long {
    var decode: Number$__Decode = Number__.__decodeNumberString__Ljava_lang_String_2(s);
    return new Long(new Arguments(java.lang.Long.Long__J, [parseLong__Ljava_lang_String_2I(decode.payload, decode.radix)]));
  }
  public static function hashCode__J(l: Number): int {
    return int(l);
  }
  public static function highestOneBit__J(i: Number): Number {
    var high: int = int((i >> 32));
    if (high != 0) {
      return (Number(Integer.highestOneBit__I(high))) << 32;
    } else {
      return Integer.highestOneBit__I(int(i));
    }
    return 0;
  }
  public static function lowestOneBit__J(i: Number): Number {
    return i & -i;
  }
  public static function numberOfLeadingZeros__J(i: Number): int {
    var high: int = int((i >> 32));
    if (high != 0) {
      return Integer.numberOfLeadingZeros__I(high);
    } else {
      return Integer.numberOfLeadingZeros__I(int(i)) + 32;
    }
    return 0;
  }
  public static function numberOfTrailingZeros__J(i: Number): int {
    var low: int = int(i);
    if (low != 0) {
      return Integer.numberOfTrailingZeros__I(low);
    } else {
      return Integer.numberOfTrailingZeros__I(int((i >> 32))) + 32;
    }
    return 0;
  }
  public static function parseLong__Ljava_lang_String_2(s: String): Number {
    return parseLong__Ljava_lang_String_2I(s, 10);
  }
  public static function parseLong__Ljava_lang_String_2I(orig: String, intRadix: int): Number {
    if (orig === null) {
      throw new NumberFormatException(new Arguments(java.lang.NumberFormatException.NumberFormatException__Ljava_lang_String_2, ["null"]));
    }
    if (Object(orig).length__() == 0) {
      throw NumberFormatException.forInputString__Ljava_lang_String_2(orig);
    }
    if (intRadix < 2 || intRadix > 36) {
      throw new NumberFormatException(new Arguments(java.lang.NumberFormatException.NumberFormatException__Ljava_lang_String_2, ["radix " + intRadix + " out of range"]));
    }
    var neg: Boolean = false;
    var s: String;
    if (Object(orig).charAt__I(0) == 45) {
      neg = true;
      s = Object(orig).substring__I(1);
    } else {
      s = orig;
    }
    var result: Number = 0;
    if (intRadix == 16) {
      result = parseHex__Ljava_lang_String_2(s);
    } else {
      var radix: Number = intRadix;
      for (var i: int = 0, len: int = Object(s).length__(); i < len; ++i) {
        if (result < 0) {
          throw NumberFormatException.forInputString__Ljava_lang_String_2(s);
        }
        result *= radix;
        var c: uint = Object(s).charAt__I(i);
        var value: int = Character.digit__CI(c, intRadix);
        if (value < 0) {
          throw NumberFormatException.forInputString__Ljava_lang_String_2(s);
        }
        result += value;
      }
    }
    if (result < 0 && result != -1) {
      throw NumberFormatException.forInputString__Ljava_lang_String_2(s);
    }
    if (neg) {
      return -result;
    } else {
      return result;
    }
    return 0;
  }
  public static function reverse__J(i: Number): Number {
    var high: int = int((i >>> 32));
    var low: int = int(i);
    return (Number(Integer.reverse__I(low)) << 32) | (Integer.reverse__I(high) & 4294967295);
  }
  public static function reverseBytes__J(i: Number): Number {
    var high: int = int((i >>> 32));
    var low: int = int(i);
    return (Number(Integer.reverseBytes__I(low)) << 32) | (Integer.reverseBytes__I(high) & 4294967295);
  }
  public static function rotateLeft__JI(i: Number, distance: int): Number {
    while (distance-- > 0) {
      i = i << 1 | ((i < 0) ? 1 : 0);
    }
    return i;
  }
  public static function rotateRight__JI(i: Number, distance: int): Number {
    var ui: Number = i & -1;
    var carry: Number = (i < 0) ? 4611686018427387904 : 0;
    while (distance-- > 0) {
      var nextcarry: Number = ui & 1;
      ui = carry | (ui >> 1);
      carry = (nextcarry == 0) ? 0 : 4611686018427387904;
    }
    if (carry != 0) {
      ui = ui | -1;
    }
    return ui;
  }
  public static function signum__J(i: Number): int {
    if (i == 0) {
      return 0;
    } else if (i < 0) {
      return -1;
    } else {
      return 1;
    }
    return 0;
  }
  public static function toBinaryString__J(value: Number): String {
    return toPowerOfTwoString__JI(value, 1);
  }
  public static function toHexString__J(value: Number): String {
    return toPowerOfTwoString__JI(value, 4);
  }
  public static function toOctalString__J(value: Number): String {
    return toPowerOfTwoString__JI(value, 3);
  }
  public static function toString__J(value: Number): String {
    return Object(String).valueOf__J(value);
  }
  public static function toString__JI(value: Number, intRadix: int): String {
    if (intRadix == 10 || intRadix < 2 || intRadix > 36) {
      return Object(String).valueOf__J(value);
    }
    var bufSize: int = 65;
    var buf: JavaArray = new JavaArray("[C").lengths(65);
    var pos: int = 65 - 1;
    var radix: Number = intRadix;
    if (value >= 0) {
      while (value >= radix) {
        buf[pos--] = Number$__Digits.digits[int((value % radix))];
        value /= radix;
      }
      buf[pos] = Number$__Digits.digits[int(value)];
    } else {
      while (value <= -radix) {
        buf[pos--] = Number$__Digits.digits[int(-(value % radix))];
        value /= radix;
      }
      buf[pos--] = Number$__Digits.digits[int(-value)];
      buf[pos] = 45;
    }
    return Object(String).valueOf___3CII(buf, pos, 65);
  }
  public static function valueOf__J(i: Number): Long {
    if (i > -129 && i < 128) {
      var rebase: int = int(i) + 128;
      var result: Long = Long$BoxedValues.boxedValues[rebase];
      if (result === null) {
        result = Long$BoxedValues.boxedValues[rebase] = new Long(new Arguments(java.lang.Long.Long__J, [i]));
      }
      return result;
    }
    return new Long(new Arguments(java.lang.Long.Long__J, [i]));
  }
  public static function valueOf__Ljava_lang_String_2(s: String): Long {
    return new Long(new Arguments(java.lang.Long.Long__J, [parseLong__Ljava_lang_String_2(s)]));
  }
  public static function valueOf__Ljava_lang_String_2I(s: String, radix: int): Long {
    return new Long(new Arguments(java.lang.Long.Long__J, [parseLong__Ljava_lang_String_2I(s, radix)]));
  }
  private static function hexDigit__CLjava_lang_String_2(c: uint, s: String): int {
    var val = java.lang.Long$HexLookup.hexLookup[c];
    if (val == null) {
    throw java.lang.NumberFormatException.forInputString__Ljava_lang_String_2(s);
    }
    return val;
  }
  private static function parseHex__Ljava_lang_String_2(s: String): Number {
    var len: int = Object(s).length__();
    if (len > 16) {
      throw NumberFormatException.forInputString__Ljava_lang_String_2(s);
    }
    var result: Number = 0;
    for (var i: int = 0; i < len; ++i) {
      result <<= 4;
      result += hexDigit__CLjava_lang_String_2(Object(s).charAt__I(i), s);
    }
    return result;
  }
  private static function toPowerOfTwoString__JI(value: Number, shift: int): String {
    var bufSize: int = int(64 / shift);
    var bitMask: Number = (1 << shift) - 1;
    var buf: JavaArray = new JavaArray("[C").lengths(bufSize);
    var pos: int = bufSize - 1;
    if (value >= 0) {
      while (value > bitMask) {
        buf[pos--] = Number$__Digits.digits[int((value & bitMask))];
        value >>= shift;
      }
    } else {
      while (pos > 0) {
        buf[pos--] = Number$__Digits.digits[int((value & bitMask))];
        value >>= shift;
      }
    }
    buf[pos] = Number$__Digits.digits[int((value & bitMask))];
    return Object(String).valueOf___3CII(buf, pos, bufSize);
  }
  public function Long__J(value: Number): Object {
    this.value = value;
    return this;
  }
  public function Long__Ljava_lang_String_2(s: String): Object {
    value = Long.parseLong__Ljava_lang_String_2(s);
    return this;
  }
  public override function byteValue__(): int {
    return int(value);
  }
  public function compareTo__Ljava_lang_Long_2(b: Long): int {
    if (value < b.value) {
      return -1;
    } else if (value > b.value) {
      return 1;
    } else {
      return 0;
    }
    return 0;
  }
  public override function doubleValue__(): Number {
    return value;
  }
  public function equals__Ljava_lang_Object_2(o: Object): Boolean {
    return (o is Long) && ((Long(o)).value == value);
  }
  public override function floatValue__(): Number {
    return value;
  }
  public function hashCode__(): int {
    return Long.hashCode__J(value);
  }
  public override function intValue__(): int {
    return int(value);
  }
  public override function longValue__(): Number {
    return value;
  }
  public override function shortValue__(): int {
    return int(value);
  }
  public function toString__(): String {
    return Long.toString__J(value);
  }
  public function compareTo__Ljava_lang_Object_2(arg0: Object): int {
    return arg0.compareTo__Ljava_lang_Long_2();
  }
  public function Long(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is Number) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is String) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Long__J(args0[0]);
        break;
      case 1:
        Long__Ljava_lang_String_2(args1[0]);
        break;
    }
  }
  public static const Long__J : int = 0;
  public static const Long__Ljava_lang_String_2 : int = 1;
}
}
