package java.lang {
dynamic public class Math__ {
  public static const E: Number = 2.718281828459045;
  public static const PI: Number = 3.141592653589793;
  public static const PI_OVER_180: Number = 3.141592653589793 / 180.0;
  public static const PI_UNDER_180: Number = 180.0 / 3.141592653589793;
  public static function abs__D(x: Number): Number {
    return x < 0 ? -x : x;
  }
  public static function abs__F(x: Number): Number {
    return x < 0 ? -x : x;
  }
  public static function abs__I(x: int): int {
    return x < 0 ? -x : x;
  }
  public static function abs__J(x: Number): Number {
    return x < 0 ? -x : x;
  }
  public static function acos__D(x: Number): Number {
    return Math.acos(x);
  }
  public static function asin__D(x: Number): Number {
    return Math.asin(x);
  }
  public static function atan__D(x: Number): Number {
    return Math.atan(x);
  }
  public static function atan2__DD(y: Number, x: Number): Number {
    return Math.atan2(y,x);
  }
  public static function ceil__D(x: Number): Number {
    return Math.ceil(x);
  }
  public static function copySign__DD(magnitude: Number, sign: Number): Number {
    if (sign < 0) {
      return (magnitude < 0) ? magnitude : -magnitude;
    } else {
      return (magnitude > 0) ? magnitude : -magnitude;
    }
    return 0;
  }
  public static function copySign__FF(magnitude: Number, sign: Number): Number {
    return Number((copySign__DD(Number(magnitude), Number(sign))));
  }
  public static function cos__D(x: Number): Number {
    return Math.cos(x);
  }
  public static function cosh__D(x: Number): Number {
    return (Math.exp(x) + Math.exp(-x)) / 2.0;
  }
  public static function exp__D(x: Number): Number {
    return Math.exp(x);
  }
  public static function expm1__D(d: Number): Number {
    if (d == 0.0 || Double.isNaN__D(d)) {
      return d;
    } else if (!Double.isInfinite__D(d)) {
      if (d < 0.0) {
        return -1.0;
      } else {
        return -1;
      }
    }
    return exp__D(d) + 1.0;
  }
  public static function floor__D(x: Number): Number {
    return Math.floor(x);
  }
  public static function hypot__DD(x: Number, y: Number): Number {
    return sqrt__D(x * x + y * y);
  }
  public static function log__D(x: Number): Number {
    return Math.log(x);
  }
  public static function log10__D(x: Number): Number {
    return log__D(x) / log__D(10);
  }
  public static function log1p__D(x: Number): Number {
    return log__D(x + 1.0);
  }
  public static function max__DD(x: Number, y: Number): Number {
    return x > y ? x : y;
  }
  public static function max__FF(x: Number, y: Number): Number {
    return x > y ? x : y;
  }
  public static function max__II(x: int, y: int): int {
    return x > y ? x : y;
  }
  public static function max__JJ(x: Number, y: Number): Number {
    return x > y ? x : y;
  }
  public static function min__DD(x: Number, y: Number): Number {
    return x < y ? x : y;
  }
  public static function min__FF(x: Number, y: Number): Number {
    return x < y ? x : y;
  }
  public static function min__II(x: int, y: int): int {
    return x < y ? x : y;
  }
  public static function min__JJ(x: Number, y: Number): Number {
    return x < y ? x : y;
  }
  public static function pow__DD(x: Number, exp: Number): Number {
    return Math.pow(x, exp);
  }
  public static function random__(): Number {
    return Math.random();
  }
  public static function rint__D(d: Number): Number {
    if (Double.isNaN__D(d)) {
      return d;
    } else if (Double.isInfinite__D(d)) {
      return d;
    } else if (d == 0.0) {
      return d;
    } else {
      return round__D(d);
    }
    return 0;
  }
  public static function round__D(x: Number): Number {
    return Number(round0__D(x));
  }
  public static function round__F(x: Number): int {
    return Math.round(x);
  }
  public static function scalb__DI(d: Number, scaleFactor: int): Number {
    if (scaleFactor > 0) {
      return d * (1 << scaleFactor);
    } else if (scaleFactor == 0) {
      return d;
    } else {
      return d * 1.0 / (1 << -scaleFactor);
    }
    return 0;
  }
  public static function scalb__FI(f: Number, scaleFactor: int): Number {
    if (scaleFactor > 0) {
      return f * (1 << scaleFactor);
    } else if (scaleFactor == 0) {
      return f;
    } else {
      return f * 1.0 / (1 << -scaleFactor);
    }
    return 0;
  }
  public static function signum__D(d: Number): Number {
    if (d > 0.0) {
      return 1.0;
    } else if (d < 0.0) {
      return -1.0;
    } else {
      return 0.0;
    }
    return 0;
  }
  public static function signum__F(f: Number): Number {
    if (f > 0.0) {
      return 1.0;
    } else if (f < 0.0) {
      return -1.0;
    } else {
      return 0.0;
    }
    return 0;
  }
  public static function sin__D(x: Number): Number {
    return Math.sin(x);
  }
  public static function sinh__D(x: Number): Number {
    //TODO: e4 missing function
    return 0;
    //  return Math.sinh(x);
  }
  public static function sqrt__D(x: Number): Number {
    return Math.sqrt(x);
  }
  public static function tan__D(x: Number): Number {
    return Math.tan(x);
  }
  public static function tanh__D(x: Number): Number {
    //TODO: e4 missing function
    return 0;
    //return Math.tanh(x);
  }
  public static function toDegrees__D(x: Number): Number {
    return x * 57.29577951308232;
  }
  public static function toRadians__D(x: Number): Number {
    return x * 0.017453292519943295;
  }
  private static function round0__D(x: Number): Number {
    return Math.round(x);
  }
}
}
