package java.lang {
import com.google.gwt.core.client.JavaScriptObject;
import java.io.Serializable;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Number__ implements Serializable {
  public static var floatRegex: Object;
  public static function __decodeAndValidateInt__Ljava_lang_String_2II(s: String, lowerBound: int, upperBound: int): Number {
    var decode: Number$__Decode = __decodeNumberString__Ljava_lang_String_2(s);
    return __parseAndValidateInt__Ljava_lang_String_2III(decode.payload, decode.radix, lowerBound, upperBound);
  }
  public static function __decodeNumberString__Ljava_lang_String_2(s: String): Number$__Decode {
    var negative: Boolean;
    if (Object(s).startsWith__Ljava_lang_String_2("-")) {
      negative = true;
      s = Object(s).substring__I(1);
    } else {
      negative = false;
    }
    var radix: int;
    if (Object(s).startsWith__Ljava_lang_String_2("0x") || Object(s).startsWith__Ljava_lang_String_2("0X")) {
      s = Object(s).substring__I(2);
      radix = 16;
    } else if (Object(s).startsWith__Ljava_lang_String_2("#")) {
      s = Object(s).substring__I(1);
      radix = 16;
    } else if (Object(s).startsWith__Ljava_lang_String_2("0")) {
      radix = 8;
    } else {
      radix = 10;
    }
    if (negative) {
      s = "-" + s;
    }
    return new Number$__Decode(radix, s);
  }
  public static function __parseAndValidateDouble__Ljava_lang_String_2(s: String): Number {
    var toReturn: Number = __parseDouble__Ljava_lang_String_2(s);
    if (__isNaN__D(toReturn)) {
      throw NumberFormatException.forInputString__Ljava_lang_String_2(s);
    }
    return toReturn;
  }
  public static function __parseAndValidateInt__Ljava_lang_String_2III(s: String, radix: int, lowerBound: int, upperBound: int): int {
    if (s === null) {
      throw new NumberFormatException(new Arguments(java.lang.NumberFormatException.NumberFormatException__Ljava_lang_String_2, ["null"]));
    }
    if (radix < 2 || radix > 36) {
      throw new NumberFormatException(new Arguments(java.lang.NumberFormatException.NumberFormatException__Ljava_lang_String_2, ["radix " + radix + " out of range"]));
    }
    var length: int = Object(s).length__();
    var startIndex: int = (length > 0) && (Object(s).charAt__I(0) == 45) ? 1 : 0;
    for (var i: int = startIndex; i < length; i++) {
      if (Character.digit__CI(Object(s).charAt__I(i), radix) == -1) {
        throw NumberFormatException.forInputString__Ljava_lang_String_2(s);
      }
    }
    var toReturn: int = __parseInt__Ljava_lang_String_2I(s, radix);
    if (__isNaN__D(toReturn)) {
      throw NumberFormatException.forInputString__Ljava_lang_String_2(s);
    } else if (toReturn < lowerBound || toReturn > upperBound) {
      throw NumberFormatException.forInputString__Ljava_lang_String_2(s);
    }
    return toReturn;
  }
  private static function __isNaN__D(x: Number): Boolean {
    return isNaN(x);
  }
  private static function __parseDouble__Ljava_lang_String_2(str: String): Number {
    var floatRegex = java.lang.Number__.floatRegex;
    if (!floatRegex) {
    floatRegex = java.lang.Number__.floatRegex = /^[+-]?\d*\.?\d*(e[+-]?\d+)?$/i;
    }
    if (floatRegex.test(str)) {
    return parseFloat(str);
    } else {
    return Number.NaN;
    }
  }
  private static function __parseInt__Ljava_lang_String_2I(s: String, radix: int): int {
    return parseInt(s, radix);
  }
  public function byteValue__(): int {
    return int(this.intValue__());
  }
  public function doubleValue__(): Number { // abstract
    return 0.0;
  }
  public function floatValue__(): Number { // abstract
    return 0.0;
  }
  public function intValue__(): int { // abstract
    return 0;
  }
  public function longValue__(): Number { // abstract
    return 0;
  }
  public function shortValue__(): int {
    return int(this.intValue__());
  }
}
}
