package java.lang {
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class StringBuilder implements CharSequence {
  private var arrayLen: int = 0;
  private var stringArray: JavaArray = new JavaArray("[Ljava/lang/String;").lengths(0);
  private var stringLength: int = 0;
  private static function join___3Ljava_lang_String_2(stringArray: JavaArray): String {
    return stringArray.join('');
  }
  private static function setLength___3Ljava_lang_String_2I(stringArray: JavaArray, length: int): void {
    stringArray.length = length;
  }
  public function StringBuilder__(): Object {
    return this;
  }
  public function StringBuilder__Ljava_lang_CharSequence_2(s: CharSequence): Object {
    return this;
  }
  public function StringBuilder__I(ignoredCapacity: int): Object {
    return this;
  }
  public function StringBuilder__Ljava_lang_String_2(s: String): Object {
    this.append__Ljava_lang_String_2(s);
    return this;
  }
  public function append__Z(x: Boolean): StringBuilder {
    return this.append__Ljava_lang_String_2(Object(String).valueOf__Z(x));
  }
  public function append__C(x: uint): StringBuilder {
    return this.append__Ljava_lang_String_2(Object(String).valueOf__C(x));
  }
  public function append___3C(x: JavaArray): StringBuilder {
    return this.append__Ljava_lang_String_2(Object(String).valueOf___3C(x));
  }
  public function append___3CII(x: JavaArray, start: int, len: int): StringBuilder {
    return this.append__Ljava_lang_String_2(Object(String).valueOf___3CII(x, start, len));
  }
  public function append__Ljava_lang_CharSequence_2(x: CharSequence): StringBuilder {
    return this.append__Ljava_lang_String_2(Object(x).toString__());
  }
  public function append__Ljava_lang_CharSequence_2II(x: CharSequence, start: int, end: int): StringBuilder {
    return this.append__Ljava_lang_CharSequence_2(x.subSequence__II(start, end));
  }
  public function append__D(x: Number): StringBuilder {
    return this.append__Ljava_lang_String_2(Object(String).valueOf__D(x));
  }
  public function append__F(x: Number): StringBuilder {
    return this.append__Ljava_lang_String_2(Object(String).valueOf__F(x));
  }
  public function append__I(x: int): StringBuilder {
    return this.append__Ljava_lang_String_2(Object(String).valueOf__I(x));
  }
  public function append__J(x: Number): StringBuilder {
    return this.append__Ljava_lang_String_2(Object(String).valueOf__J(x));
  }
  public function append__Ljava_lang_Object_2(x: Object): StringBuilder {
    return this.append__Ljava_lang_String_2(Object(String).valueOf__Ljava_lang_Object_2(x));
  }
  public function append__Ljava_lang_String_2(toAppend: String): StringBuilder {
    if (toAppend === null) {
      toAppend = "null";
    }
    var appendLength: int = Object(toAppend).length__();
    if (appendLength > 0) {
      StringBuilder.setLength___3Ljava_lang_String_2I(stringArray, 1024);
      stringArray[arrayLen++] = toAppend;
      stringLength += appendLength;
      if (arrayLen > 1024) {
        this.toString__();
        StringBuilder.setLength___3Ljava_lang_String_2I(stringArray, 1024);
      }
    }
    return this;
  }
  public function append__Ljava_lang_StringBuffer_2(x: StringBuffer): StringBuilder {
    return this.append__Ljava_lang_String_2(Object(String).valueOf__Ljava_lang_Object_2(x));
  }
  public function capacity__(): int {
    return 2147483647;
  }
  public function charAt__I(index: int): uint {
    return Object(this.toString__()).charAt__I(index);
  }
  public function delete__II(start: int, end: int): StringBuilder {
    return this.replace__IILjava_lang_String_2(start, end, "");
  }
  public function deleteCharAt__I(start: int): StringBuilder {
    return this.delete__II(start, start + 1);
  }
  public function ensureCapacity__I(ignoredCapacity: int): void {
  }
  public function getChars__II_3CI(srcStart: int, srcEnd: int, dst: JavaArray, dstStart: int): void {
    Object(String).__checkBounds__III(stringLength, srcStart, srcEnd);
    Object(String).__checkBounds__III(dst.length, dstStart, dstStart + (srcEnd - srcStart));
    var s: String = this.toString__();
    while (srcStart < srcEnd) {
      dst[dstStart++] = Object(s).charAt__I(srcStart++);
    }
    return;
  }
  public function indexOf__Ljava_lang_String_2(x: String): int {
    return Object(this.toString__()).indexOf__Ljava_lang_String_2(x);
  }
  public function indexOf__Ljava_lang_String_2I(x: String, start: int): int {
    return Object(this.toString__()).indexOf__Ljava_lang_String_2I(x, start);
  }
  public function insert__IZ(index: int, x: Boolean): StringBuilder {
    return this.insert__ILjava_lang_String_2(index, Object(String).valueOf__Z(x));
  }
  public function insert__IC(index: int, x: uint): StringBuilder {
    return this.insert__ILjava_lang_String_2(index, Object(String).valueOf__C(x));
  }
  public function insert__I_3C(index: int, x: JavaArray): StringBuilder {
    return this.insert__ILjava_lang_String_2(index, Object(String).valueOf___3C(x));
  }
  public function insert__I_3CII(index: int, x: JavaArray, offset: int, len: int): StringBuilder {
    return this.insert__ILjava_lang_String_2(index, Object(String).valueOf___3CII(x, offset, len));
  }
  public function insert__ILjava_lang_CharSequence_2(index: int, chars: CharSequence): StringBuilder {
    return this.insert__ILjava_lang_String_2(index, Object(chars).toString__());
  }
  public function insert__ILjava_lang_CharSequence_2II(index: int, chars: CharSequence, start: int, end: int): StringBuilder {
    return this.insert__ILjava_lang_String_2(index, Object(chars.subSequence__II(start, end)).toString__());
  }
  public function insert__ID(index: int, x: Number): StringBuilder {
    return this.insert__ILjava_lang_String_2(index, Object(String).valueOf__D(x));
  }
  public function insert__IF(index: int, x: Number): StringBuilder {
    return this.insert__ILjava_lang_String_2(index, Object(String).valueOf__F(x));
  }
  public function insert__II(index: int, x: int): StringBuilder {
    return this.insert__ILjava_lang_String_2(index, Object(String).valueOf__I(x));
  }
  public function insert__IJ(index: int, x: Number): StringBuilder {
    return this.insert__ILjava_lang_String_2(index, Object(String).valueOf__J(x));
  }
  public function insert__ILjava_lang_Object_2(index: int, x: Object): StringBuilder {
    return this.insert__ILjava_lang_String_2(index, Object(String).valueOf__Ljava_lang_Object_2(x));
  }
  public function insert__ILjava_lang_String_2(index: int, x: String): StringBuilder {
    return this.replace__IILjava_lang_String_2(index, index, x);
  }
  public function lastIndexOf__Ljava_lang_String_2(s: String): int {
    return Object(this.toString__()).lastIndexOf__Ljava_lang_String_2(s);
  }
  public function lastIndexOf__Ljava_lang_String_2I(s: String, start: int): int {
    return Object(this.toString__()).lastIndexOf__Ljava_lang_String_2I(s, start);
  }
  public function length__(): int {
    return stringLength;
  }
  public function replace__IILjava_lang_String_2(start: int, end: int, toInsert: String): StringBuilder {
    var s: String = this.toString__();
    stringArray = new JavaArray("[Ljava/lang/String;").values(Object(s).substring__II(0, start), toInsert, Object(s).substring__I(end));
    arrayLen = 3;
    stringLength += Object(toInsert).length__() - (end - start);
    return this;
  }
  public function setCharAt__IC(index: int, x: uint): void {
    this.replace__IILjava_lang_String_2(index, index + 1, Object(String).valueOf__C(x));
  }
  public function setLength__I(newLength: int): void {
    var oldLength: int = stringLength;
    if (newLength < oldLength) {
      this.delete__II(newLength, oldLength);
    } else if (newLength > oldLength) {
      this.append___3C(new JavaArray("[C").lengths(newLength - oldLength));
    }
    return;
  }
  public function subSequence__II(start: int, end: int): CharSequence {
    return new StringBuilderWrapper(this.toString__()).subSequence__II(start, end);
  }
  public function substring__I(begin: int): String {
    return Object(this.toString__()).substring__I(begin);
  }
  public function substring__II(begin: int, end: int): String {
    return Object(this.toString__()).substring__II(begin, end);
  }
  public function toString__(): String {
    if (arrayLen != 1) {
      StringBuilder.setLength___3Ljava_lang_String_2I(stringArray, arrayLen);
      var s: String = StringBuilder.join___3Ljava_lang_String_2(stringArray);
      stringArray = new JavaArray("[Ljava/lang/String;").values(s);
      arrayLen = 1;
    }
    return stringArray[0];
  }
  public function trimToSize__(): void {
  }
  public function StringBuilder(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is CharSequence) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 1 && vargs[0] is int) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 1 && vargs[0] is String) {
        args = vargs;
        id = 3;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        args3 = [Object(args1[0]).toString__()];
        break;
      case 2:
        var args2: Array = [args[0]];
        break;
      case 3:
        var args3: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        StringBuilder__();
        break;
      case 1:
        StringBuilder__Ljava_lang_String_2(args3[0]);
        StringBuilder__Ljava_lang_CharSequence_2(args1[0]);
        break;
      case 2:
        StringBuilder__I(args2[0]);
        break;
      case 3:
        StringBuilder__Ljava_lang_String_2(args3[0]);
        break;
    }
  }
  public static const StringBuilder__ : int = 0;
  public static const StringBuilder__Ljava_lang_CharSequence_2 : int = 1;
  public static const StringBuilder__I : int = 2;
  public static const StringBuilder__Ljava_lang_String_2 : int = 3;
}
}
