package java.lang {
import java.lang.Arguments;
dynamic public class Thread implements Runnable {
  private var name: String;
  private var runnable: Runnable;
  private var priority: int;
  private var daemon: Boolean;
  public static const MAX_PRIORITY: int = 10;
  public static const MIN_PRIORITY: int = 1;
  public static const NORM_PRIORITY: int = 5;
  public static var currentThread: Thread;
  public function Thread__(): Object {
    return this;
  }
  public function Thread__Ljava_lang_Runnable_2(runnable: Runnable): Object {
    return this;
  }
  public function Thread__Ljava_lang_Runnable_2Ljava_lang_String_2(runnable: Runnable, name: String): Object {
    this.runnable = runnable;
    this.name = name;
    this.priority = 5;
    return this;
  }
  public function Thread__Ljava_lang_String_2(name: String): Object {
    return this;
  }
  public static function activeCount__(): int {
    return 1;
  }
  public static function currentThread__(): Thread {
    if (currentThread === null)
      currentThread = new Thread(new Arguments(java.lang.Thread.Thread__Ljava_lang_String_2, ["main"]));
    return currentThread;
  }
  public function getName__(): String {
    return name;
  }
  public function getPriority__(): int {
    return priority;
  }
  public function interrupt__(): void {
  }
  public function isAlive__(): Boolean {
    return true;
  }
  public function isDaemon__(): Boolean {
    return daemon;
  }
  public function join__(): void {
  }
  public function run__(): void {
    if (runnable !== null)
      runnable.run__();
  }
  public function setPriority__I(newPriority: int): void {
    if (!(1 <= newPriority && newPriority <= 10)) {
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__, []));
    }
    this.priority = newPriority;
    return;
  }
  public static function sleep__J(millis: Number): void {
  }
  public function setDaemon__Z(on: Boolean): void {
    this.daemon = on;
    return;
  }
  public function start__(): void {
  }
  public static function yield__(): void {
  }
  public function Thread(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Runnable) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 2 && vargs[0] is Runnable && vargs[1] is String) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 1 && vargs[0] is String) {
        args = vargs;
        id = 3;
      }
    }
    switch (id) {
      case 0:
        args2 = [null, ""];
        break;
      case 1:
        var args1: Array = [args[0]];
        args2 = [args1[0], ""];
        break;
      case 2:
        var args2: Array = [args[0], args[1]];
        break;
      case 3:
        var args3: Array = [args[0]];
        args2 = [null, args3[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Thread__Ljava_lang_Runnable_2Ljava_lang_String_2(args2[0], args2[1]);
        Thread__();
        break;
      case 1:
        Thread__Ljava_lang_Runnable_2Ljava_lang_String_2(args2[0], args2[1]);
        Thread__Ljava_lang_Runnable_2(args1[0]);
        break;
      case 2:
        Thread__Ljava_lang_Runnable_2Ljava_lang_String_2(args2[0], args2[1]);
        break;
      case 3:
        Thread__Ljava_lang_Runnable_2Ljava_lang_String_2(args2[0], args2[1]);
        Thread__Ljava_lang_String_2(args3[0]);
        break;
    }
  }
  public static const Thread__ : int = 0;
  public static const Thread__Ljava_lang_Runnable_2 : int = 1;
  public static const Thread__Ljava_lang_Runnable_2Ljava_lang_String_2 : int = 2;
  public static const Thread__Ljava_lang_String_2 : int = 3;
}
}
