package java.lang {
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Throwable extends Error implements Serializable {
  private var cause: Throwable;
  private var detailMessage: String;
  private var stackTrace: JavaArray;
  public function Throwable__(): Object {
    return this;
  }
  public function Throwable__Ljava_lang_String_2(message: String): Object {
    this.detailMessage = message;
    return this;
  }
  public function Throwable__Ljava_lang_String_2Ljava_lang_Throwable_2(message: String, cause: Throwable): Object {
    this.cause = cause;
    this.detailMessage = message;
    return this;
  }
  public function Throwable__Ljava_lang_Throwable_2(cause: Throwable): Object {
    this.detailMessage = (cause === null) ? null : cause.toString__();
    this.cause = cause;
    return this;
  }
  public function fillInStackTrace__(): Throwable {
    return this;
  }
  public function getCause__(): Throwable {
    return cause;
  }
  public function getLocalizedMessage__(): String {
    return this.getMessage__();
  }
  public function getMessage__(): String {
    return detailMessage;
  }
  public function getStackTrace__(): JavaArray {
    if (stackTrace === null) {
      return new JavaArray("[Ljava/lang/StackTraceElement;").lengths(0);
    }
    return stackTrace;
  }
  public function initCause__Ljava_lang_Throwable_2(cause_1: Throwable): Throwable {
    if (this.cause !== null) {
      throw new IllegalStateException(new Arguments(java.lang.IllegalStateException.IllegalStateException__Ljava_lang_String_2, ["Can\'t overwrite cause"]));
    }
    if (cause_1 === this) {
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__Ljava_lang_String_2, ["Self-causation not permitted"]));
    }
    this.cause = cause_1;
    return this;
  }
  public function printStackTrace__(): void {
    this.printStackTrace__Ljava_io_PrintStream_2(System.err);
  }
  public function printStackTrace__Ljava_io_PrintStream_2(out: PrintStream): void {
    var msg: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__, []));
    var currentCause: Throwable = this;
    while (currentCause !== null) {
      var causeMessage: String = currentCause.getMessage__();
      if (currentCause !== this) {
        msg.append__Ljava_lang_String_2("Caused by: ");
      }
      msg.append__Ljava_lang_String_2(Object(currentCause).getClass__().getName__());
      msg.append__Ljava_lang_String_2(": ");
      msg.append__Ljava_lang_String_2(causeMessage === null ? "(No exception detail)" : causeMessage);
      msg.append__Ljava_lang_String_2("\n");
      currentCause = currentCause.getCause__();
    }
    out.println__Ljava_lang_Object_2(msg);
    return;
  }
  public function setStackTrace___3Ljava_lang_StackTraceElement_2(stackTrace_1: JavaArray): void {
    var copy: JavaArray = new JavaArray("[Ljava/lang/StackTraceElement;").lengths(stackTrace_1.length);
    for (var i: int = 0, c: int = stackTrace_1.length; i < c; ++i) {
      if (stackTrace_1[i] === null) {
        throw new NullPointerException(new Arguments(java.lang.NullPointerException.NullPointerException__, []));
      }
      copy[i] = stackTrace_1[i];
    }
    this.stackTrace = copy;
    return;
  }
  public function toString__(): String {
    var className: String = Object(this).getClass__().getName__();
    var msg: String = this.getMessage__();
    if (msg !== null) {
      return className + ": " + msg;
    } else {
      return className;
    }
    return null;
  }
  public function Throwable(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is String) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 2 && vargs[0] is String && vargs[1] is Throwable) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 1 && vargs[0] is Throwable) {
        args = vargs;
        id = 3;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
      case 2:
        var args2: Array = [args[0], args[1]];
        break;
      case 3:
        var args3: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Throwable__();
        break;
      case 1:
        Throwable__Ljava_lang_String_2(args1[0]);
        break;
      case 2:
        Throwable__Ljava_lang_String_2Ljava_lang_Throwable_2(args2[0], args2[1]);
        break;
      case 3:
        Throwable__Ljava_lang_Throwable_2(args3[0]);
        break;
    }
  }
  public static const Throwable__ : int = 0;
  public static const Throwable__Ljava_lang_String_2 : int = 1;
  public static const Throwable__Ljava_lang_String_2Ljava_lang_Throwable_2 : int = 2;
  public static const Throwable__Ljava_lang_Throwable_2 : int = 3;
}
}
