package java.lang.reflect {
import java.lang.Class__;
import java.lang.JavaArray;
dynamic public class Array__ {
  public static function get__Ljava_lang_Object_2I(array: Object, index: int): Object {
    import java.lang.*;
    if (!(array is JavaArray)) throw new IllegalArgumentException("Argument is not an array");
    var value:* = JavaArray(array)[index];
    var clazz:Class__ = array.getClass__().getComponentType__();
    if (clazz == Byte.TYPE) return new Byte(value);
    if (clazz == Boolean__.TYPE) return new Boolean__(value);
    if (clazz == Character.TYPE) return new Character(value);
    if (clazz == Short.TYPE) return new Short(value);
    if (clazz == Integer.TYPE) return new Integer(value);
    if (clazz == Long.TYPE) return new Long(value);
    if (clazz == Double.TYPE) return new Double(value);
    if (clazz == Float.TYPE) return new Float(value);
    return value;
  }
  public static function getBoolean__Ljava_lang_Object_2I(array: Object, index: int): Boolean {
    import java.lang.*;
    if (!(array is JavaArray)) throw new IllegalArgumentException("Argument is not an array");
    var value:* = JavaArray(array)[index];
    var clazz:Class__ = array.getClass__().getComponentType__();
    if (clazz != Boolean__.TYPE) throw new IllegalArgumentException("Invalid component type");
    return value;
  }
  public static function getByte__Ljava_lang_Object_2I(array: Object, index: int): int {
    import java.lang.*;
    if (!(array is JavaArray)) throw new IllegalArgumentException("Argument is not an array");
    var value:* = JavaArray(array)[index];
    var clazz:Class__ = array.getClass__().getComponentType__();
    if (clazz != Byte.TYPE) throw new IllegalArgumentException("Invalid component type");
    return value;
  }
  public static function getChar__Ljava_lang_Object_2I(array: Object, index: int): uint {
    import java.lang.*;
    if (!(array is JavaArray)) throw new IllegalArgumentException("Argument is not an array");
    var value:* = JavaArray(array)[index];
    var clazz:Class__ = array.getClass__().getComponentType__();
    if (clazz != Character.TYPE) throw new IllegalArgumentException("Invalid component type");
    return value;
  }
  public static function getDouble__Ljava_lang_Object_2I(array: Object, index: int): Number {
    import java.lang.*;
    if (!(array is JavaArray)) throw new IllegalArgumentException("Argument is not an array");
    var value:* = JavaArray(array)[index];
    var clazz:Class__ = array.getClass__().getComponentType__();
    if (clazz != Double.TYPE && clazz != Byte.TYPE && clazz != Short.TYPE &&
    clazz != Character.TYPE && clazz != Integer.TYPE && clazz != Long.TYPE &&
    clazz != Float.TYPE)
    {
    throw new IllegalArgumentException("Invalid component type");
    }
    return value;
  }
  public static function getFloat__Ljava_lang_Object_2I(array: Object, index: int): Number {
    import java.lang.*;
    if (!(array is JavaArray)) throw new IllegalArgumentException("Argument is not an array");
    var value:* = JavaArray(array)[index];
    var clazz:Class__ = array.getClass__().getComponentType__();
    if (clazz != Float.TYPE && clazz != Byte.TYPE && clazz != Short.TYPE &&
    clazz != Character.TYPE && clazz != Integer.TYPE && clazz != Long.TYPE)
    {
    throw new IllegalArgumentException("Invalid component type");
    }
    return value;
  }
  public static function getInt__Ljava_lang_Object_2I(array: Object, index: int): int {
    import java.lang.*;
    if (!(array is JavaArray)) throw new IllegalArgumentException("Argument is not an array");
    var value:* = JavaArray(array)[index];
    var clazz:Class__ = array.getClass__().getComponentType__();
    if (clazz != Byte.TYPE && clazz != Short.TYPE &&
    clazz != Character.TYPE && clazz != Integer.TYPE)
    {
    throw new IllegalArgumentException("Invalid component type");
    }
    return value;
  }
  public static function getLength__Ljava_lang_Object_2(array: Object): int {
    import java.lang.*;
    if (!(array is JavaArray)) throw new IllegalArgumentException();
    return JavaArray(array).length;
  }
  public static function getLong__Ljava_lang_Object_2I(array: Object, index: int): Number {
    import java.lang.*;
    if (!(array is JavaArray)) throw new IllegalArgumentException("Argument is not an array");
    var value:* = JavaArray(array)[index];
    var clazz:Class__ = array.getClass__().getComponentType__();
    if (clazz != Byte.TYPE && clazz != Short.TYPE &&
    clazz != Character.TYPE && clazz != Integer.TYPE && clazz != Long.TYPE)
    {
    throw new IllegalArgumentException("Invalid component type");
    }
    return value;
  }
  public static function getShort__Ljava_lang_Object_2I(array: Object, index: int): int {
    import java.lang.*;
    if (!(array is JavaArray)) throw new IllegalArgumentException("Argument is not an array");
    var value:* = JavaArray(array)[index];
    var clazz:Class__ = array.getClass__().getComponentType__();
    if (clazz != Byte.TYPE && clazz != Short.TYPE)
    {
    throw new IllegalArgumentException("Invalid component type");
    }
    return value;
  }
  public static function newInstance__Ljava_lang_Class_2I(componentType: Class__, length: int): Object {
    import java.lang.JavaArray;
    return new JavaArray("[" + componentType.getName()).lengths(length);
  }
  public static function newInstance__Ljava_lang_Class_2_3I(componentType: Class__, dimensions: JavaArray): Object {
    import java.lang.JavaArray;
    return new JavaArray("[" + componentType.getName()).lengths(dimensions);
  }
  public static function set__Ljava_lang_Object_2ILjava_lang_Object_2(array: Object, index: int, value: Object): void {
    import java.lang.*;
    if (!(array is JavaArray)) throw new IllegalArgumentException("Argument is not an array");
    //TODO check if object can be assigned
    var v:* = value;
    var clazz:Class__ = array.getClass__().getComponentType__();
    if (clazz == Byte.TYPE) v = v[value];
    if (clazz == Boolean__.TYPE) v = v[value];
    if (clazz == Character.TYPE) v = v[value];
    if (clazz == Short.TYPE) v = v[value];
    if (clazz == Integer.TYPE) v = v[value];
    if (clazz == Long.TYPE) v = v[value];
    if (clazz == Double.TYPE) v = v[value];
    if (clazz == Float.TYPE) v = v[value];
    JavaArray(array)[index] = v;
  }
}
}
