package java.sql {
import java.util.Date__;
import java.lang.IllegalArgumentException;
import java.lang.Integer;
import java.lang.NumberFormatException;
import java.lang.StringBuffer;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Timestamp extends java.util.Date__ {
  private var nanos: int;
  public static function valueOf__Ljava_lang_String_2(s: String): Timestamp {
    var components: JavaArray = Object(s).split__Ljava_lang_String_2(" ");
    if (components.length != 2) {
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__Ljava_lang_String_2, ["Invalid escape format: " + s]));
    }
    var timeComponents: JavaArray = Object(components[1]).split__Ljava_lang_String_2("\\.");
    if (timeComponents.length != 2) {
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__Ljava_lang_String_2, ["Invalid escape format: " + s]));
    } else if (Object(timeComponents[1]).length__() != 9) {
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__Ljava_lang_String_2, ["Invalid escape format: " + s]));
    }
    var d: java.sql.Date__ = java.sql.Date__.valueOf__Ljava_lang_String_2(components[0]);
    var t: Time = Time.valueOf__Ljava_lang_String_2(timeComponents[0]);
    var nanos: int;
    try {
      nanos = Integer.valueOf__Ljava_lang_String_2(timeComponents[1]).intValue__();
    } catch (e : NumberFormatException) {
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__Ljava_lang_String_2, ["Invalid escape format: " + s]));
    }
    return new Timestamp(new Arguments(java.sql.Timestamp.Timestamp__IIIIIII, [d.getYear__(), d.getMonth__(), d.getDate__(), t.getHours__(), t.getMinutes__(), t.getSeconds__(), nanos]));
  }
  private static function padNine__I(value: int): String {
    var toReturn: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__Ljava_lang_String_2, ["000000000"]));
    if (!(toReturn.length__() == 9)) {
      throw new java.lang.AssertionError(new Arguments(0, []));
    }
    var asString: String = Object(String).valueOf__I(value);
    toReturn = toReturn.replace__IILjava_lang_String_2(9 - Object(asString).length__(), 9, asString);
    if (!(toReturn.length__() == 9)) {
      throw new java.lang.AssertionError(new Arguments(0, []));
    }
    return toReturn.toString__();
  }
  public function Timestamp__IIIIIII(year: int, month: int, date: int, hour: int, minute: int, second: int, nano: int): Object {
    this.setNanos__I(nano);
    return this;
  }
  public function Timestamp__J(time: Number): Object {
    nanos = ((int((time % 1000))) * 1000000);
    return this;
  }
  public function after__Ljava_sql_Timestamp_2(ts: Timestamp): Boolean {
    return (this.getTime__() > ts.getTime__()) || (this.getTime__() == ts.getTime__() && this.getNanos__() > ts.getNanos__());
  }
  public function before__Ljava_sql_Timestamp_2(ts: Timestamp): Boolean {
    return (this.getTime__() < ts.getTime__()) || (this.getTime__() == ts.getTime__() && this.getNanos__() < ts.getNanos__());
  }
  public override function compareTo__Ljava_util_Date_2(o: java.util.Date__): int {
    return this.compareTo__Ljava_sql_Timestamp_2(Timestamp(o));
  }
  public function compareTo__Ljava_sql_Timestamp_2(o: Timestamp): int {
    var delta: int = int((this.getTime__() - o.getTime__()));
    return delta == 0 ? this.getNanos__() - o.getNanos__() : delta;
  }
  public override function equals__Ljava_lang_Object_2(ts: Object): Boolean {
    return ts is Timestamp ? this.equals__Ljava_sql_Timestamp_2(Timestamp(ts)) : false;
  }
  public function equals__Ljava_sql_Timestamp_2(ts: Timestamp): Boolean {
    return (this.getTime__() == ts.getTime__() && this.getNanos__() == ts.getNanos__());
  }
  public function getNanos__(): int {
    return nanos;
  }
  public override function getTime__(): Number {
    return super.getTime__();
  }
  public override function hashCode__(): int {
    return super.hashCode__();
  }
  public function setNanos__I(n: int): void {
    if (n < 0 || n > 999999999) {
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__Ljava_lang_String_2, ["nanos out of range " + n]));
    }
    nanos = n;
    super.setTime__J((this.getTime__() / 1000) * 1000 + (int(nanos / 1000000)));
    return;
  }
  public override function setTime__J(time: Number): void {
    super.setTime__J(time);
    nanos = ((int((time % 1000))) * 1000000);
    return;
  }
  public override function toString__(): String {
    return Object(String).valueOf__I(1900 + this.getYear__()) + "-" + java.util.Date__.padTwo__I(1 + this.getMonth__()) + "-" + java.util.Date__.padTwo__I(this.getDate__()) + " " + java.util.Date__.padTwo__I(this.getHours__()) + ":" + java.util.Date__.padTwo__I(this.getMinutes__()) + ":" + java.util.Date__.padTwo__I(this.getSeconds__()) + "." + Timestamp.padNine__I(this.getNanos__());
  }
  public function Timestamp(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 7 && vargs[0] is int && vargs[1] is int && vargs[2] is int && vargs[3] is int && vargs[4] is int && vargs[5] is int && vargs[6] is int) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Number) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0], args[1], args[2], args[3], args[4], args[5], args[6]];
        var superArgs: Arguments;
        superArgs = new Arguments(java.util.Date__.Date____IIIIII, [args0[0], args0[1], args0[2], args0[3], args0[4], args0[5]]);
        break;
      case 1:
        var args1: Array = [args[0]];
        superArgs = new Arguments(java.util.Date__.Date____J, [args1[0]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        Timestamp__IIIIIII(args0[0], args0[1], args0[2], args0[3], args0[4], args0[5], args0[6]);
        break;
      case 1:
        Timestamp__J(args1[0]);
        break;
    }
  }
  public static const Timestamp__IIIIIII : int = 0;
  public static const Timestamp__J : int = 1;
}
}
