package java.util {
import com.google.gwt.core.client.JavaScriptObject;
import java.lang.IllegalStateException;
import java.lang.IllegalArgumentException;
import java.lang.Arguments;
dynamic public class AbstractHashMap extends AbstractMap {
  private var hashCodeMap: Object;
  private var nullSlot: Object;
  private var nullSlotLive: Boolean;
  private var size: int;
  private var stringMap: Object;
  public function AbstractHashMap__(): Object {
    {
      this.clearImpl__();
    }
    return this;
  }
  public function AbstractHashMap__I(ignored: int): Object {
    {
      this.clearImpl__();
    }
    return this;
  }
  public function AbstractHashMap__IF(ignored: int, alsoIgnored: Number): Object {
    {
      this.clearImpl__();
    }
    if (ignored < 0 || alsoIgnored < 0) {
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__Ljava_lang_String_2, ["initial capacity was negative or load factor was non-positive"]));
    }
    return this;
  }
  public function AbstractHashMap__Ljava_util_Map_2(toBeCopied: Map): Object {
    {
      this.clearImpl__();
    }
    this.putAll__Ljava_util_Map_2(toBeCopied);
    return this;
  }
  public override function clear__(): void {
    this.clearImpl__();
    return;
  }
  public function clone__(): Object { // abstract
    return null;
  }
  public override function containsKey__Ljava_lang_Object_2(key: Object): Boolean {
    return (key === null) ? nullSlotLive : (!(key is String) ? this.hasHashValue__Ljava_lang_Object_2I(key, this.getHashCode__Ljava_lang_Object_2(key)) : this.hasStringValue__Ljava_lang_String_2(String(key)));
  }
  public override function containsValue__Ljava_lang_Object_2(value: Object): Boolean {
    if (nullSlotLive && this.equals__Ljava_lang_Object_2Ljava_lang_Object_2(nullSlot, value)) {
      return true;
    } else if (this.containsStringValue__Ljava_lang_Object_2(value)) {
      return true;
    } else if (this.containsHashValue__Ljava_lang_Object_2(value)) {
      return true;
    }
    return false;
  }
  public override function entrySet__(): java.util.Set {
    return new AbstractHashMap$EntrySet(this);
  }
  public override function get__Ljava_lang_Object_2(key: Object): Object {
    return (key === null) ? nullSlot : (!(key is String) ? this.getHashValue__Ljava_lang_Object_2I(key, this.getHashCode__Ljava_lang_Object_2(key)) : this.getStringValue__Ljava_lang_String_2(String(key)));
  }
  public override function put__Ljava_lang_Object_2Ljava_lang_Object_2(key: Object, value: Object): Object {
    return (key === null) ? this.putNullSlot__Ljava_lang_Object_2(value) : (!(key is String) ? this.putHashValue__Ljava_lang_Object_2Ljava_lang_Object_2I(key, value, this.getHashCode__Ljava_lang_Object_2(key)) : this.putStringValue__Ljava_lang_String_2Ljava_lang_Object_2(String(key), value));
  }
  public override function remove__Ljava_lang_Object_2(key: Object): Object {
    return (key === null) ? this.removeNullSlot__() : (!(key is String) ? this.removeHashValue__Ljava_lang_Object_2I(key, this.getHashCode__Ljava_lang_Object_2(key)) : this.removeStringValue__Ljava_lang_String_2(String(key)));
  }
  public override function size__(): int {
    return size;
  }
  public function equals__Ljava_lang_Object_2Ljava_lang_Object_2(value1: Object, value2: Object): Boolean { // abstract
    return false;
  }
  public function getHashCode__Ljava_lang_Object_2(key: Object): int { // abstract
    return 0;
  }
  private function addAllHashEntries__Ljava_util_Collection_2(dest: Collection): void {
    var hashCodeMap = this.hashCodeMap;
    for (var hashCode in hashCodeMap) {
    // sanity check that it's really an integer
    if (hashCode == parseInt(hashCode)) {
    var array = hashCodeMap[hashCode];
    for (var i = 0, c = array.length; i < c; ++i) {
    dest.add__Ljava_lang_Object_2(array[i]);
    }
    }
    }
  }
  private function addAllStringEntries__Ljava_util_Collection_2(dest: Collection): void {
    var stringMap = this.stringMap;
    for (var key in stringMap) {
    // only keys that start with a colon ':' count
    if (key.charCodeAt(0) == 58) {
    var entry = new java.util.AbstractHashMap$MapEntryString(this, key.substring(1));
    dest.add__Ljava_lang_Object_2(entry);
    }
    }
  }
  private function clearImpl__(): void {
    hashCodeMap = JavaScriptObject.createArray__();
    stringMap = JavaScriptObject.createObject__();
    nullSlotLive = false;
    nullSlot = null;
    size = 0;
  }
  private function containsHashValue__Ljava_lang_Object_2(value: Object): Boolean {
    var hashCodeMap = this.hashCodeMap;
    for (var hashCode in hashCodeMap) {
    // sanity check that it's really one of ours
    if (hashCode == parseInt(hashCode)) {
    var array = hashCodeMap[hashCode];
    for (var i = 0, c = array.length; i < c; ++i) {
    var entry = array[i];
    var entryValue = entry.getValue__();
    if (this.equalsBridge__Ljava_lang_Object_2Ljava_lang_Object_2(value, entryValue)) {
    return true;
    }
    }
    }
    }
    return false;
  }
  private function containsStringValue__Ljava_lang_Object_2(value: Object): Boolean {
    var stringMap = this.stringMap;
    for (var key in stringMap) {
    // only keys that start with a colon ':' count
    if (key.charCodeAt(0) == 58) {
    var entryValue = stringMap[key];
    if (this.equalsBridge__Ljava_lang_Object_2Ljava_lang_Object_2(value, entryValue)) {
    return true;
    }
    }
    }
    return false;
  }
  private function equalsBridge__Ljava_lang_Object_2Ljava_lang_Object_2(value1: Object, value2: Object): Boolean {
    return this.equals__Ljava_lang_Object_2Ljava_lang_Object_2(value1, value2);
  }
  private function getHashValue__Ljava_lang_Object_2I(key: Object, hashCode: int): Object {
    var array = this.hashCodeMap[hashCode];
    if (array) {
    for (var i = 0, c = array.length; i < c; ++i) {
    var entry = array[i];
    var entryKey = entry.getKey__();
    if (this.equalsBridge__Ljava_lang_Object_2Ljava_lang_Object_2(key, entryKey)) {
    return entry.getValue__();
    }
    }
    }
    return null;
  }
  private function getStringValue__Ljava_lang_String_2(key: String): Object {
    return this.stringMap[':' + key];
  }
  private function hasHashValue__Ljava_lang_Object_2I(key: Object, hashCode: int): Boolean {
    var array = this.hashCodeMap[hashCode];
    if (array) {
    for (var i = 0, c = array.length; i < c; ++i) {
    var entry = array[i];
    var entryKey = entry.getKey__();
    if (this.equalsBridge__Ljava_lang_Object_2Ljava_lang_Object_2(key, entryKey)) {
    return true;
    }
    }
    }
    return false;
  }
  private function hasStringValue__Ljava_lang_String_2(key: String): Boolean {
    return (':' + key) in this.stringMap;
  }
  private function putHashValue__Ljava_lang_Object_2Ljava_lang_Object_2I(key: Object, value: Object, hashCode: int): Object {
    var array = this.hashCodeMap[hashCode];
    if (array) {
    for (var i = 0, c = array.length; i < c; ++i) {
    var entry = array[i];
    var entryKey = entry.getKey__();
    if (this.equalsBridge__Ljava_lang_Object_2Ljava_lang_Object_2(key, entryKey)) {
    // Found an exact match, just update the existing entry
    var previous = entry.getValue__();
    entry.setValue__Ljava_lang_Object_2(value);
    return previous;
    }
    }
    } else {
    array = this.hashCodeMap[hashCode] = [];
    }
    var entry = new java.util.MapEntryImpl(key, value);
    array.push(entry);
    ++this.size;
    return null;
  }
  private function putNullSlot__Ljava_lang_Object_2(value: Object): Object {
    var result: Object = nullSlot;
    nullSlot = value;
    if (!nullSlotLive) {
      nullSlotLive = true;
      ++size;
    }
    return result;
  }
  private function putStringValue__Ljava_lang_String_2Ljava_lang_Object_2(key: String, value: Object): Object {
    var result, stringMap = this.stringMap;
    key = ':' + key;
    if (key in stringMap) {
    result = stringMap[key];
    } else {
    ++this.size;
    }
    stringMap[key] = value;
    return result;
  }
  private function removeHashValue__Ljava_lang_Object_2I(key: Object, hashCode: int): Object {
    var array = this.hashCodeMap[hashCode];
    if (array) {
    for (var i = 0, c = array.length; i < c; ++i) {
    var entry = array[i];
    var entryKey = entry.getKey__();
    if (this.equalsBridge__Ljava_lang_Object_2Ljava_lang_Object_2(key, entryKey)) {
    if (array.length == 1) {
    // remove the whole array
    delete this.hashCodeMap[hashCode];
    } else {
    // splice out the entry we're removing
    array.splice(i, 1);
    }
    --this.size;
    return entry.getValue__();
    }
    }
    }
    return null;
  }
  private function removeNullSlot__(): Object {
    var result: Object = nullSlot;
    nullSlot = null;
    if (nullSlotLive) {
      nullSlotLive = false;
      --size;
    }
    return result;
  }
  private function removeStringValue__Ljava_lang_String_2(key: String): Object {
    var result, stringMap = this.stringMap;
    key = ':' + key;
    if (key in stringMap) {
    result = stringMap[key];
    --this.size;
    delete stringMap[key];
    }
    return result;
  }
  public static function access$0(arg0: java.util.AbstractHashMap): Boolean {
    return arg0.nullSlotLive;
  }
  public static function access$1(arg0: java.util.AbstractHashMap, arg1: Collection): void {
    arg0.addAllStringEntries__Ljava_util_Collection_2(arg1);
  }
  public static function access$2(arg0: java.util.AbstractHashMap, arg1: Collection): void {
    arg0.addAllHashEntries__Ljava_util_Collection_2(arg1);
  }
  public static function access$3(arg0: java.util.AbstractHashMap): Object {
    return arg0.nullSlot;
  }
  public static function access$4(arg0: java.util.AbstractHashMap, arg1: Object): Object {
    return arg0.putNullSlot__Ljava_lang_Object_2(arg1);
  }
  public static function access$5(arg0: java.util.AbstractHashMap, arg1: String): Object {
    return arg0.getStringValue__Ljava_lang_String_2(arg1);
  }
  public static function access$6(arg0: java.util.AbstractHashMap, arg1: String, arg2: Object): Object {
    return arg0.putStringValue__Ljava_lang_String_2Ljava_lang_Object_2(arg1, arg2);
  }
  public function AbstractHashMap(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is int) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 2 && vargs[0] is int && vargs[1] is Number) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 1 && vargs[0] is Map) {
        args = vargs;
        id = 3;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        args2 = [args1[0], 0];
        break;
      case 2:
        var args2: Array = [args[0], args[1]];
        break;
      case 3:
        var args3: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        AbstractHashMap__();
        break;
      case 1:
        AbstractHashMap__IF(args2[0], args2[1]);
        AbstractHashMap__I(args1[0]);
        break;
      case 2:
        AbstractHashMap__IF(args2[0], args2[1]);
        break;
      case 3:
        AbstractHashMap__Ljava_util_Map_2(args3[0]);
        break;
    }
  }
  public static const AbstractHashMap__ : int = 0;
  public static const AbstractHashMap__I : int = 1;
  public static const AbstractHashMap__IF : int = 2;
  public static const AbstractHashMap__Ljava_util_Map_2 : int = 3;
}
}
