package java.util {
import java.lang.IllegalStateException;
import java.lang.IndexOutOfBoundsException;
import java.lang.UnsupportedOperationException;
import Object;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class AbstractList extends AbstractCollection implements List {
  public static function checkIndex__II(index: int, size: int): void {
    if (index < 0 || index >= size) {
      java.util.AbstractList.indexOutOfBounds__II(index, size);
    }
    return;
  }
  public static function indexOutOfBounds__II(index: int, size: int): void {
    throw new IndexOutOfBoundsException(new Arguments(java.lang.IndexOutOfBoundsException.IndexOutOfBoundsException__Ljava_lang_String_2, ["Index: " + index + ", Size: " + size]));
    return;
  }
  public function AbstractList() {
    return;
  }
  public override function add__Ljava_lang_Object_2(obj: Object): Boolean {
    this.add__ILjava_lang_Object_2(this.size__(), obj);
    return true;
  }
  public function add__ILjava_lang_Object_2(index: int, element: Object): void {
    throw new UnsupportedOperationException(new Arguments(java.lang.UnsupportedOperationException.UnsupportedOperationException__Ljava_lang_String_2, ["Add not supported on this list"]));
  }
  public function addAll__ILjava_util_Collection_2(index: int, c: Collection): Boolean {
    var iter: Iterator = java.util.Iterator(c.iterator__());
    while (iter.hasNext__()) {
      this.add__ILjava_lang_Object_2(index++, iter.next__());
    }
    return !c.isEmpty__();
  }
  public override function clear__(): void {
    this.removeRange__II(0, this.size__());
  }
  public function equals__Ljava_lang_Object_2(o: Object): Boolean {
    if (o === this) {
      return true;
    }
    if (!(o is java.util.List)) {
      return false;
    }
    var other: List = List(o);
    if (this.size__() != other.size__()) {
      return false;
    }
    var iter: Iterator = Iterator(this.iterator__());
    var iterOther: Iterator = java.util.Iterator(other.iterator__());
    while (iter.hasNext__()) {
      var elem: Object = iter.next__();
      var elemOther: Object = iterOther.next__();
      var result: Boolean = elem === null ? elemOther === null : Object(elem).equals__Ljava_lang_Object_2(elemOther);
      if (!(result)) {
        return false;
      }
    }
    return true;
  }
  public function get__I(index: int): Object { // abstract
    return null;
  }
  public function hashCode__(): int {
    var k: int = 1;
    var coeff: int = 31;
    var iter: Iterator = Iterator(this.iterator__());
    while (iter.hasNext__()) {
      var obj: Object = iter.next__();
      k = 31 * k + (obj === null ? 0 : Object(obj).hashCode__());
      k = ~~k;
    }
    return k;
  }
  public function indexOf__Ljava_lang_Object_2(toFind: Object): int {
    for (var i: int = 0, n: int = this.size__(); i < n; ++i) {
      if (toFind === null ? this.get__I(i) === null : Object(toFind).equals__Ljava_lang_Object_2(this.get__I(i))) {
        return i;
      }
    }
    return -1;
  }
  public override function iterator__(): java.util.Iterator {
    return new AbstractList$IteratorImpl(this);
  }
  public function lastIndexOf__Ljava_lang_Object_2(toFind: Object): int {
    for (var i: int = this.size__() - 1; i > -1; --i) {
      if (toFind === null ? this.get__I(i) === null : Object(toFind).equals__Ljava_lang_Object_2(this.get__I(i))) {
        return i;
      }
    }
    return -1;
  }
  public function listIterator__(): java.util.ListIterator {
    return new AbstractList$ListIteratorImpl(new Arguments(java.util.AbstractList$ListIteratorImpl.AbstractList$ListIteratorImpl__, [this]));
  }
  public function listIterator__I(from: int): ListIterator {
    return new AbstractList$ListIteratorImpl(new Arguments(java.util.AbstractList$ListIteratorImpl.AbstractList$ListIteratorImpl__I, [this, from]));
  }
  public function remove__I(index: int): Object {
    throw new UnsupportedOperationException(new Arguments(java.lang.UnsupportedOperationException.UnsupportedOperationException__Ljava_lang_String_2, ["Remove not supported on this list"]));
  }
  public function set__ILjava_lang_Object_2(index: int, o: Object): Object {
    throw new UnsupportedOperationException(new Arguments(java.lang.UnsupportedOperationException.UnsupportedOperationException__Ljava_lang_String_2, ["Set not supported on this list"]));
  }
  public function removeRange__II(fromIndex: int, endIndex: int): void {
    var iter: ListIterator = ListIterator(this.listIterator__I(fromIndex));
    for (var i: int = fromIndex; i < endIndex; ++i) {
      iter.next__();
      iter.remove__();
    }
    return;
  }
  public function subList__II(fromIndex: int, toIndex: int): List {
    return null;
  }
}
}
