package java.util {
import com.google.gwt.lang.Array__;
import java.io.Serializable;
import java.lang.Cloneable;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ArrayList extends AbstractList implements List, Cloneable, RandomAccess, Serializable {
  private var array: JavaArray;
  private var exposeElement: Object;
  private var size: int;
  private static function setCapacity___3Ljava_lang_Object_2I(array: JavaArray, newSize: int): void {
    array.length = newSize;
  }
  private static function splice___3Ljava_lang_Object_2II(array: JavaArray, index: int, deleteCount: int): void {
    array.splice(index, deleteCount);
  }
  private static function splice___3Ljava_lang_Object_2IILjava_lang_Object_2(array: JavaArray, index: int, deleteCount: int, value: Object): void {
    array.splice(index, deleteCount, value);
  }
  private static function spliceArray___3Ljava_lang_Object_2II_3Ljava_lang_Object_2(array: JavaArray, index: int, deleteCount: int, values: JavaArray): void {
    Array.prototype.splice.apply(array, [index, deleteCount].concat(values));
  }
  public function ArrayList__(): Object {
    {
      this.clearImpl__();
    }
    return this;
  }
  public function ArrayList__Ljava_util_Collection_2(c: Collection): Object {
    {
      this.clearImpl__();
    }
    this.addAll__Ljava_util_Collection_2(c);
    return this;
  }
  public function ArrayList__I(initialCapacity: int): Object {
    {
      this.clearImpl__();
    }
    this.ensureCapacity__I(initialCapacity);
    return this;
  }
  public override function add__Ljava_lang_Object_2(o: Object): Boolean {
    array[size++] = o;
    return true;
  }
  public override function add__ILjava_lang_Object_2(index: int, o: Object): void {
    if (index < 0 || index > size) {
      AbstractList.indexOutOfBounds__II(index, size);
    }
    ArrayList.splice___3Ljava_lang_Object_2IILjava_lang_Object_2(array, index, 0, o);
    ++size;
    return;
  }
  public override function addAll__Ljava_util_Collection_2(c: Collection): Boolean {
    if (c.isEmpty__()) {
      return false;
    }
    ArrayList.spliceArray___3Ljava_lang_Object_2II_3Ljava_lang_Object_2(array, size, 0, c.toArray__());
    size += c.size__();
    return true;
  }
  public override function addAll__ILjava_util_Collection_2(index: int, c: Collection): Boolean {
    if (c.isEmpty__()) {
      return false;
    }
    if (index < 0 || index > size) {
      AbstractList.indexOutOfBounds__II(index, size);
    }
    ArrayList.spliceArray___3Ljava_lang_Object_2II_3Ljava_lang_Object_2(array, index, 0, c.toArray__());
    size += c.size__();
    return true;
  }
  public override function clear__(): void {
    this.clearImpl__();
  }
  public function clone__(): Object {
    return new ArrayList(new Arguments(java.util.ArrayList.ArrayList__Ljava_util_Collection_2, [this]));
  }
  public override function contains__Ljava_lang_Object_2(o: Object): Boolean {
    return (this.indexOf__Ljava_lang_Object_2(o) != -1);
  }
  public function ensureCapacity__I(capacity: int): void {
    if (capacity > size) {
      ArrayList.setCapacity___3Ljava_lang_Object_2I(array, capacity);
    }
    return;
  }
  public override function get__I(index: int): Object {
    AbstractList.checkIndex__II(index, size);
    return array[index];
  }
  public override function indexOf__Ljava_lang_Object_2(o: Object): int {
    return this.indexOf__Ljava_lang_Object_2I(o, 0);
  }
  public override function isEmpty__(): Boolean {
    return size == 0;
  }
  public override function lastIndexOf__Ljava_lang_Object_2(o: Object): int {
    return this.lastIndexOf__Ljava_lang_Object_2I(o, this.size__() - 1);
  }
  public override function remove__I(index: int): Object {
    var previous: Object = this.get__I(index);
    ArrayList.splice___3Ljava_lang_Object_2II(array, index, 1);
    --size;
    return previous;
  }
  public override function remove__Ljava_lang_Object_2(o: Object): Boolean {
    var i: int = this.indexOf__Ljava_lang_Object_2(o);
    if (i == -1) {
      return false;
    }
    this.remove__I(i);
    return true;
  }
  public override function set__ILjava_lang_Object_2(index: int, o: Object): Object {
    var previous: Object = this.get__I(index);
    array[index] = o;
    return previous;
  }
  public override function size__(): int {
    return size;
  }
  public override function toArray__(): JavaArray {
    return Array__.cloneSubrange___3Ljava_lang_Object_2II(array, 0, size);
  }
  public override function toArray___3Ljava_lang_Object_2(out: JavaArray): JavaArray {
    if (out.length < size) {
      out = Array__.createFrom___3Ljava_lang_Object_2I(out, size);
    }
    for (var i: int = 0; i < size; ++i) {
      out[i] = Object(array[i]);
    }
    if (out.length > size) {
      out[size] = null;
    }
    return out;
  }
  public function trimToSize__(): void {
    ArrayList.setCapacity___3Ljava_lang_Object_2I(array, size);
  }
  public override function removeRange__II(fromIndex: int, endIndex: int): void {
    AbstractList.checkIndex__II(fromIndex, size);
    if (endIndex < fromIndex || endIndex > size) {
      AbstractList.indexOutOfBounds__II(endIndex, size);
    }
    var count: int = endIndex - fromIndex;
    ArrayList.splice___3Ljava_lang_Object_2II(array, fromIndex, count);
    size -= count;
    return;
  }
  public function capacity__(): int {
    return array.length;
  }
  public function indexOf__Ljava_lang_Object_2I(o: Object, index: int): int {
    for (; index < size; ++index) {
      if (Utility.equalsWithNullCheck__Ljava_lang_Object_2Ljava_lang_Object_2(o, array[index])) {
        return index;
      }
    }
    return -1;
  }
  public function lastIndexOf__Ljava_lang_Object_2I(o: Object, index: int): int {
    for (; index >= 0; --index) {
      if (Utility.equalsWithNullCheck__Ljava_lang_Object_2Ljava_lang_Object_2(o, array[index])) {
        return index;
      }
    }
    return -1;
  }
  public function setSize__I(newSize: int): void {
    ArrayList.setCapacity___3Ljava_lang_Object_2I(array, newSize);
    size = newSize;
  }
  private function clearImpl__(): void {
    array = JavaArray(new JavaArray("[Ljava/lang/Object;").lengths(0));
    size = 0;
  }
  public function ArrayList(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Collection) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 1 && vargs[0] is int) {
        args = vargs;
        id = 2;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
      case 2:
        var args2: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        ArrayList__();
        break;
      case 1:
        ArrayList__Ljava_util_Collection_2(args1[0]);
        break;
      case 2:
        ArrayList__I(args2[0]);
        break;
    }
  }
  public static const ArrayList__ : int = 0;
  public static const ArrayList__Ljava_util_Collection_2 : int = 1;
  public static const ArrayList__I : int = 2;
}
}
