package java.util {
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.lang.Array__;
import java.io.Serializable;
import java.lang.Boolean__;
import java.lang.Byte;
import java.lang.Character;
import java.lang.Double;
import java.lang.Float;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Short;
import java.lang.StringBuffer;
import java.lang.IllegalArgumentException;
import java.lang.ArrayIndexOutOfBoundsException;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Arrays {
  public static function asList___3Ljava_lang_Object_2(array: JavaArray): List {
    return new Arrays$ArrayList(array);
  }
  public static function binarySearch___3BB(sortedArray: JavaArray, key: int): int {
    var low: int = 0;
    var high: int = sortedArray.length - 1;
    while (low <= high) {
      var mid: int = low + ((high - low) >> 1);
      var midVal: int = sortedArray[mid];
      if (midVal < key) {
        low = mid + 1;
      } else if (midVal > key) {
        high = mid - 1;
      } else {
        return mid;
      }
    }
    return -low - 1;
  }
  public static function binarySearch___3CC(a: JavaArray, key: uint): int {
    var low: int = 0;
    var high: int = a.length - 1;
    while (low <= high) {
      var mid: int = low + ((high - low) >> 1);
      var midVal: uint = a[mid];
      if (midVal < key) {
        low = mid + 1;
      } else if (midVal > key) {
        high = mid - 1;
      } else {
        return mid;
      }
    }
    return -low - 1;
  }
  public static function binarySearch___3DD(sortedArray: JavaArray, key: Number): int {
    var low: int = 0;
    var high: int = sortedArray.length - 1;
    while (low <= high) {
      var mid: int = low + ((high - low) >> 1);
      var midVal: Number = sortedArray[mid];
      if (midVal < key) {
        low = mid + 1;
      } else if (midVal > key) {
        high = mid - 1;
      } else {
        return mid;
      }
    }
    return -low - 1;
  }
  public static function binarySearch___3FF(sortedArray: JavaArray, key: Number): int {
    var low: int = 0;
    var high: int = sortedArray.length - 1;
    while (low <= high) {
      var mid: int = low + ((high - low) >> 1);
      var midVal: Number = sortedArray[mid];
      if (midVal < key) {
        low = mid + 1;
      } else if (midVal > key) {
        high = mid - 1;
      } else {
        return mid;
      }
    }
    return -low - 1;
  }
  public static function binarySearch___3II(sortedArray: JavaArray, key: int): int {
    var low: int = 0;
    var high: int = sortedArray.length - 1;
    while (low <= high) {
      var mid: int = low + ((high - low) >> 1);
      var midVal: int = sortedArray[mid];
      if (midVal < key) {
        low = mid + 1;
      } else if (midVal > key) {
        high = mid - 1;
      } else {
        return mid;
      }
    }
    return -low - 1;
  }
  public static function binarySearch___3JJ(sortedArray: JavaArray, key: Number): int {
    var low: int = 0;
    var high: int = sortedArray.length - 1;
    while (low <= high) {
      var mid: int = low + ((high - low) >> 1);
      var midVal: Number = sortedArray[mid];
      if (midVal < key) {
        low = mid + 1;
      } else if (midVal > key) {
        high = mid - 1;
      } else {
        return mid;
      }
    }
    return -low - 1;
  }
  public static function binarySearch___3Ljava_lang_Object_2Ljava_lang_Object_2(sortedArray: JavaArray, key: Object): int {
    return binarySearch___3Ljava_lang_Object_2Ljava_lang_Object_2Ljava_util_Comparator_2(sortedArray, key, Comparators.natural__());
  }
  public static function binarySearch___3SS(sortedArray: JavaArray, key: int): int {
    var low: int = 0;
    var high: int = sortedArray.length - 1;
    while (low <= high) {
      var mid: int = low + ((high - low) >> 1);
      var midVal: int = sortedArray[mid];
      if (midVal < key) {
        low = mid + 1;
      } else if (midVal > key) {
        high = mid - 1;
      } else {
        return mid;
      }
    }
    return -low - 1;
  }
  public static function binarySearch___3Ljava_lang_Object_2Ljava_lang_Object_2Ljava_util_Comparator_2(sortedArray: JavaArray, key: Object, comparator: java.util.Comparator): int {
    if (comparator === null) {
      comparator = Comparators.natural__();
    }
    var low: int = 0;
    var high: int = sortedArray.length - 1;
    while (low <= high) {
      var mid: int = low + ((high - low) >> 1);
      var midVal: Object = sortedArray[mid];
      var compareResult: int = comparator.compare__Ljava_lang_Object_2Ljava_lang_Object_2(midVal, key);
      if (compareResult < 0) {
        low = mid + 1;
      } else if (compareResult > 0) {
        high = mid - 1;
      } else {
        return mid;
      }
    }
    return -low - 1;
  }
  public static function deepEquals___3Ljava_lang_Object_2_3Ljava_lang_Object_2(a1: JavaArray, a2: JavaArray): Boolean {
    if (a1 === a2) {
      return true;
    }
    if (a1 === null || a2 === null) {
      return false;
    }
    if (a1.length != a2.length) {
      return false;
    }
    for (var i: int = 0, n: int = a1.length; i < n; ++i) {
      var obj1: Object = a1[i];
      var obj2: Object = a2[i];
      if (obj1 === obj2) {
        continue;
      }
      if (obj1 === null || obj2 === null) {
        return false;
      }
      if (Object(obj1).equals__Ljava_lang_Object_2(obj2)) {
        continue;
      }
      var class1: String = Object(obj1).getClass__().getName__();
      var class2: String = Object(obj2).getClass__().getName__();
      if (!Object(class1).startsWith__Ljava_lang_String_2("[") || !Object(class1).equals__Ljava_lang_Object_2(class2)) {
        return false;
      }
      if (obj1 is JavaArray) {
        if (!deepEquals___3Ljava_lang_Object_2_3Ljava_lang_Object_2(JavaArray(obj1), JavaArray(obj2))) {
          return false;
        }
      } else if (obj1 is JavaArray) {
        if (!equals___3Z_3Z(JavaArray(obj1), JavaArray(obj2))) {
          return false;
        }
      } else if (obj1 is JavaArray) {
        if (!equals___3B_3B(JavaArray(obj1), JavaArray(obj2))) {
          return false;
        }
      } else if (obj1 is JavaArray) {
        if (!equals___3C_3C(JavaArray(obj1), JavaArray(obj2))) {
          return false;
        }
      } else if (obj1 is JavaArray) {
        if (!equals___3S_3S(JavaArray(obj1), JavaArray(obj2))) {
          return false;
        }
      } else if (obj1 is JavaArray) {
        if (!equals___3I_3I(JavaArray(obj1), JavaArray(obj2))) {
          return false;
        }
      } else if (obj1 is JavaArray) {
        if (!equals___3J_3J(JavaArray(obj1), JavaArray(obj2))) {
          return false;
        }
      } else if (obj1 is JavaArray) {
        if (!equals___3F_3F(JavaArray(obj1), JavaArray(obj2))) {
          return false;
        }
      } else if (obj1 is JavaArray) {
        if (!equals___3D_3D(JavaArray(obj1), JavaArray(obj2))) {
          return false;
        }
      }
    }
    return true;
  }
  public static function deepHashCode___3Ljava_lang_Object_2(a: JavaArray): int {
    if (a === null) {
      return 0;
    }
    var hashCode: int = 1;
    for (var i: int = 0, n: int = a.length; i < n; ++i) {
      var obj: Object = a[i];
      var hash: int;
      if (obj is JavaArray) {
        hash = deepHashCode___3Ljava_lang_Object_2(JavaArray(obj));
      } else if (obj is JavaArray) {
        hash = hashCode___3Z(JavaArray(obj));
      } else if (obj is JavaArray) {
        hash = hashCode___3B(JavaArray(obj));
      } else if (obj is JavaArray) {
        hash = hashCode___3C(JavaArray(obj));
      } else if (obj is JavaArray) {
        hash = hashCode___3S(JavaArray(obj));
      } else if (obj is JavaArray) {
        hash = hashCode___3I(JavaArray(obj));
      } else if (obj is JavaArray) {
        hash = hashCode___3J(JavaArray(obj));
      } else if (obj is JavaArray) {
        hash = hashCode___3F(JavaArray(obj));
      } else if (obj is JavaArray) {
        hash = hashCode___3D(JavaArray(obj));
      } else {
        hash = Object(obj).hashCode__();
      }
      hashCode = (31 * hashCode + hash) | 0;
    }
    return hashCode;
  }
  public static function deepToString___3Ljava_lang_Object_2(a: JavaArray): String {
    return deepToString___3Ljava_lang_Object_2Ljava_util_Set_2(a, new HashSet(new Arguments(java.util.HashSet.HashSet__, [])));
  }
  public static function equals___3Z_3Z(array1: JavaArray, array2: JavaArray): Boolean {
    if (array1 === array2) {
      return true;
    }
    if (array1 === null || array2 === null) {
      return false;
    }
    if (array1.length != array2.length) {
      return false;
    }
    for (var i: int = 0; i < array1.length; ++i) {
      if (array1[i] != array2[i]) {
        return false;
      }
    }
    return true;
  }
  public static function equals___3B_3B(array1: JavaArray, array2: JavaArray): Boolean {
    if (array1 === array2) {
      return true;
    }
    if (array1 === null || array2 === null) {
      return false;
    }
    if (array1.length != array2.length) {
      return false;
    }
    for (var i: int = 0; i < array1.length; ++i) {
      if (array1[i] != array2[i]) {
        return false;
      }
    }
    return true;
  }
  public static function equals___3C_3C(array1: JavaArray, array2: JavaArray): Boolean {
    if (array1 === array2) {
      return true;
    }
    if (array1 === null || array2 === null) {
      return false;
    }
    if (array1.length != array2.length) {
      return false;
    }
    for (var i: int = 0; i < array1.length; ++i) {
      if (array1[i] != array2[i]) {
        return false;
      }
    }
    return true;
  }
  public static function equals___3D_3D(array1: JavaArray, array2: JavaArray): Boolean {
    if (array1 === array2) {
      return true;
    }
    if (array1 === null || array2 === null) {
      return false;
    }
    if (array1.length != array2.length) {
      return false;
    }
    for (var i: int = 0; i < array1.length; ++i) {
      if (array1[i] != array2[i]) {
        return false;
      }
    }
    return true;
  }
  public static function equals___3F_3F(array1: JavaArray, array2: JavaArray): Boolean {
    if (array1 === array2) {
      return true;
    }
    if (array1 === null || array2 === null) {
      return false;
    }
    if (array1.length != array2.length) {
      return false;
    }
    for (var i: int = 0; i < array1.length; ++i) {
      if (array1[i] != array2[i]) {
        return false;
      }
    }
    return true;
  }
  public static function equals___3I_3I(array1: JavaArray, array2: JavaArray): Boolean {
    if (array1 === array2) {
      return true;
    }
    if (array1 === null || array2 === null) {
      return false;
    }
    if (array1.length != array2.length) {
      return false;
    }
    for (var i: int = 0; i < array1.length; ++i) {
      if (array1[i] != array2[i]) {
        return false;
      }
    }
    return true;
  }
  public static function equals___3J_3J(array1: JavaArray, array2: JavaArray): Boolean {
    if (array1 === array2) {
      return true;
    }
    if (array1 === null || array2 === null) {
      return false;
    }
    if (array1.length != array2.length) {
      return false;
    }
    for (var i: int = 0; i < array1.length; ++i) {
      if (array1[i] != array2[i]) {
        return false;
      }
    }
    return true;
  }
  public static function equals___3Ljava_lang_Object_2_3Ljava_lang_Object_2(array1: JavaArray, array2: JavaArray): Boolean {
    if (array1 === array2) {
      return true;
    }
    if (array1 === null || array2 === null) {
      return false;
    }
    if (array1.length != array2.length) {
      return false;
    }
    for (var i: int = 0; i < array1.length; ++i) {
      var val1: Object = array1[i];
      var val2: Object = array2[i];
      if (!Object(val1).equals__Ljava_lang_Object_2(val2)) {
        return false;
      }
    }
    return true;
  }
  public static function equals___3S_3S(array1: JavaArray, array2: JavaArray): Boolean {
    if (array1 === array2) {
      return true;
    }
    if (array1 === null || array2 === null) {
      return false;
    }
    if (array1.length != array2.length) {
      return false;
    }
    for (var i: int = 0; i < array1.length; ++i) {
      if (array1[i] != array2[i]) {
        return false;
      }
    }
    return true;
  }
  public static function fill___3ZZ(a: JavaArray, val: Boolean): void {
    fill___3ZIIZ(a, 0, a.length, val);
  }
  public static function fill___3ZIIZ(a: JavaArray, fromIndex: int, toIndex: int, val: Boolean): void {
    for (var i: int = fromIndex; i < toIndex; ++i) {
      a[i] = val;
    }
    return;
  }
  public static function fill___3BB(a: JavaArray, val: int): void {
    fill___3BIIB(a, 0, a.length, val);
    return;
  }
  public static function fill___3BIIB(a: JavaArray, fromIndex: int, toIndex: int, val: int): void {
    for (var i: int = fromIndex; i < toIndex; ++i) {
      a[i] = val;
    }
    return;
  }
  public static function fill___3CC(a: JavaArray, val: uint): void {
    fill___3CIIC(a, 0, a.length, val);
    return;
  }
  public static function fill___3CIIC(a: JavaArray, fromIndex: int, toIndex: int, val: uint): void {
    for (var i: int = fromIndex; i < toIndex; ++i) {
      a[i] = val;
    }
    return;
  }
  public static function fill___3DD(a: JavaArray, val: Number): void {
    fill___3DIID(a, 0, a.length, val);
    return;
  }
  public static function fill___3DIID(a: JavaArray, fromIndex: int, toIndex: int, val: Number): void {
    for (var i: int = fromIndex; i < toIndex; ++i) {
      a[i] = val;
    }
    return;
  }
  public static function fill___3FF(a: JavaArray, val: Number): void {
    fill___3FIIF(a, 0, a.length, val);
    return;
  }
  public static function fill___3FIIF(a: JavaArray, fromIndex: int, toIndex: int, val: Number): void {
    for (var i: int = fromIndex; i < toIndex; ++i) {
      a[i] = val;
    }
    return;
  }
  public static function fill___3II(a: JavaArray, val: int): void {
    fill___3IIII(a, 0, a.length, val);
    return;
  }
  public static function fill___3IIII(a: JavaArray, fromIndex: int, toIndex: int, val: int): void {
    for (var i: int = fromIndex; i < toIndex; ++i) {
      a[i] = val;
    }
    return;
  }
  public static function fill___3JIIJ(a: JavaArray, fromIndex: int, toIndex: int, val: Number): void {
    for (var i: int = fromIndex; i < toIndex; ++i) {
      a[i] = val;
    }
    return;
  }
  public static function fill___3JJ(a: JavaArray, val: Number): void {
    fill___3JIIJ(a, 0, a.length, val);
    return;
  }
  public static function fill___3Ljava_lang_Object_2IILjava_lang_Object_2(a: JavaArray, fromIndex: int, toIndex: int, val: Object): void {
    for (var i: int = fromIndex; i < toIndex; ++i) {
      a[i] = val;
    }
    return;
  }
  public static function fill___3Ljava_lang_Object_2Ljava_lang_Object_2(a: JavaArray, val: Object): void {
    fill___3Ljava_lang_Object_2IILjava_lang_Object_2(a, 0, a.length, val);
    return;
  }
  public static function fill___3SIIS(a: JavaArray, fromIndex: int, toIndex: int, val: int): void {
    for (var i: int = fromIndex; i < toIndex; ++i) {
      a[i] = val;
    }
    return;
  }
  public static function fill___3SS(a: JavaArray, val: int): void {
    fill___3SIIS(a, 0, a.length, val);
    return;
  }
  public static function hashCode___3Z(a: JavaArray): int {
    if (a === null) {
      return 0;
    }
    var hashCode: int = 1;
    for (var i: int = 0, n: int = a.length; i < n; ++i) {
      hashCode = (31 * hashCode + (Boolean__.valueOf__Z(a[i]).hashCode__())) | 0;
    }
    return hashCode;
  }
  public static function hashCode___3B(a: JavaArray): int {
    if (a === null) {
      return 0;
    }
    var hashCode: int = 1;
    for (var i: int = 0, n: int = a.length; i < n; ++i) {
      hashCode = (31 * hashCode + Byte.hashCode__B(a[i])) | 0;
    }
    return hashCode;
  }
  public static function hashCode___3C(a: JavaArray): int {
    if (a === null) {
      return 0;
    }
    var hashCode: int = 1;
    for (var i: int = 0, n: int = a.length; i < n; ++i) {
      hashCode = (31 * hashCode + Character.hashCode__C(a[i])) | 0;
    }
    return hashCode;
  }
  public static function hashCode___3D(a: JavaArray): int {
    if (a === null) {
      return 0;
    }
    var hashCode: int = 1;
    for (var i: int = 0, n: int = a.length; i < n; ++i) {
      hashCode = (31 * hashCode + Double.hashCode__D(a[i])) | 0;
    }
    return hashCode;
  }
  public static function hashCode___3F(a: JavaArray): int {
    if (a === null) {
      return 0;
    }
    var hashCode: int = 1;
    for (var i: int = 0, n: int = a.length; i < n; ++i) {
      hashCode = (31 * hashCode + Float.hashCode__F(a[i])) | 0;
    }
    return hashCode;
  }
  public static function hashCode___3I(a: JavaArray): int {
    if (a === null) {
      return 0;
    }
    var hashCode: int = 1;
    for (var i: int = 0, n: int = a.length; i < n; ++i) {
      hashCode = (31 * hashCode + Integer.hashCode__I(a[i])) | 0;
    }
    return hashCode;
  }
  public static function hashCode___3J(a: JavaArray): int {
    if (a === null) {
      return 0;
    }
    var hashCode: int = 1;
    for (var i: int = 0, n: int = a.length; i < n; ++i) {
      hashCode = (31 * hashCode + Long.hashCode__J(a[i])) | 0;
    }
    return hashCode;
  }
  public static function hashCode___3Ljava_lang_Object_2(a: JavaArray): int {
    if (a === null) {
      return 0;
    }
    var hashCode: int = 1;
    for (var i: int = 0; i < a.length; i++) {
      var e: Object = a[i];
      hashCode = (31 * hashCode + (e === null ? 0 : Object(e).hashCode__())) | 0;
    }
    return hashCode;
  }
  public static function hashCode___3S(a: JavaArray): int {
    if (a === null) {
      return 0;
    }
    var hashCode: int = 1;
    for (var i: int = 0, n: int = a.length; i < n; ++i) {
      hashCode = (31 * hashCode + Short.hashCode__S(a[i])) | 0;
    }
    return hashCode;
  }
  public static function sort___3B(array: JavaArray): void {
    nativeNumberSort__Ljava_lang_Object_2(array);
  }
  public static function sort___3BII(array: JavaArray, fromIndex: int, toIndex: int): void {
    verifySortIndices__III(fromIndex, toIndex, array.length);
    nativeNumberSort__Ljava_lang_Object_2II(array, fromIndex, toIndex);
  }
  public static function sort___3C(array: JavaArray): void {
    nativeNumberSort__Ljava_lang_Object_2(array);
  }
  public static function sort___3CII(array: JavaArray, fromIndex: int, toIndex: int): void {
    verifySortIndices__III(fromIndex, toIndex, array.length);
    nativeNumberSort__Ljava_lang_Object_2II(array, fromIndex, toIndex);
  }
  public static function sort___3D(array: JavaArray): void {
    nativeNumberSort__Ljava_lang_Object_2(array);
  }
  public static function sort___3DII(array: JavaArray, fromIndex: int, toIndex: int): void {
    verifySortIndices__III(fromIndex, toIndex, array.length);
    nativeNumberSort__Ljava_lang_Object_2II(array, fromIndex, toIndex);
  }
  public static function sort___3F(array: JavaArray): void {
    nativeNumberSort__Ljava_lang_Object_2(array);
  }
  public static function sort___3FII(array: JavaArray, fromIndex: int, toIndex: int): void {
    verifySortIndices__III(fromIndex, toIndex, array.length);
    nativeNumberSort__Ljava_lang_Object_2II(array, fromIndex, toIndex);
  }
  public static function sort___3I(array: JavaArray): void {
    nativeNumberSort__Ljava_lang_Object_2(array);
  }
  public static function sort___3III(array: JavaArray, fromIndex: int, toIndex: int): void {
    verifySortIndices__III(fromIndex, toIndex, array.length);
    nativeNumberSort__Ljava_lang_Object_2II(array, fromIndex, toIndex);
  }
  public static function sort___3J(array: JavaArray): void {
    nativeLongSort__Ljava_lang_Object_2(array);
  }
  public static function sort___3JII(array: JavaArray, fromIndex: int, toIndex: int): void {
    verifySortIndices__III(fromIndex, toIndex, array.length);
    nativeLongSort__Ljava_lang_Object_2II(array, fromIndex, toIndex);
  }
  public static function sort___3Ljava_lang_Object_2(array: JavaArray): void {
    mergeSort___3Ljava_lang_Object_2IILjava_util_Comparator_2(array, 0, array.length, Comparators.natural__());
  }
  public static function sort___3Ljava_lang_Object_2II(x: JavaArray, fromIndex: int, toIndex: int): void {
    mergeSort___3Ljava_lang_Object_2IILjava_util_Comparator_2(x, fromIndex, toIndex, Comparators.natural__());
  }
  public static function sort___3S(array: JavaArray): void {
    nativeNumberSort__Ljava_lang_Object_2(array);
  }
  public static function sort___3SII(array: JavaArray, fromIndex: int, toIndex: int): void {
    verifySortIndices__III(fromIndex, toIndex, array.length);
    nativeNumberSort__Ljava_lang_Object_2II(array, fromIndex, toIndex);
  }
  public static function sort___3Ljava_lang_Object_2Ljava_util_Comparator_2(x: JavaArray, c: java.util.Comparator): void {
    mergeSort___3Ljava_lang_Object_2IILjava_util_Comparator_2(x, 0, x.length, c !== null ? c : Comparators.natural__());
  }
  public static function sort___3Ljava_lang_Object_2IILjava_util_Comparator_2(x: JavaArray, fromIndex: int, toIndex: int, c: java.util.Comparator): void {
    verifySortIndices__III(fromIndex, toIndex, x.length);
    mergeSort___3Ljava_lang_Object_2IILjava_util_Comparator_2(x, fromIndex, toIndex, c !== null ? c : Comparators.natural__());
  }
  public static function toString___3Z(a: JavaArray): String {
    if (a === null) {
      return "null";
    }
    var b: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__Ljava_lang_String_2, ["["]));
    for (var i: int = 0; i < a.length; i++) {
      if (i != 0) {
        b.append__Ljava_lang_String_2(", ");
      }
      b.append__Ljava_lang_String_2(Object(String).valueOf__Z(a[i]));
    }
    b.append__Ljava_lang_String_2("]");
    return b.toString__();
  }
  public static function toString___3B(a: JavaArray): String {
    if (a === null) {
      return "null";
    }
    var b: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__Ljava_lang_String_2, ["["]));
    for (var i: int = 0; i < a.length; i++) {
      if (i != 0) {
        b.append__Ljava_lang_String_2(", ");
      }
      b.append__Ljava_lang_String_2(Object(String).valueOf__I(a[i]));
    }
    b.append__Ljava_lang_String_2("]");
    return b.toString__();
  }
  public static function toString___3C(a: JavaArray): String {
    if (a === null) {
      return "null";
    }
    var b: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__Ljava_lang_String_2, ["["]));
    for (var i: int = 0; i < a.length; i++) {
      if (i != 0) {
        b.append__Ljava_lang_String_2(", ");
      }
      b.append__Ljava_lang_String_2(Object(String).valueOf__C(a[i]));
    }
    b.append__Ljava_lang_String_2("]");
    return b.toString__();
  }
  public static function toString___3D(a: JavaArray): String {
    if (a === null) {
      return "null";
    }
    var b: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__Ljava_lang_String_2, ["["]));
    for (var i: int = 0; i < a.length; i++) {
      if (i != 0) {
        b.append__Ljava_lang_String_2(", ");
      }
      b.append__Ljava_lang_String_2(Object(String).valueOf__D(a[i]));
    }
    b.append__Ljava_lang_String_2("]");
    return b.toString__();
  }
  public static function toString___3F(a: JavaArray): String {
    if (a === null) {
      return "null";
    }
    var b: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__Ljava_lang_String_2, ["["]));
    for (var i: int = 0; i < a.length; i++) {
      if (i != 0) {
        b.append__Ljava_lang_String_2(", ");
      }
      b.append__Ljava_lang_String_2(Object(String).valueOf__F(a[i]));
    }
    b.append__Ljava_lang_String_2("]");
    return b.toString__();
  }
  public static function toString___3I(a: JavaArray): String {
    if (a === null) {
      return "null";
    }
    var b: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__Ljava_lang_String_2, ["["]));
    for (var i: int = 0; i < a.length; i++) {
      if (i != 0) {
        b.append__Ljava_lang_String_2(", ");
      }
      b.append__Ljava_lang_String_2(Object(String).valueOf__I(a[i]));
    }
    b.append__Ljava_lang_String_2("]");
    return b.toString__();
  }
  public static function toString___3J(a: JavaArray): String {
    if (a === null) {
      return "null";
    }
    var b: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__Ljava_lang_String_2, ["["]));
    for (var i: int = 0; i < a.length; i++) {
      if (i != 0) {
        b.append__Ljava_lang_String_2(", ");
      }
      b.append__Ljava_lang_String_2(Object(String).valueOf__J(a[i]));
    }
    b.append__Ljava_lang_String_2("]");
    return b.toString__();
  }
  public static function toString___3Ljava_lang_Object_2(x: JavaArray): String {
    if (x === null) {
      return "null";
    }
    return Object(asList___3Ljava_lang_Object_2(x)).toString__();
  }
  public static function toString___3S(a: JavaArray): String {
    if (a === null) {
      return "null";
    }
    var b: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__Ljava_lang_String_2, ["["]));
    for (var i: int = 0; i < a.length; i++) {
      if (i != 0) {
        b.append__Ljava_lang_String_2(", ");
      }
      b.append__Ljava_lang_String_2(Object(String).valueOf__I(a[i]));
    }
    b.append__Ljava_lang_String_2("]");
    return b.toString__();
  }
  private static function deepToString___3Ljava_lang_Object_2Ljava_util_Set_2(a: JavaArray, arraysIveSeen: Set): String {
    if (a === null) {
      return "null";
    }
    if (arraysIveSeen.contains__Ljava_lang_Object_2(a)) {
      return "[...]";
    }
    arraysIveSeen.add__Ljava_lang_Object_2(a);
    var b: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__Ljava_lang_String_2, ["["]));
    for (var i: int = 0; i < a.length; i++) {
      if (i != 0) {
        b.append__Ljava_lang_String_2(", ");
      }
      var obj: Object = a[i];
      if (obj === null) {
        b.append__Ljava_lang_String_2("null");
      } else if (Object(Object(obj).getClass__().getName__()).startsWith__Ljava_lang_String_2("[")) {
        if (obj is JavaArray) {
          if (arraysIveSeen.contains__Ljava_lang_Object_2(obj)) {
            b.append__Ljava_lang_String_2("[...]");
          } else {
            var objArray: JavaArray = JavaArray(obj);
            var tempSet: HashSet = new HashSet(new Arguments(java.util.HashSet.HashSet__Ljava_util_Collection_2, [arraysIveSeen]));
            b.append__Ljava_lang_String_2(deepToString___3Ljava_lang_Object_2Ljava_util_Set_2(objArray, tempSet));
          }
        } else if (obj is JavaArray) {
          b.append__Ljava_lang_String_2(toString___3B(JavaArray(obj)));
        } else if (obj is JavaArray) {
          b.append__Ljava_lang_String_2(toString___3B(JavaArray(obj)));
        } else if (obj is JavaArray) {
          b.append__Ljava_lang_String_2(toString___3C(JavaArray(obj)));
        } else if (obj is JavaArray) {
          b.append__Ljava_lang_String_2(toString___3S(JavaArray(obj)));
        } else if (obj is JavaArray) {
          b.append__Ljava_lang_String_2(toString___3I(JavaArray(obj)));
        } else if (obj is JavaArray) {
          b.append__Ljava_lang_String_2(toString___3J(JavaArray(obj)));
        } else if (obj is JavaArray) {
          b.append__Ljava_lang_String_2(toString___3F(JavaArray(obj)));
        } else if (obj is JavaArray) {
          b.append__Ljava_lang_String_2(toString___3D(JavaArray(obj)));
        }
      } else {
        b.append__Ljava_lang_String_2(Object(String).valueOf__Ljava_lang_Object_2(obj));
      }
    }
    b.append__Ljava_lang_String_2("]");
    return b.toString__();
  }
  private static function insertionSort___3Ljava_lang_Object_2IILjava_util_Comparator_2(array: JavaArray, low: int, high: int, comp: Comparator): void {
    for (var i: int = low + 1; i < high; ++i) {
      for (var j: int = i; j > low && comp.compare__Ljava_lang_Object_2Ljava_lang_Object_2(array[j - 1], array[j]) > 0; --j) {
        var t: Object = array[j];
        array[j] = array[j - 1];
        array[j - 1] = t;
      }
    }
    return;
  }
  private static function merge___3Ljava_lang_Object_2III_3Ljava_lang_Object_2IILjava_util_Comparator_2(src: JavaArray, srcLow: int, srcMid: int, srcHigh: int, dest: JavaArray, destLow: int, destHigh: int, comp: Comparator): void {
    var topIdx: int = srcMid;
    while (destLow < destHigh) {
      if (topIdx >= srcHigh || (srcLow < srcMid && comp.compare__Ljava_lang_Object_2Ljava_lang_Object_2(src[srcLow], src[topIdx]) <= 0)) {
        dest[destLow++] = src[srcLow++];
      } else {
        dest[destLow++] = src[topIdx++];
      }
    }
    return;
  }
  private static function mergeSort___3Ljava_lang_Object_2IILjava_util_Comparator_2(x: JavaArray, fromIndex: int, toIndex: int, comp: Comparator): void {
    var temp: JavaArray = Array__.cloneSubrange___3Ljava_lang_Object_2II(x, fromIndex, toIndex);
    mergeSort___3Ljava_lang_Object_2_3Ljava_lang_Object_2IIILjava_util_Comparator_2(temp, x, fromIndex, toIndex, -fromIndex, Comparator(comp));
    return;
  }
  private static function mergeSort___3Ljava_lang_Object_2_3Ljava_lang_Object_2IIILjava_util_Comparator_2(temp: JavaArray, array: JavaArray, low: int, high: int, ofs: int, comp: Comparator): void {
    var length: int = high - low;
    if (length < 7) {
      insertionSort___3Ljava_lang_Object_2IILjava_util_Comparator_2(array, low, high, comp);
      return;
    }
    var tempLow: int = low + ofs;
    var tempHigh: int = high + ofs;
    var tempMid: int = tempLow + ((tempHigh - tempLow) >> 1);
    mergeSort___3Ljava_lang_Object_2_3Ljava_lang_Object_2IIILjava_util_Comparator_2(array, temp, tempLow, tempMid, -ofs, comp);
    mergeSort___3Ljava_lang_Object_2_3Ljava_lang_Object_2IIILjava_util_Comparator_2(array, temp, tempMid, tempHigh, -ofs, comp);
    if (comp.compare__Ljava_lang_Object_2Ljava_lang_Object_2(temp[tempMid - 1], temp[tempMid]) <= 0) {
      while (low < high) {
        array[low++] = temp[tempLow++];
      }
      return;
    }
    merge___3Ljava_lang_Object_2III_3Ljava_lang_Object_2IILjava_util_Comparator_2(temp, tempLow, tempMid, tempHigh, array, low, high, comp);
    return;
  }
  private static function nativeLongSort__Ljava_lang_Object_2(array: Object): void {
    array.sort(com.google.gwt.lang.LongLib.compare___3D_3D);
  }
  private static function nativeLongSort__Ljava_lang_Object_2II(array: Object, fromIndex: int, toIndex: int): void {
    var temp = array.slice(fromIndex, toIndex);
    temp.sort(com.google.gwt.lang.LongLib.compare___3D_3D);
    var n = toIndex - fromIndex;
    // Do the equivalent of array.splice(fromIndex, n, temp) except
    // flattening the temp slice.
    Array.prototype.splice.apply(array, [fromIndex, n].concat(temp));
  }
  private static function nativeNumberSort__Ljava_lang_Object_2(array: Object): void {
    array.sort(function(a,b) { return a - b; });
  }
  private static function nativeNumberSort__Ljava_lang_Object_2II(array: Object, fromIndex: int, toIndex: int): void {
    var temp = array.slice(fromIndex, toIndex);
    temp.sort(function(a,b) { return a - b; });
    var n = toIndex - fromIndex;
    // Do the equivalent of array.splice(fromIndex, n, temp) except
    // flattening the temp slice.
    Array.prototype.splice.apply(array, [fromIndex, n].concat(temp.slice(0, n)));
  }
  private static function nativeObjSort__Ljava_lang_Object_2IILcom_google_gwt_core_client_JavaScriptObject_2(array: Object, fromIndex: int, toIndex: int, comp: Object): void {
    var n = toIndex - fromIndex;
    var indexArray = new Array(n);
    var arrayIdx = fromIndex;
    for (var i = 0; i < n; ++i) {
    indexArray[i] = arrayIdx++;
    }
    indexArray.sort(comp);
    if (comp.swap) { // only reorder elements if we made a swap
    var temp = array.slice(fromIndex, toIndex);
    arrayIdx = fromIndex;
    for (var i = 0; i < n; ++i) {
    array[arrayIdx++] = temp[indexArray[i] - fromIndex];
    }
    }
  }
  private static function verifySortIndices__III(fromIndex: int, toIndex: int, length: int): void {
    if (fromIndex > toIndex) {
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__Ljava_lang_String_2, ["fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")"]));
    }
    if (fromIndex < 0 || toIndex > length) {
      throw new ArrayIndexOutOfBoundsException(new Arguments(java.lang.ArrayIndexOutOfBoundsException.ArrayIndexOutOfBoundsException__Ljava_lang_String_2, ["fromIndex(" + fromIndex + ") or toIndex(" + toIndex + ") out of bounds (0 - " + length + ")"]));
    }
    return;
  }
}
}
