package java.util {
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Calendar {
  public var time: Number = 0;
  public var fields: JavaArray;
  public var isSet: JavaArray;
  internal var timeSet: Boolean;
  internal var fieldsSet: Boolean;
  internal var zone: TimeZone;
  public static const YEAR: int = 1;
  public static const MONTH: int = 2;
  public static const DATE: int = 5;
  public static const DAY_OF_MONTH: int = 5;
  public static const DAY_OF_WEEK: int = 7;
  public static const AM_PM: int = 9;
  public static const HOUR: int = 10;
  public static const HOUR_OF_DAY: int = 11;
  public static const MINUTE: int = 12;
  public static const SECOND: int = 13;
  public static const MILLISECOND: int = 14;
  public static const SUNDAY: int = 1;
  public static const MONDAY: int = 2;
  public static const TUESDAY: int = 3;
  public static const WEDNESDAY: int = 4;
  public static const THRUSDAY: int = 5;
  public static const FRIDAY: int = 6;
  public static const SATURDAY: int = 7;
  public static const AM: int = 0;
  public static const PM: int = 1;
  public static const JANUARY: int = 0;
  public static const FEBRUARY: int = 1;
  public static const MARCH: int = 2;
  public static const APRIL: int = 3;
  public static const MAY: int = 4;
  public static const JUNE: int = 5;
  public static const JULY: int = 6;
  public static const AUGUST: int = 7;
  public static const SEPTEMBER: int = 8;
  public static const OCTOBER: int = 9;
  public static const NOVEMBER: int = 10;
  public static const DECEMBER: int = 11;
  public function Calendar() {
    time = System.currentTimeMillis__();
    timeSet = true;
    return;
  }
  public function after__Ljava_lang_Object_2(when: Object): Boolean {
    if (!(when is Calendar))
      return false;
    return this.getTimeInMillis__() > (Calendar(when)).getTimeInMillis__();
  }
  public function before__Ljava_lang_Object_2(when: Object): Boolean {
    if (!(when is Calendar))
      return false;
    return this.getTimeInMillis__() < (Calendar(when)).getTimeInMillis__();
  }
  public function computeFields__(): void { } // abstract
  public function computeTime__(): void { } // abstract
  public function equals__Ljava_lang_Object_2(other: Object): Boolean {
    if (other === this)
      return true;
    if (!(other is Calendar))
      return false;
    return this.getTimeInMillis__() == (Calendar(other)).getTimeInMillis__();
  }
  public function get__I(field: int): int {
    if (!isSet[field]) {
      this.computeFields__();
      fieldsSet = true;
    }
    return fields[field];
  }
  public static function getInstance__(): Calendar {
    return getInstance__Ljava_util_TimeZone_2(TimeZone.getDefault__());
  }
  public static function getInstance__Ljava_util_TimeZone_2(zone: TimeZone): Calendar {
    var calendar: Calendar = new GregorianCalendar();
    calendar.setTimeZone__Ljava_util_TimeZone_2(zone);
    return calendar;
  }
  public function getTime__(): Date__ {
    return new Date__(new Arguments(java.util.Date__.Date____J, [this.getTimeInMillis__()]));
  }
  public function getTimeInMillis__(): Number {
    if (!timeSet)
      this.computeTime__();
    return time;
  }
  public function getTimeZone__(): TimeZone {
    return zone;
  }
  public function set__II(field: int, value: int): void {
    if (timeSet && !fieldsSet) {
      this.computeFields__();
      fieldsSet = true;
    }
    fields[field] = value;
    isSet[field] = true;
    timeSet = false;
    return;
  }
  public function setTime__Ljava_util_Date_2(date: Date__): void {
    this.setTimeInMillis__J(date.getTime__());
    return;
  }
  public function setTimeInMillis__J(millis: Number): void {
    time = millis;
    timeSet = true;
    fieldsSet = false;
    for (var i: int = 0; i < isSet.length; i++) {
      isSet[i] = false;
    }
    return;
  }
  public function setTimeZone__Ljava_util_TimeZone_2(zone_1: TimeZone): void {
  }
}
}
