package java.util {
import java.lang.UnsupportedOperationException;
import java.lang.Comparable;
import java.lang.Comparable;
import java.lang.Comparable;
import java.lang.Comparable;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Collections {
  public static var EMPTY_LIST: java.util.List = unmodifiableList__Ljava_util_List_2(new java.util.ArrayList(new Arguments(java.util.ArrayList.ArrayList__, [])));
  public static var EMPTY_MAP: java.util.Map = unmodifiableMap__Ljava_util_Map_2(new java.util.HashMap(new Arguments(java.util.HashMap.HashMap__, [])));
  public static var EMPTY_SET: java.util.Set = unmodifiableSet__Ljava_util_Set_2(new java.util.HashSet(new Arguments(java.util.HashSet.HashSet__, [])));
  public static var reverseComparator: Comparator = new java.util.Collections$1();
  public static function addAll__Ljava_util_Collection_2_3Ljava_lang_Object_2(c: Collection, a: JavaArray): Boolean {
    var result: Boolean = false;
    for (var i: int = 0; i < a.length; i++) {
      var e: Object = a[i];
      result = (result) ? (c.add__Ljava_lang_Object_2(e), true) : (c.add__Ljava_lang_Object_2(e));
    }
    return result;
  }
  public static function binarySearch__Ljava_util_List_2Ljava_lang_Object_2(sortedList: List, key: Object): int {
    return binarySearch__Ljava_util_List_2Ljava_lang_Object_2Ljava_util_Comparator_2(sortedList, key, null);
  }
  public static function binarySearch__Ljava_util_List_2Ljava_lang_Object_2Ljava_util_Comparator_2(sortedList: java.util.List, key: Object, comparator: java.util.Comparator): int {
    if (comparator === null) {
      comparator = Comparators.natural__();
    }
    var low: int = 0;
    var high: int = sortedList.size__() - 1;
    while (low <= high) {
      var mid: int = low + ((high - low) >> 1);
      var midVal: Object = sortedList.get__I(mid);
      var compareResult: int = comparator.compare__Ljava_lang_Object_2Ljava_lang_Object_2(midVal, key);
      if (compareResult < 0) {
        low = mid + 1;
      } else if (compareResult > 0) {
        high = mid - 1;
      } else {
        return mid;
      }
    }
    return -low - 1;
  }
  public static function copy__Ljava_util_List_2Ljava_util_List_2(dest: java.util.List, src: java.util.List): void {
    dest.addAll__Ljava_util_Collection_2(src);
  }
  public static function disjoint__Ljava_util_Collection_2Ljava_util_Collection_2(c1: Collection, c2: Collection): Boolean {
    var iterating: Collection = c1;
    var testing: Collection = c2;
    if ((c1 is java.util.Set) && !(c2 is java.util.Set)) {
      iterating = c2;
      testing = c1;
    }
    for (var iterator: java.util.Iterator = java.util.Iterator(iterating.iterator__()); iterator.hasNext__();) {
      var o: Object = Object(iterator.next__());
      if (testing.contains__Ljava_lang_Object_2(o)) {
        return false;
      }
    }
    return true;
  }
  public static function emptyList__(): java.util.List {
    return java.util.List(EMPTY_LIST);
  }
  public static function emptyMap__(): java.util.Map {
    return java.util.Map(EMPTY_MAP);
  }
  public static function emptySet__(): java.util.Set {
    return java.util.Set(EMPTY_SET);
  }
  public static function enumeration__Ljava_util_Collection_2(c: java.util.Collection): java.util.Enumeration {
    var it: java.util.Iterator = java.util.Iterator(c.iterator__());
    return new java.util.Collections$2(it);
  }
  public static function fill__Ljava_util_List_2Ljava_lang_Object_2(list: java.util.List, obj: Object): void {
    for (var it: ListIterator = list.listIterator__(); it.hasNext__();) {
      it.next__();
      it.set__Ljava_lang_Object_2(obj);
    }
    return;
  }
  public static function frequency__Ljava_util_Collection_2Ljava_lang_Object_2(c: Collection, o: Object): int {
    var count: int = 0;
    for (var iterator: java.util.Iterator = java.util.Iterator(c.iterator__()); iterator.hasNext__();) {
      var e: Object = Object(iterator.next__());
      if (o === null ? e === null : Object(o).equals__Ljava_lang_Object_2(e)) {
        ++count;
      }
    }
    return count;
  }
  public static function list__Ljava_util_Enumeration_2(e: java.util.Enumeration): java.util.ArrayList {
    var arrayList: java.util.ArrayList = new java.util.ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    while (e.hasMoreElements__()) {
      arrayList.add__Ljava_lang_Object_2(e.nextElement__());
    }
    return arrayList;
  }
  public static function max__Ljava_util_Collection_2(coll: java.util.Collection): Object {
    return max__Ljava_util_Collection_2Ljava_util_Comparator_2(coll, null);
  }
  public static function max__Ljava_util_Collection_2Ljava_util_Comparator_2(coll: java.util.Collection, comp: java.util.Comparator): Object {
    if (comp === null) {
      comp = Comparators.natural__();
    }
    var it: java.util.Iterator = java.util.Iterator(coll.iterator__());
    var max: Object = it.next__();
    while (it.hasNext__()) {
      var t: Object = it.next__();
      if (comp.compare__Ljava_lang_Object_2Ljava_lang_Object_2(t, max) > 0) {
        max = t;
      }
    }
    return max;
  }
  public static function min__Ljava_util_Collection_2(coll: java.util.Collection): Object {
    return min__Ljava_util_Collection_2Ljava_util_Comparator_2(coll, null);
  }
  public static function min__Ljava_util_Collection_2Ljava_util_Comparator_2(coll: java.util.Collection, comp: java.util.Comparator): Object {
    return max__Ljava_util_Collection_2Ljava_util_Comparator_2(coll, reverseOrder__Ljava_util_Comparator_2(comp));
  }
  public static function nCopies__ILjava_lang_Object_2(n: int, o: Object): java.util.List {
    var list: java.util.ArrayList = new java.util.ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    for (var i: int = 0; i < n; ++i) {
      list.add__Ljava_lang_Object_2(o);
    }
    return unmodifiableList__Ljava_util_List_2(list);
  }
  public static function replaceAll__Ljava_util_List_2Ljava_lang_Object_2Ljava_lang_Object_2(list: java.util.List, oldVal: Object, newVal: Object): Boolean {
    var modified: Boolean = false;
    for (var it: java.util.ListIterator = list.listIterator__(); it.hasNext__();) {
      var t: Object = it.next__();
      if (t === null ? oldVal === null : Object(t).equals__Ljava_lang_Object_2(oldVal)) {
        it.set__Ljava_lang_Object_2(newVal);
        modified = true;
      }
    }
    return modified;
  }
  public static function reverse__Ljava_util_List_2(l: java.util.List): void {
    if (l is RandomAccess) {
      for (var iFront: int = 0, iBack: int = l.size__() - 1; iFront < iBack; ++iFront, --iBack) {
        swap__Ljava_util_List_2II(l, iFront, iBack);
      }
    } else {
      var head: java.util.ListIterator = l.listIterator__();
      var tail: java.util.ListIterator = l.listIterator__I(l.size__());
      while (head.nextIndex__() < tail.previousIndex__()) {
        var headElem: Object = head.next__();
        var tailElem: Object = tail.previous__();
        head.set__Ljava_lang_Object_2(tailElem);
        tail.set__Ljava_lang_Object_2(headElem);
      }
    }
    return;
  }
  public static function reverseOrder__(): java.util.Comparator {
    return java.util.Comparator(reverseComparator);
  }
  public static function reverseOrder__Ljava_util_Comparator_2(cmp: java.util.Comparator): java.util.Comparator {
    if (cmp === null) {
      return reverseOrder__();
    }
    return new java.util.Collections$3(cmp);
  }
  public static function singleton__Ljava_lang_Object_2(o: Object): java.util.Set {
    var set_1: HashSet = new HashSet(new Arguments(java.util.HashSet.HashSet__I, [1]));
    set_1.add__Ljava_lang_Object_2(o);
    return unmodifiableSet__Ljava_util_Set_2(set_1);
  }
  public static function singletonList__Ljava_lang_Object_2(o: Object): java.util.List {
    var list: java.util.List = new java.util.ArrayList(new Arguments(java.util.ArrayList.ArrayList__I, [1]));
    list.add__Ljava_lang_Object_2(o);
    return unmodifiableList__Ljava_util_List_2(list);
  }
  public static function singletonMap__Ljava_lang_Object_2Ljava_lang_Object_2(key: Object, value: Object): java.util.Map {
    var map: java.util.Map = new HashMap(new Arguments(java.util.HashMap.HashMap__I, [1]));
    map.put__Ljava_lang_Object_2Ljava_lang_Object_2(key, value);
    return unmodifiableMap__Ljava_util_Map_2(map);
  }
  public static function sort__Ljava_util_List_2(target: java.util.List): void {
    var x: JavaArray = target.toArray__();
    Arrays.sort___3Ljava_lang_Object_2(x);
    replaceContents__Ljava_util_List_2_3Ljava_lang_Object_2(target, x);
  }
  public static function sort__Ljava_util_List_2Ljava_util_Comparator_2(target: java.util.List, c: java.util.Comparator): void {
    var x: JavaArray = target.toArray__();
    Arrays.sort___3Ljava_lang_Object_2Ljava_util_Comparator_2(x, Comparator(c));
    replaceContents__Ljava_util_List_2_3Ljava_lang_Object_2(target, x);
  }
  public static function swap__Ljava_util_List_2II(list: List, i: int, j: int): void {
    swapImpl__Ljava_util_List_2II(list, i, j);
  }
  public static function unmodifiableCollection__Ljava_util_Collection_2(coll: java.util.Collection): java.util.Collection {
    return new java.util.Collections$UnmodifiableCollection(coll);
  }
  public static function unmodifiableList__Ljava_util_List_2(list: java.util.List): java.util.List {
    return (list is RandomAccess) ? new Collections$UnmodifiableRandomAccessList(list) : new java.util.Collections$UnmodifiableList(list);
  }
  public static function unmodifiableMap__Ljava_util_Map_2(map: java.util.Map): java.util.Map {
    return new java.util.Collections$UnmodifiableMap(map);
  }
  public static function unmodifiableSet__Ljava_util_Set_2(set_1: java.util.Set): java.util.Set {
    return new Collections$UnmodifiableSet(set_1);
  }
  public static function unmodifiableSortedMap__Ljava_util_SortedMap_2(map: java.util.SortedMap): java.util.SortedMap {
    return new java.util.Collections$UnmodifiableSortedMap(map);
  }
  public static function unmodifiableSortedSet__Ljava_util_SortedSet_2(set_1: SortedSet): SortedSet {
    return new Collections$UnmodifiableSortedSet(set_1);
  }
  private static function replaceContents__Ljava_util_List_2_3Ljava_lang_Object_2(target: java.util.List, x: JavaArray): void {
    var size: int = target.size__();
    for (var i: int = 0; i < size; i++) {
      target.set__ILjava_lang_Object_2(i, Object(x[i]));
    }
    return;
  }
  private static function swapImpl__Ljava_util_List_2II(list: java.util.List, i: int, j: int): void {
    var t: Object = list.get__I(i);
    list.set__ILjava_lang_Object_2(i, list.get__I(j));
    list.set__ILjava_lang_Object_2(j, t);
    return;
  }
}
}
