package java.util {
import java.io.Serializable;
import java.lang.Cloneable;
import java.lang.Comparable;
import java.lang.IllegalArgumentException;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Date__ implements Cloneable, Comparable, Serializable {
  public static var DAYS: JavaArray = new JavaArray("[Ljava/lang/String;").values("Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat");
  public static var MONTHS: JavaArray = new JavaArray("[Ljava/lang/String;").values("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec");
  public static function parse__Ljava_lang_String_2(s: String): Number {
    var d: Number = Number(parse0__Ljava_lang_String_2(s));
    if (d != -1) {
      return d;
    } else {
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__, []));
    }
    return 0;
  }
  public static function UTC__IIIIII(year: int, month: int, date: int, hrs: int, min: int, sec: int): Number {
    return Number(utc0__IIIIII(year, month, date, hrs, min, sec));
  }
  public static function padTwo__I(number: int): String {
    if (number < 10) {
      return "0" + number;
    } else {
      return Object(String).valueOf__I(number);
    }
    return null;
  }
  private static function dayToString__I(day: int): String {
    return DAYS[day];
  }
  private static function monthToString__I(month: int): String {
    return MONTHS[month];
  }
  private static function parse0__Ljava_lang_String_2(s: String): Number {
    var d = Date.parse(s);
    return isNaN(d) ? -1 : d;
  }
  private static function utc0__IIIIII(year: int, month: int, date: int, hrs: int, min: int, sec: int): Number {
    return Date.UTC(year + 1900, month, date, hrs, min, sec);
  }
  public function Date____(): Object {
    this.init__();
    return this;
  }
  public function Date____III(year: int, month: int, date: int): Object {
    this.init__IIIIII(year, month, date, 0, 0, 0);
    return this;
  }
  public function Date____IIIII(year: int, month: int, date: int, hrs: int, min: int): Object {
    this.init__IIIIII(year, month, date, hrs, min, 0);
    return this;
  }
  public function Date____IIIIII(year: int, month: int, date: int, hrs: int, min: int, sec: int): Object {
    this.init__IIIIII(year, month, date, hrs, min, sec);
    return this;
  }
  public function Date____J(date: Number): Object {
    this.init__D(date);
    return this;
  }
  public function Date____Ljava_lang_String_2(date: String): Object {
    this.init__D(Date__.parse__Ljava_lang_String_2(date));
    return this;
  }
  public function after__Ljava_util_Date_2(when: Date__): Boolean {
    return this.getTime__() > when.getTime__();
  }
  public function before__Ljava_util_Date_2(when: Date__): Boolean {
    return this.getTime__() < when.getTime__();
  }
  public function clone__(): Object {
    return new Date__(new Arguments(java.util.Date__.Date____J, [this.getTime__()]));
  }
  public function compareTo__Ljava_util_Date_2(other: Date__): int {
    var thisTime: Number = this.getTime__();
    var otherTime: Number = other.getTime__();
    if (thisTime < otherTime) {
      return -1;
    } else if (thisTime > otherTime) {
      return 1;
    } else {
      return 0;
    }
    return 0;
  }
  public function equals__Ljava_lang_Object_2(obj: Object): Boolean {
    return ((obj is Date__) && (this.getTime__() == (Date__(obj)).getTime__()));
  }
  public function getDate__(): int {
    return this.jsdate.getDate();
  }
  public function getDay__(): int {
    return this.jsdate.getDay();
  }
  public function getHours__(): int {
    return this.jsdate.getHours();
  }
  public function getMinutes__(): int {
    return this.jsdate.getMinutes();
  }
  public function getMonth__(): int {
    return this.jsdate.getMonth();
  }
  public function getSeconds__(): int {
    return this.jsdate.getSeconds();
  }
  public function getTime__(): Number {
    return Number(this.getTime0__());
  }
  public function getTimezoneOffset__(): int {
    return this.jsdate.getTimezoneOffset();
  }
  public function getYear__(): int {
    return this.jsdate.getFullYear()-1900;
  }
  public function hashCode__(): int {
    return int((this.getTime__() ^ (this.getTime__() >>> 32)));
  }
  public function setDate__I(date: int): void {
    this.jsdate.setDate(date);
  }
  public function setHours__I(hours: int): void {
    this.jsdate.setHours(hours);
  }
  public function setMinutes__I(minutes: int): void {
    this.jsdate.setMinutes(minutes);
  }
  public function setMonth__I(month: int): void {
    this.jsdate.setMonth(month);
  }
  public function setSeconds__I(seconds: int): void {
    this.jsdate.setSeconds(seconds);
  }
  public function setTime__J(time: Number): void {
    this.setTime0__D(time);
  }
  public function setYear__I(year: int): void {
    this.jsdate.setFullYear(year + 1900);
  }
  public function toGMTString__(): String {
    var d = this.jsdate;
    var padTwo = java.util.Date__.padTwo__I;
    var month =
    java.util.Date__.monthToString__I(this.jsdate.getUTCMonth());
    
    return d.getUTCDate() + " " +
    month + " " +
    d.getUTCFullYear() + " " +
    padTwo(d.getUTCHours()) + ":" +
    padTwo(d.getUTCMinutes()) + ":" +
    padTwo(d.getUTCSeconds()) +
    " GMT";
  }
  public function toLocaleString__(): String {
    return this.jsdate.toLocaleString();
  }
  public function toString__(): String {
    var d = this.jsdate;
    var padTwo = java.util.Date__.padTwo__I;
    var day =
    java.util.Date__.dayToString__I(this.jsdate.getDay());
    var month =
    java.util.Date__.monthToString__I(this.jsdate.getMonth());
    
    // Compute timezone offset. The value that getTimezoneOffset returns is
    // backwards for the transformation that we want.
    var offset = -d.getTimezoneOffset();
    var hourOffset = String((offset >= 0) ?
    "+" + Math.floor(offset / 60) : Math.ceil(offset / 60));
    var minuteOffset = padTwo(Math.abs(offset) % 60);
    
    return day + " " + month + " " +
    padTwo(d.getDate()) + " " +
    padTwo(d.getHours()) + ":" +
    padTwo(d.getMinutes()) + ":" +
    padTwo(d.getSeconds()) +
    " GMT" + hourOffset + minuteOffset +
    " " + d.getFullYear();
    ////TODO: e4 fixed bug
    // " GMT" + hourOffset + minuteOffset +
    //        + " " + d.getFullYear();
  }
  private function getTime0__(): Number {
    return this.jsdate.getTime();
  }
  private function init__(): void {
    this.jsdate = new Date();
  }
  private function init__D(date: Number): void {
    this.jsdate = new Date(date);
  }
  private function init__IIIIII(year: int, month: int, date: int, hrs: int, min: int, sec: int): void {
    this.jsdate = new Date();
    this.jsdate.setFullYear(year + 1900, month, date);
    this.jsdate.setHours(hrs, min, sec, 0);
  }
  private function setTime0__D(time: Number): void {
    this.jsdate.setTime(time);
  }
  public function compareTo__Ljava_lang_Object_2(arg0: Object): int {
    return arg0.compareTo__Ljava_util_Date_2();
  }
  public function Date__(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 3 && vargs[0] is int && vargs[1] is int && vargs[2] is int) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 5 && vargs[0] is int && vargs[1] is int && vargs[2] is int && vargs[3] is int && vargs[4] is int) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 6 && vargs[0] is int && vargs[1] is int && vargs[2] is int && vargs[3] is int && vargs[4] is int && vargs[5] is int) {
        args = vargs;
        id = 3;
      } else if (vargs.length == 1 && vargs[0] is Number) {
        args = vargs;
        id = 4;
      } else if (vargs.length == 1 && vargs[0] is String) {
        args = vargs;
        id = 5;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0], args[1], args[2]];
        break;
      case 2:
        var args2: Array = [args[0], args[1], args[2], args[3], args[4]];
        break;
      case 3:
        var args3: Array = [args[0], args[1], args[2], args[3], args[4], args[5]];
        break;
      case 4:
        var args4: Array = [args[0]];
        break;
      case 5:
        var args5: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Date____();
        break;
      case 1:
        Date____III(args1[0], args1[1], args1[2]);
        break;
      case 2:
        Date____IIIII(args2[0], args2[1], args2[2], args2[3], args2[4]);
        break;
      case 3:
        Date____IIIIII(args3[0], args3[1], args3[2], args3[3], args3[4], args3[5]);
        break;
      case 4:
        Date____J(args4[0]);
        break;
      case 5:
        Date____Ljava_lang_String_2(args5[0]);
        break;
    }
  }
  public static const Date____ : int = 0;
  public static const Date____III : int = 1;
  public static const Date____IIIII : int = 2;
  public static const Date____IIIIII : int = 3;
  public static const Date____J : int = 4;
  public static const Date____Ljava_lang_String_2 : int = 5;
}
}
