package java.util {
import com.google.gwt.lang.Array__;
import java.lang.Enum;
import java.lang.IllegalStateException;
import java.lang.Class__;
import java.lang.IllegalArgumentException;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class EnumMap extends AbstractMap {
  private var keySet: EnumSet;
  private var values: JavaArray;
  public function EnumMap__Ljava_lang_Class_2(type: Class__): Object {
    this.init__Ljava_lang_Class_2(type);
    return this;
  }
  public function EnumMap__Ljava_util_EnumMap_2(m: EnumMap): Object {
    this.init__Ljava_util_EnumMap_2(m);
    return this;
  }
  public function EnumMap__Ljava_util_Map_2(m: Map): Object {
    if (m is java.util.EnumMap) {
      this.init__Ljava_util_EnumMap_2(EnumMap(m));
    } else {
      if (m.isEmpty__()) {
        throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__Ljava_lang_String_2, ["Specified map is empty"]));
      }
      this.init__Ljava_lang_Class_2(java.lang.Enum(Iterator(m.keySet__().iterator__()).next__()).getDeclaringClass__());
      this.putAll__Ljava_util_Map_2(m);
    }
    return this;
  }
  public override function clear__(): void {
    keySet.clear__();
    values = JavaArray(new JavaArray("[Ljava/lang/Object;").lengths(values.length));
    return;
  }
  public function clone__(): Object {
    return new java.util.EnumMap(new Arguments(java.util.EnumMap.EnumMap__Ljava_util_EnumMap_2, [this]));
  }
  public override function containsKey__Ljava_lang_Object_2(key: Object): Boolean {
    return keySet.contains__Ljava_lang_Object_2(key);
  }
  public override function containsValue__Ljava_lang_Object_2(value: Object): Boolean {
    for (var iterator: java.util.Iterator = keySet.iterator__(); iterator.hasNext__(); ) {
      var key: java.lang.Enum=java.lang.Enum(iterator.next__());
      if (Utility.equalsWithNullCheck__Ljava_lang_Object_2Ljava_lang_Object_2(value, values[key.ordinal__()])) {
        return true;
      }
    }
    return false;
  }
  public override function entrySet__(): java.util.Set {
    return new EnumMap$EntrySet(this);
  }
  public override function get__Ljava_lang_Object_2(k: Object): Object {
    return keySet.contains__Ljava_lang_Object_2(k) ? values[this.asOrdinal__Ljava_lang_Object_2(k)] : null;
  }
  public function put__Ljava_lang_Enum_2Ljava_lang_Object_2(key: java.lang.Enum, value: Object): Object {
    keySet.add__Ljava_lang_Object_2(key);
    return this.set__ILjava_lang_Object_2(key.ordinal__(), value);
  }
  public override function remove__Ljava_lang_Object_2(key: Object): Object {
    return keySet.remove__Ljava_lang_Object_2(key) ? this.set__ILjava_lang_Object_2(this.asOrdinal__Ljava_lang_Object_2(key), null) : null;
  }
  public override function size__(): int {
    return keySet.size__();
  }
  private function asKey__Ljava_lang_Object_2(key: Object): java.lang.Enum {
    return java.lang.Enum(key);
  }
  private function asOrdinal__Ljava_lang_Object_2(key: Object): int {
    return java.lang.Enum(this.asKey__Ljava_lang_Object_2(key)).ordinal__();
  }
  private function init__Ljava_lang_Class_2(type: Class__): void {
    keySet = java.util.EnumSet.noneOf__Ljava_lang_Class_2(type);
    values = JavaArray(new JavaArray("[Ljava/lang/Object;").lengths(keySet.capacity__()));
  }
  private function init__Ljava_util_EnumMap_2(m: EnumMap): void {
    keySet = EnumSet(m.keySet.clone__());
    values = Array__.clone___3Ljava_lang_Object_2(m.values);
  }
  private function set__ILjava_lang_Object_2(ordinal: int, value: Object): Object {
    var was: Object = values[ordinal];
    values[ordinal] = value;
    return was;
  }
  public override function put__Ljava_lang_Object_2Ljava_lang_Object_2(arg0: Object, arg1: Object): Object {
    return arg0.put__Ljava_lang_Enum_2Ljava_lang_Object_2(arg1);
  }
  public static function access$2(arg0: java.util.EnumMap): EnumSet {
    return arg0.keySet;
  }
  public static function access$3(arg0: java.util.EnumMap): JavaArray {
    return arg0.values;
  }
  public function EnumMap(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is Class__) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is EnumMap) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 1 && vargs[0] is Map) {
        args = vargs;
        id = 2;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
      case 2:
        var args2: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        EnumMap__Ljava_lang_Class_2(args0[0]);
        break;
      case 1:
        EnumMap__Ljava_util_EnumMap_2(args1[0]);
        break;
      case 2:
        EnumMap__Ljava_util_Map_2(args2[0]);
        break;
    }
  }
  public static const EnumMap__Ljava_lang_Class_2 : int = 0;
  public static const EnumMap__Ljava_util_EnumMap_2 : int = 1;
  public static const EnumMap__Ljava_util_Map_2 : int = 2;
}
}
