package java.util {
import java.lang.JavaArray;
dynamic public class GregorianCalendar extends Calendar {
  public static const FIELD_COUNT: int = 14 + 1;
  public function GregorianCalendar() {
    var f: JavaArray = new JavaArray("[I").lengths(15);
    fields = f;
    isSet = new JavaArray("[Z").lengths(15);
    return;
  }
  public override function computeFields__(): void {
    var date: Date = new Date(time);
    fields[1] = int(date.fullYear);
    fields[2] = int(date.month);
    fields[5] = int(date.date);
    fields[10] = int(date.hours) % 12;
    fields[12] = int(date.minutes);
    fields[13] = int(date.seconds);
    fields[14] = int(date.milliseconds);
    fields[7] = int((date.day - 1));
    fields[11] = int(date.hours);
    fields[9] = date.hours > 12 ? 1 : 0;
    for (var i: int = 0; i < isSet.length; i++) {
      isSet[i] = true;
    }
    return;
  }
  public override function computeTime__(): void {
    var year: int = isSet[1] ? fields[1] : 0;
    var month: int = isSet[2] ? fields[2] : 0;
    var day: int = isSet[5] ? fields[5] : 0;
    var hour: int = 0;
    if (isSet[11]) {
      hour = fields[11];
    } else if (isSet[10] && isSet[9]) {
      hour = fields[10];
      if (fields[9] == 1)
        hour += 12;
    }
    var minute: int = isSet[12] ? fields[12] : 0;
    var second: int = isSet[13] ? fields[13] : 0;
    var millisecond: int = isSet[14] ? fields[14] : 0;
    var date: Date = new Date(year, month, day, hour, minute, second, millisecond);
    time = date.getTime();
    return;
  }
}
}
