package java.util {
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.StringBuffer;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Hashtable implements java.util.Map {
  internal var elementCount: int;
  internal var elementData: JavaArray;
  private var limit: int;
  public function Hashtable__(): Object {
    return this;
  }
  public function Hashtable__I(initialCapacity: int): Object {
    if (initialCapacity < 0)
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__, []));
    elementData = new JavaArray("[Ljava/util/Hashtable$Entry;").lengths(initialCapacity);
    limit = int(elementData.length * 3 / 4);
    return this;
  }
  public function clear__(): void {
    for (var i: int = 0; i < elementData.length; i++) {
      elementData[i] = null;
    }
    elementCount = 0;
    return;
  }
  public function contains__Ljava_lang_Object_2(value: Object): Boolean {
    if (value === null)
      throw new NullPointerException(new Arguments(java.lang.NullPointerException.NullPointerException__, []));
    for (var i: int = 0; i < elementData.length; i++) {
      var entry: Hashtable$Entry = elementData[i];
      while (entry !== null) {
        if (Object(value).equals__Ljava_lang_Object_2(entry.value))
          return true;
        entry = entry.next;
      }
    }
    return false;
  }
  public function containsKey__Ljava_lang_Object_2(key: Object): Boolean {
    if (key === null)
      throw new NullPointerException(new Arguments(java.lang.NullPointerException.NullPointerException__, []));
    var hash: int = Object(key).hashCode__();
    var index: int = (hash & 0x7FFFFFFF) % elementData.length;
    var entry: Hashtable$Entry = elementData[index];
    while (entry !== null) {
      if (Object(key).equals__Ljava_lang_Object_2(entry.key))
        return true;
      entry = entry.next;
    }
    return false;
  }
  public function elements__(): java.util.Enumeration {
    return new java.util.Hashtable$1(this);
  }
  public function get__Ljava_lang_Object_2(key: Object): Object {
    if (key === null)
      throw new NullPointerException(new Arguments(java.lang.NullPointerException.NullPointerException__, []));
    var hash: int = Object(key).hashCode__();
    var index: int = (hash & 0x7FFFFFFF) % elementData.length;
    var entry: Hashtable$Entry = elementData[index];
    while (entry !== null) {
      if (Object(key).equals__Ljava_lang_Object_2(entry.key))
        return entry.value;
      entry = entry.next;
    }
    return null;
  }
  public function isEmpty__(): Boolean {
    return elementCount == 0;
  }
  public function keys__(): java.util.Enumeration {
    return new java.util.Hashtable$2(this);
  }
  public function put__Ljava_lang_Object_2Ljava_lang_Object_2(key: Object, value: Object): Object {
    if (key === null || value === null)
      throw new NullPointerException(new Arguments(java.lang.NullPointerException.NullPointerException__, []));
    var hash: int = Object(key).hashCode__();
    var index: int = (hash & 0x7FFFFFFF) % elementData.length;
    if (elementCount > 0) {
      var entry: Hashtable$Entry = elementData[index];
      while (entry !== null) {
        if (Object(entry).equals__Ljava_lang_Object_2(key)) {
          var result: Object = entry.value;
          entry.value = value;
          return result;
        }
        entry = entry.next;
      }
    }
    if (elementCount++ >= limit) {
      this.rehash__();
      index = (hash & 0x7FFFFFFF) % elementData.length;
    }
    var newEntry: Hashtable$Entry = new Hashtable$Entry();
    var entry_1: Hashtable$Entry = elementData[index];
    if (entry_1 !== null)
      newEntry.next = entry_1;
    newEntry.key = key;
    newEntry.value = value;
    elementData[index] = newEntry;
    return null;
  }
  public function rehash__(): void {
    var newEntries: JavaArray = new JavaArray("[Ljava/util/Hashtable$Entry;").lengths(elementData.length * 2 + 1);
    for (var i: int = 0; i < elementData.length; i++) {
      var entry: Hashtable$Entry = elementData[i];
      while (entry !== null) {
        var hash: int = Object(entry.key).hashCode__();
        var index: int = (hash & 0x7FFFFFFF) % newEntries.length;
        var previous: Hashtable$Entry = newEntries[index];
        var next: Hashtable$Entry = entry.next;
        entry.next = previous !== null ? previous : null;
        newEntries[index] = entry;
        entry = next;
      }
    }
    elementData = newEntries;
    limit = int(elementData.length * 3 / 4);
    return;
  }
  public function remove__Ljava_lang_Object_2(key: Object): Object {
    if (key === null)
      throw new NullPointerException(new Arguments(java.lang.NullPointerException.NullPointerException__, []));
    var hash: int = Object(key).hashCode__();
    var index: int = (hash & 0x7FFFFFFF) % elementData.length;
    var entry: Hashtable$Entry = elementData[index];
    var previous: Hashtable$Entry = null;
    while (entry !== null) {
      if (Object(key).equals__Ljava_lang_Object_2(entry.key)) {
        elementCount--;
        if (previous === null) {
          elementData[index] = entry.next;
        } else {
          previous.next = entry.next;
        }
        return entry.value;
      }
      previous = entry;
      entry = entry.next;
    }
    return null;
  }
  public function size__(): int {
    return elementCount;
  }
  public function toString__(): String {
    var buffer: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__, []));
    buffer.append__Ljava_lang_String_2("{");
    var first: Boolean = true;
    var keys: java.util.Enumeration = this.keys__();
    while (keys.hasMoreElements__()) {
      if (!first)
        buffer.append__Ljava_lang_String_2(", ");
      first = false;
      var key: Object = keys.nextElement__();
      var value: Object = this.get__Ljava_lang_Object_2(key);
      buffer.append__Ljava_lang_Object_2(key);
      buffer.append__Ljava_lang_String_2("=");
      buffer.append__Ljava_lang_Object_2(value);
    }
    buffer.append__Ljava_lang_String_2("}");
    return buffer.toString__();
  }
  public function containsValue__Ljava_lang_Object_2(value: Object): Boolean {
    return this.contains__Ljava_lang_Object_2(value);
  }
  public function entrySet__(): java.util.Set {
    return null;
  }
  public function keySet__(): java.util.Set {
    return null;
  }
  public function putAll__Ljava_util_Map_2(t: java.util.Map): void {
  }
  public function values__(): java.util.Collection {
    return null;
  }
  public function Hashtable(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        args1 = [10];
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Hashtable__I(args1[0]);
        Hashtable__();
        break;
      case 1:
        Hashtable__I(args1[0]);
        break;
    }
  }
  public static const Hashtable__ : int = 0;
  public static const Hashtable__I : int = 1;
}
}
