package java.util {
import java.io.Serializable;
import java.lang.IllegalStateException;
import java.lang.Arguments;
dynamic public class LinkedList extends AbstractSequentialList implements List, Queue, Serializable {
  private var exposeElement: Object;
  private var header: java.util.LinkedList$Node;
  internal var size: int;
  public function LinkedList__(): Object {
    this.clear__();
    return this;
  }
  public function LinkedList__Ljava_util_Collection_2(c: Collection): Object {
    this.addAll__Ljava_util_Collection_2(c);
    return this;
  }
  public override function add__Ljava_lang_Object_2(o: Object): Boolean {
    this.addLast__Ljava_lang_Object_2(o);
    return true;
  }
  public function addFirst__Ljava_lang_Object_2(o: Object): void {
    new java.util.LinkedList$Node(new Arguments(java.util.LinkedList$Node.LinkedList$Node__Ljava_lang_Object_2Ljava_util_LinkedList$Node_2, [o, header.next]));
    ++size;
  }
  public function addLast__Ljava_lang_Object_2(o: Object): void {
    new java.util.LinkedList$Node(new Arguments(java.util.LinkedList$Node.LinkedList$Node__Ljava_lang_Object_2Ljava_util_LinkedList$Node_2, [o, header]));
    ++size;
  }
  public override function clear__(): void {
    header = new java.util.LinkedList$Node(new Arguments(java.util.LinkedList$Node.LinkedList$Node__, []));
    size = 0;
  }
  public function element__(): Object {
    return this.getFirst__();
  }
  public function getFirst__(): Object {
    this.throwEmptyException__();
    return header.next.value;
  }
  public function getLast__(): Object {
    this.throwEmptyException__();
    return header.prev.value;
  }
  public override function listIterator__I(index: int): ListIterator {
    if (index < 0 || index > size) {
      AbstractList.indexOutOfBounds__II(index, size);
    }
    var node: java.util.LinkedList$Node;
    if (index >= size >> 1) {
      node = header;
      for (var i: int = size; i > index; --i) {
        node = node.prev;
      }
    } else {
      node = header.next;
      for (var i_1: int = 0; i_1 < index; ++i_1) {
        node = node.next;
      }
    }
    return new LinkedList$ListIteratorImpl(this, index, node);
  }
  public function offer__Ljava_lang_Object_2(o: Object): Boolean {
    return this.add__Ljava_lang_Object_2(o);
  }
  public function peek__(): Object {
    if (size == 0) {
      return null;
    } else {
      return this.getFirst__();
    }
    return null;
  }
  public function poll__(): Object {
    if (size == 0) {
      return null;
    } else {
      return this.removeFirst__();
    }
    return null;
  }
  public function remove__(): Object {
    return this.removeFirst__();
  }
  public function removeFirst__(): Object {
    this.throwEmptyException__();
    --size;
    var node: java.util.LinkedList$Node = header.next;
    node.remove__();
    return node.value;
  }
  public function removeLast__(): Object {
    this.throwEmptyException__();
    --size;
    var node: java.util.LinkedList$Node = header.prev;
    node.remove__();
    return node.value;
  }
  public override function size__(): int {
    return size;
  }
  private function addBefore__Ljava_lang_Object_2Ljava_util_LinkedList$Node_2(o: Object, target: java.util.LinkedList$Node): void {
    new java.util.LinkedList$Node(new Arguments(java.util.LinkedList$Node.LinkedList$Node__Ljava_lang_Object_2Ljava_util_LinkedList$Node_2, [o, target]));
    ++size;
  }
  private function throwEmptyException__(): void {
    if (size == 0) {
      throw new NoSuchElementException(new Arguments(java.util.NoSuchElementException.NoSuchElementException__, []));
    }
    return;
  }
  public static function access$0(arg0: java.util.LinkedList, arg1: Object, arg2: java.util.LinkedList$Node): void {
    arg0.addBefore__Ljava_lang_Object_2Ljava_util_LinkedList$Node_2(arg1, arg2);
  }
  public static function access$1(arg0: java.util.LinkedList): java.util.LinkedList$Node {
    return arg0.header;
  }
  public function LinkedList(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Collection) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        LinkedList__();
        break;
      case 1:
        LinkedList__();
        LinkedList__Ljava_util_Collection_2(args1[0]);
        break;
    }
  }
  public static const LinkedList__ : int = 0;
  public static const LinkedList__Ljava_util_Collection_2 : int = 1;
}
}
