package java.util {
import java.lang.Cloneable;
import java.lang.System;
import java.lang.NullPointerException;
import java.lang.StringBuffer;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Locale implements Cloneable {
  internal var language: String;
  internal var country: String;
  internal var variant: String;
  public static var CANADA: Locale = new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2Ljava_lang_String_2, ["en", "CA"]));
  public static var CANADA_FRENCH: Locale = new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2Ljava_lang_String_2, ["fr", "CA"]));
  public static var CHINA: Locale = new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2Ljava_lang_String_2, ["zh", "CN"]));
  public static var CHINESE: Locale = new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2, ["zh"]));
  public static var ENGLISH: Locale = new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2, ["en"]));
  public static var FRANCE: Locale = new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2Ljava_lang_String_2, ["fr", "FR"]));
  public static var FRENCH: Locale = new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2, ["fr"]));
  public static var GERMAN: Locale = new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2, ["de"]));
  public static var GERMANY: Locale = new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2Ljava_lang_String_2, ["de", "DE"]));
  public static var ITALIAN: Locale = new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2, ["it"]));
  public static var ITALY: Locale = new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2Ljava_lang_String_2, ["it", "IT"]));
  public static var JAPAN: Locale = new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2Ljava_lang_String_2, ["ja", "JP"]));
  public static var JAPANESE: Locale = new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2, ["ja"]));
  public static var KOREA: Locale = new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2Ljava_lang_String_2, ["ko", "KR"]));
  public static var KOREAN: Locale = new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2, ["ko"]));
  public static var PRC: Locale = new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2Ljava_lang_String_2, ["zh", "CN"]));
  public static var SIMPLIFIED_CHINESE: Locale = new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2Ljava_lang_String_2, ["zn", "CN"]));
  public static var TAIWAN: Locale = new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2Ljava_lang_String_2, ["zh", "TW"]));
  public static var TRADITIONAL_CHINESE: Locale = new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2Ljava_lang_String_2, ["zh", "TW"]));
  public static var UK: Locale = new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2Ljava_lang_String_2, ["en", "GB"]));
  public static var US: Locale = new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2Ljava_lang_String_2, ["en", "US"]));
  public static var DefaultLocale: Locale = new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2, [System.getProperty__Ljava_lang_String_2Ljava_lang_String_2("user.language", "en"), System.getProperty__Ljava_lang_String_2Ljava_lang_String_2("user.country", ""), System.getProperty__Ljava_lang_String_2Ljava_lang_String_2("user.variant", "")]));
  public function Locale__Ljava_lang_String_2(language: String): Object {
    return this;
  }
  public function Locale__Ljava_lang_String_2Ljava_lang_String_2(language: String, country: String): Object {
    return this;
  }
  public function Locale__Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2(language: String, country: String, variant: String): Object {
    if (language === null || country === null || variant === null) {
      throw new NullPointerException(new Arguments(java.lang.NullPointerException.NullPointerException__, []));
    }
    this.language = language;
    this.country = country;
    this.variant = variant;
    return this;
  }
  public function clone__(): Object {
    return new Locale(new Arguments(java.util.Locale.Locale__Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2, [language, country, variant]));
  }
  public function equals__Ljava_lang_Object_2(other: Object): Boolean {
    if (this === other)
      return true;
    if (!(other is Locale))
      return false;
    var locale: Locale = Locale(other);
    return Object(language).equals__Ljava_lang_Object_2(locale.language) && Object(country).equals__Ljava_lang_Object_2(locale.country) && Object(variant).equals__Ljava_lang_Object_2(locale.variant);
  }
  public function getAvailableLocales__(): JavaArray {
    return new JavaArray("[Ljava/util/Locale;").lengths(0);
  }
  public function getCountry__(): String {
    return country;
  }
  public static function getDefault__(): Locale {
    return DefaultLocale;
  }
  public function getDisplayCountry__(): String {
    return this.getDisplayCountry__Ljava_util_Locale_2(Locale.getDefault__());
  }
  public function getDisplayCountry__Ljava_util_Locale_2(locale: Locale): String {
    return country;
  }
  public function getDisplayLanguage__(): String {
    return this.getDisplayLanguage__Ljava_util_Locale_2(Locale.getDefault__());
  }
  public function getDisplayLanguage__Ljava_util_Locale_2(locale: Locale): String {
    return language;
  }
  public function getDisplayName__(): String {
    return this.getDisplayName__Ljava_util_Locale_2(Locale.getDefault__());
  }
  public function getDisplayName__Ljava_util_Locale_2(locale: Locale): String {
    return null;
  }
  public function getDisplayVariant__(): String {
    return this.getDisplayVariant__Ljava_util_Locale_2(Locale.getDefault__());
  }
  public function getDisplayVariant__Ljava_util_Locale_2(locale: Locale): String {
    return variant;
  }
  public function getLanguage__(): String {
    return language;
  }
  public function getISO3Country__(): String {
    return null;
  }
  public function getISO3Language__(): String {
    return null;
  }
  public static function getISO3Countries__(): JavaArray {
    return null;
  }
  public static function getISO3Languages__(): JavaArray {
    return null;
  }
  public function getVariant__(): String {
    return variant;
  }
  public function hashCode__(): int {
    return Object(language).hashCode__() ^ Object(country).hashCode__() ^ Object(variant).hashCode__();
  }
  public static function setDefault__Ljava_util_Locale_2(locale: Locale): void {
    if (locale === null)
      throw new NullPointerException(new Arguments(java.lang.NullPointerException.NullPointerException__, []));
    DefaultLocale = locale;
  }
  public function toString__(): String {
    if (Object(language).length__() == 0 && Object(country).length__() == 0)
      return "";
    if (Object(country).length__() == 0 && Object(variant).length__() == 0)
      return language;
    var buffer: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__, []));
    buffer.append__Ljava_lang_String_2(language);
    buffer.append__Ljava_lang_String_2("_");
    buffer.append__Ljava_lang_String_2(country);
    if (Object(variant).length__() > 0) {
      buffer.append__Ljava_lang_String_2("_");
      buffer.append__Ljava_lang_String_2(variant);
    }
    return buffer.toString__();
  }
  public function Locale(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is String) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is String && vargs[1] is String) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 3 && vargs[0] is String && vargs[1] is String && vargs[2] is String) {
        args = vargs;
        id = 2;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        args2 = [args0[0], "", ""];
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        args2 = [args1[0], args1[1], ""];
        break;
      case 2:
        var args2: Array = [args[0], args[1], args[2]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Locale__Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2(args2[0], args2[1], args2[2]);
        Locale__Ljava_lang_String_2(args0[0]);
        break;
      case 1:
        Locale__Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2(args2[0], args2[1], args2[2]);
        Locale__Ljava_lang_String_2Ljava_lang_String_2(args1[0], args1[1]);
        break;
      case 2:
        Locale__Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2(args2[0], args2[1], args2[2]);
        break;
    }
  }
  public static const Locale__Ljava_lang_String_2 : int = 0;
  public static const Locale__Ljava_lang_String_2Ljava_lang_String_2 : int = 1;
  public static const Locale__Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2 : int = 2;
}
}
