package java.util {
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class PriorityQueue extends AbstractQueue {
  private var cmp: Comparator;
  private var heap: ArrayList;
  private static function getLeftChild__I(node: int): int {
    return 2 * node + 1;
  }
  private static function getParent__I(node: int): int {
    return int((node - 1) / 2);
  }
  private static function getRightChild__I(node: int): int {
    return 2 * node + 2;
  }
  private static function isLeaf__II(node: int, size: int): Boolean {
    return node * 2 + 1 >= size;
  }
  public function PriorityQueue__(): Object {
    return this;
  }
  public function PriorityQueue__Ljava_util_Collection_2(c: Collection): Object {
    this.addAll__Ljava_util_Collection_2(c);
    return this;
  }
  public function PriorityQueue__I(initialCapacity: int): Object {
    return this;
  }
  public function PriorityQueue__ILjava_util_Comparator_2(initialCapacity: int, cmp: Comparator): Object {
    heap = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__I, [initialCapacity]));
    this.cmp = cmp;
    return this;
  }
  public function PriorityQueue__Ljava_util_PriorityQueue_2(c: PriorityQueue): Object {
    this.addAll__Ljava_util_Collection_2(c);
    return this;
  }
  public function PriorityQueue__Ljava_util_SortedSet_2(c: SortedSet): Object {
    this.addAll__Ljava_util_Collection_2(c);
    return this;
  }
  public override function addAll__Ljava_util_Collection_2(c: Collection): Boolean {
    if (c.isEmpty__()) {
      return false;
    }
    var iter: Iterator = java.util.Iterator(c.iterator__());
    while (iter.hasNext__()) {
      heap.add__Ljava_lang_Object_2(iter.next__());
    }
    this.makeHeap__I(0);
    return true;
  }
  public override function clear__(): void {
    heap.clear__();
  }
  public function comparator__(): Comparator {
    return cmp;
  }
  public override function contains__Ljava_lang_Object_2(o: Object): Boolean {
    return heap.contains__Ljava_lang_Object_2(o);
  }
  public override function containsAll__Ljava_util_Collection_2(c: Collection): Boolean {
    return heap.containsAll__Ljava_util_Collection_2(c);
  }
  public override function isEmpty__(): Boolean {
    return heap.isEmpty__();
  }
  public override function iterator__(): java.util.Iterator {
    return Iterator(Collections.unmodifiableList__Ljava_util_List_2(heap).iterator__());
  }
  public override function offer__Ljava_lang_Object_2(e: Object): Boolean {
    var node: int = heap.size__();
    heap.add__Ljava_lang_Object_2(e);
    while (node > 0) {
      var childNode: int = node;
      node = PriorityQueue.getParent__I(node);
      if (cmp.compare__Ljava_lang_Object_2Ljava_lang_Object_2(heap.get__I(node), e) <= 0) {
        heap.set__ILjava_lang_Object_2(childNode, e);
        return true;
      }
      heap.set__ILjava_lang_Object_2(childNode, heap.get__I(node));
    }
    heap.set__ILjava_lang_Object_2(node, e);
    return true;
  }
  public override function peek__(): Object {
    if (heap.size__() == 0) {
      return null;
    }
    return heap.get__I(0);
  }
  public override function poll__(): Object {
    if (heap.size__() == 0) {
      return null;
    }
    var value: Object = heap.get__I(0);
    this.removeAtIndex__I(0);
    return value;
  }
  public override function remove__Ljava_lang_Object_2(o: Object): Boolean {
    var index: int = heap.indexOf__Ljava_lang_Object_2(o);
    if (index < 0) {
      return false;
    }
    this.removeAtIndex__I(index);
    return true;
  }
  public override function removeAll__Ljava_util_Collection_2(c: Collection): Boolean {
    if (heap.removeAll__Ljava_util_Collection_2(c)) {
      this.makeHeap__I(0);
      return true;
    }
    return false;
  }
  public override function retainAll__Ljava_util_Collection_2(c: Collection): Boolean {
    if (heap.retainAll__Ljava_util_Collection_2(c)) {
      this.makeHeap__I(0);
      return true;
    }
    return false;
  }
  public override function size__(): int {
    return heap.size__();
  }
  public override function toArray__(): JavaArray {
    return heap.toArray__();
  }
  public override function toArray___3Ljava_lang_Object_2(a: JavaArray): JavaArray {
    return JavaArray(heap.toArray___3Ljava_lang_Object_2(a));
  }
  public override function toString__(): String {
    return heap.toString__();
  }
  public function makeHeap__I(node: int): void {
    if (this.isLeaf__I(node)) {
      return;
    }
    this.makeHeap__I(PriorityQueue.getLeftChild__I(node));
    var rightChild: int = PriorityQueue.getRightChild__I(node);
    if (rightChild < heap.size__()) {
      this.makeHeap__I(rightChild);
    }
    this.mergeHeaps__I(node);
    return;
  }
  public function mergeHeaps__I(node: int): void {
    var heapSize: int = heap.size__();
    var value: Object = heap.get__I(node);
    while (!PriorityQueue.isLeaf__II(node, heapSize)) {
      var smallestChild: int = this.getSmallestChild__II(node, heapSize);
      if (cmp.compare__Ljava_lang_Object_2Ljava_lang_Object_2(value, heap.get__I(smallestChild)) < 0) {
        break;
      }
      heap.set__ILjava_lang_Object_2(node, heap.get__I(smallestChild));
      node = smallestChild;
    }
    heap.set__ILjava_lang_Object_2(node, value);
    return;
  }
  private function getSmallestChild__II(node: int, heapSize: int): int {
    var smallestChild: int;
    var leftChild: int = PriorityQueue.getLeftChild__I(node);
    var rightChild: int = leftChild + 1;
    smallestChild = leftChild;
    if ((rightChild < heapSize) && (cmp.compare__Ljava_lang_Object_2Ljava_lang_Object_2(heap.get__I(rightChild), heap.get__I(leftChild)) < 0)) {
      smallestChild = rightChild;
    }
    return smallestChild;
  }
  private function isLeaf__I(node: int): Boolean {
    return PriorityQueue.isLeaf__II(node, heap.size__());
  }
  private function removeAtIndex__I(index: int): void {
    var lastValue: Object = heap.remove__I(heap.size__() - 1);
    if (index < heap.size__()) {
      heap.set__ILjava_lang_Object_2(index, lastValue);
      this.mergeHeaps__I(index);
    }
    return;
  }
  public function PriorityQueue(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Collection) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 1 && vargs[0] is int) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 2 && vargs[0] is int && vargs[1] is Comparator) {
        args = vargs;
        id = 3;
      } else if (vargs.length == 1 && vargs[0] is PriorityQueue) {
        args = vargs;
        id = 4;
      } else if (vargs.length == 1 && vargs[0] is SortedSet) {
        args = vargs;
        id = 5;
      }
    }
    switch (id) {
      case 0:
        args2 = [11];
        args3 = [args2[0], Comparators.natural__()];
        break;
      case 1:
        var args1: Array = [args[0]];
        args2 = [args1[0].size__()];
        args3 = [args2[0], Comparators.natural__()];
        break;
      case 2:
        var args2: Array = [args[0]];
        args3 = [args2[0], Comparators.natural__()];
        break;
      case 3:
        var args3: Array = [args[0], args[1]];
        break;
      case 4:
        var args4: Array = [args[0]];
        args3 = [args4[0].size__(), Comparator(args4[0].comparator__())];
        break;
      case 5:
        var args5: Array = [args[0]];
        args3 = [args5[0].size__(), Comparator(args5[0].comparator__())];
        break;
    }
    super();
    switch (id) {
      case 0:
        PriorityQueue__ILjava_util_Comparator_2(args3[0], args3[1]);
        PriorityQueue__I(args2[0]);
        PriorityQueue__();
        break;
      case 1:
        PriorityQueue__ILjava_util_Comparator_2(args3[0], args3[1]);
        PriorityQueue__I(args2[0]);
        PriorityQueue__Ljava_util_Collection_2(args1[0]);
        break;
      case 2:
        PriorityQueue__ILjava_util_Comparator_2(args3[0], args3[1]);
        PriorityQueue__I(args2[0]);
        break;
      case 3:
        PriorityQueue__ILjava_util_Comparator_2(args3[0], args3[1]);
        break;
      case 4:
        PriorityQueue__ILjava_util_Comparator_2(args3[0], args3[1]);
        PriorityQueue__Ljava_util_PriorityQueue_2(args4[0]);
        break;
      case 5:
        PriorityQueue__ILjava_util_Comparator_2(args3[0], args3[1]);
        PriorityQueue__Ljava_util_SortedSet_2(args5[0]);
        break;
    }
  }
  public static const PriorityQueue__ : int = 0;
  public static const PriorityQueue__Ljava_util_Collection_2 : int = 1;
  public static const PriorityQueue__I : int = 2;
  public static const PriorityQueue__ILjava_util_Comparator_2 : int = 3;
  public static const PriorityQueue__Ljava_util_PriorityQueue_2 : int = 4;
  public static const PriorityQueue__Ljava_util_SortedSet_2 : int = 5;
}
}
