package java.util {
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.StringBuffer;
import java.lang.System;
import java.lang.IllegalArgumentException;
import java.lang.Arguments;
dynamic public class Properties extends Hashtable {
  public var defaults: Properties;
  public function Properties__(): Object {
    return this;
  }
  public function Properties__Ljava_util_Properties_2(defaults: Properties): Object {
    this.defaults = defaults;
    return this;
  }
  public function getProperty__Ljava_lang_String_2(key: String): String {
    return this.getProperty__Ljava_lang_String_2Ljava_lang_String_2(key, null);
  }
  public function getProperty__Ljava_lang_String_2Ljava_lang_String_2(key: String, defaultValue: String): String {
    var properties: Properties = this;
    while (properties !== null) {
      var result: String = String(properties.get__Ljava_lang_Object_2(key));
      if (result !== null)
        return result;
      properties = properties.defaults;
    }
    return defaultValue;
  }
  public function list__Ljava_io_PrintStream_2(out: PrintStream): void {
  }
  public function load__Ljava_io_InputStream_2(in_1: InputStream): void {
    var reader: InputStreamReader = new InputStreamReader(new Arguments(java.io.InputStreamReader.InputStreamReader__Ljava_io_InputStream_2Ljava_lang_String_2, [in_1, "ISO-8859-1"]));
    var key: String = null;
    var buffer: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__, []));
    var state: int = 0;
    var nextState: int = 0;
    var read: int;
    var ignoreLineFeed: Boolean = false;
    while ((read = reader.read__()) != -1) {
      var c: uint = uint(read);
      if (ignoreLineFeed && c == 10) {
        ignoreLineFeed = false;
        continue;
      }
      switch (state) {
        case 0 :
          switch (c) {
            case 32 :
            case 9 :
            case 12 :
            case 13 :
            case 10 :
              break;
            case 35 :
            case 33 :
              state = 1;
              break;
            case 92 :
              nextState = 3;
              state = 2;
              break;
            default :
              buffer.append__C(c);
              state = 3;
          }
          break;
        case 1 :
          switch (c) {
            case 13 :
            case 10 :
              state = 0;
              break;
          }
          break;
        case 2 :
          switch (c) {
            case 92 :
              buffer.append__Ljava_lang_String_2("\\");
              break;
            case 116 :
              buffer.append__Ljava_lang_String_2("\t");
              break;
            case 114 :
              buffer.append__Ljava_lang_String_2("\r");
              break;
            case 110 :
              buffer.append__Ljava_lang_String_2("\n");
              break;
            case 102 :
              buffer.append__Ljava_lang_String_2("\f");
              break;
            case 13 :
              ignoreLineFeed = true;
              break;
            case 10 :
              break;
            case 117 :
              var r: int = Properties.uncodeEscape__I(reader.read__());
              r = (r << 4) | Properties.uncodeEscape__I(reader.read__());
              r = (r << 4) | Properties.uncodeEscape__I(reader.read__());
              r = (r << 4) | Properties.uncodeEscape__I(reader.read__());
              buffer.append__C(uint(r));
              break;
            default :
              buffer.append__C(c);
              break;
          }
          state = nextState;
          break;
        case 3 :
          switch (c) {
            case 92 :
              nextState = 3;
              state = 2;
              break;
            case 13 :
            case 10 :
              state = 0;
              this.put__Ljava_lang_Object_2Ljava_lang_Object_2(buffer.toString__(), "");
              buffer.setLength__I(0);
              break;
            case 32 :
            case 9 :
            case 12 :
              break;
            case 58 :
            case 61 :
              state = 4;
              key = buffer.toString__();
              buffer.setLength__I(0);
              break;
            default :
              buffer.append__C(c);
              break;
          }
          break;
        case 4 :
          switch (c) {
            case 32 :
            case 9 :
            case 12 :
              break;
            case 92 :
              nextState = 5;
              state = 2;
              break;
            case 13 :
            case 10 :
              state = 0;
              this.put__Ljava_lang_Object_2Ljava_lang_Object_2(key, "");
              key = null;
              buffer.setLength__I(0);
              break;
            default :
              state = 5;
              buffer.append__C(c);
              break;
          }
          break;
        case 5 :
          switch (c) {
            case 92 :
              nextState = 5;
              state = 2;
              break;
            case 13 :
            case 10 :
              state = 0;
              this.put__Ljava_lang_Object_2Ljava_lang_Object_2(key, buffer.toString__());
              key = null;
              buffer.setLength__I(0);
              break;
            default :
              buffer.append__C(c);
              break;
          }
          break;
      }
    }
    if (key !== null) {
      this.put__Ljava_lang_Object_2Ljava_lang_Object_2(key, buffer.toString__());
      key = null;
      buffer.setLength__I(0);
    } else {
      if (buffer.length__() != 0) {
        this.put__Ljava_lang_Object_2Ljava_lang_Object_2(buffer.toString__(), "");
      }
    }
    return;
  }
  public function out__Ljava_lang_String_2Z(str: String, key: Boolean): void {
  }
  public function propertyNames__(): java.util.Enumeration {
    return null;
  }
  public function save__Ljava_io_OutputStream_2Ljava_lang_String_2(out: OutputStream, header: String): void {
    try {
      this.store__Ljava_io_OutputStream_2Ljava_lang_String_2(out, header);
    } catch (e : IOException) {
    }
    return;
  }
  public function setProperty__Ljava_lang_String_2Ljava_lang_String_2(key: String, value: String): Object {
    return this.put__Ljava_lang_Object_2Ljava_lang_Object_2(key, value);
  }
  public function store__Ljava_io_OutputStream_2Ljava_lang_String_2(out: OutputStream, header: String): void {
    var writer: OutputStreamWriter = new OutputStreamWriter(new Arguments(java.io.OutputStreamWriter.OutputStreamWriter__Ljava_io_OutputStream_2Ljava_lang_String_2, [out, "ISO-8859-1"]));
    var lineSeparator: String = System.getProperty__Ljava_lang_String_2("line.separator");
    if (header !== null) {
      writer.write__Ljava_lang_String_2("#");
      writer.write__Ljava_lang_String_2(header);
      writer.write__Ljava_lang_String_2(lineSeparator);
    }
    writer.write__Ljava_lang_String_2("#");
    writer.write__Ljava_lang_String_2(new Date__(new Arguments(java.util.Date__.Date____, [])).toString__());
    writer.write__Ljava_lang_String_2(lineSeparator);
    var enumeration: java.util.Enumeration = this.keys__();
    while (enumeration.hasMoreElements__()) {
      var key: String = String(enumeration.nextElement__());
      var value: String = String(this.get__Ljava_lang_Object_2(key));
      this.out__Ljava_lang_String_2Z(key, true);
      writer.write__Ljava_lang_String_2("=");
      this.out__Ljava_lang_String_2Z(value, false);
    }
    writer.flush__();
    return;
  }
  public static function uncodeEscape__I(c: int): int {
    if (c != -1) {
      if (65 <= c && c <= 70)
        return (c - 65) + 10;
      if (97 <= c && c <= 102)
        return (c - 97) + 10;
      if (48 <= c && c <= 57)
        return c - 48;
    }
    throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__Ljava_lang_String_2, ["Malformed unicode escape"]));
    return 0;
  }
  public function Properties(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Properties) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var superArgs: Arguments;
        superArgs = new Arguments(java.util.Hashtable.Hashtable__, []);
        break;
      case 1:
        var args1: Array = [args[0]];
        superArgs = new Arguments(java.util.Hashtable.Hashtable__, []);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        Properties__();
        break;
      case 1:
        Properties__Ljava_util_Properties_2(args1[0]);
        break;
    }
  }
  public static const Properties__ : int = 0;
  public static const Properties__Ljava_util_Properties_2 : int = 1;
}
}
