package java.util {
import java.io.InputStream;
import java.lang.Class__;
import java.lang.Exception;
import java.lang.ClassLoader;
import java.lang.System;
import java.lang.NullPointerException;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ResourceBundle {
  internal var locale: Locale;
  public var parent: ResourceBundle;
  public function ResourceBundle() {
    return;
  }
  public static function getBundle__Ljava_lang_String_2(baseName: String): ResourceBundle {
    return getBundle__Ljava_lang_String_2Ljava_util_Locale_2(baseName, Locale.getDefault__());
  }
  public static function getBundle__Ljava_lang_String_2Ljava_util_Locale_2(baseName: String, locale: Locale): ResourceBundle {
    var bundle: ResourceBundle = null;
    var previousBundle: ResourceBundle = null;
    var localeString: String = locale.toString__();
    while (Object(localeString).length__() > 0) {
      var temp: ResourceBundle = findBundle__Ljava_lang_String_2Ljava_lang_String_2(baseName, localeString);
      if (temp !== null) {
        if (bundle === null)
          bundle = temp;
        if (previousBundle !== null)
          previousBundle.setParent__Ljava_util_ResourceBundle_2(temp);
        previousBundle = temp;
      }
      var index: int = Object(localeString).lastIndexOf__Ljava_lang_String_2("_");
      if (index == -1)
        break;
      localeString = Object(localeString).substring__II(0, index);
    }
    if (!locale.equals__Ljava_lang_Object_2(Locale.getDefault__())) {
      localeString = Locale.getDefault__().toString__();
      while (Object(localeString).length__() > 0) {
        var temp_1: ResourceBundle = findBundle__Ljava_lang_String_2Ljava_lang_String_2(baseName, localeString);
        if (temp_1 !== null) {
          if (bundle === null)
            bundle = temp_1;
          if (previousBundle !== null && previousBundle.parent === null) {
            previousBundle.setParent__Ljava_util_ResourceBundle_2(temp_1);
          }
          previousBundle = temp_1;
        }
        var index_1: int = Object(localeString).lastIndexOf__Ljava_lang_String_2("_");
        if (index_1 == -1)
          break;
        localeString = Object(localeString).substring__II(0, index_1);
      }
    }
    var temp_2: ResourceBundle = findBundle__Ljava_lang_String_2Ljava_lang_String_2(baseName, "");
    if (temp_2 !== null) {
      if (bundle === null)
        bundle = temp_2;
      if (previousBundle !== null)
        previousBundle.setParent__Ljava_util_ResourceBundle_2(temp_2);
      previousBundle = temp_2;
    }
    if (bundle === null) {
      throw new MissingResourceException("Resource bundle not found", baseName, null);
    }
    return bundle;
  }
  public static function findBundle__Ljava_lang_String_2Ljava_lang_String_2(baseName: String, localeString: String): ResourceBundle {
    var bundle: ResourceBundle = null;
    var name: String = baseName;
    if (Object(localeString).length__() != 0)
      name += "_" + localeString;
    try {
      var clazz: Class__ = Class__.forName__Ljava_lang_String_2(name);
      bundle = ResourceBundle(clazz.newInstance__());
    } catch (e : Exception) {
      var stream: InputStream = ClassLoader.getSystemResourceAsStream__Ljava_lang_String_2(Object(name).replace__CC(46, 47) + ".properties");
      try {
        System.out.println__Ljava_lang_Object_2(stream);
        bundle = new PropertyResourceBundle(stream);
      } catch (e1 : Exception) {
      }
    }
    return bundle;
  }
  public function getKeys__(): Enumeration { // abstract
    return null;
  }
  public function getLocale__(): Locale {
    return locale;
  }
  public function getObject__Ljava_lang_String_2(key: String): Object {
    if (key === null)
      throw new NullPointerException(new Arguments(java.lang.NullPointerException.NullPointerException__, []));
    var bundle: ResourceBundle = this;
    while (bundle !== null) {
      var result: Object = bundle.handleGetObject__Ljava_lang_String_2(key);
      if (result !== null)
        return result;
      bundle = bundle.parent;
    }
    throw new MissingResourceException("Missing key", null, key);
    return null;
  }
  public function getString__Ljava_lang_String_2(key: String): String {
    return String(this.getObject__Ljava_lang_String_2(key));
  }
  public function getStringArray__Ljava_lang_String_2(key: String): JavaArray {
    return JavaArray(this.getStringArray__Ljava_lang_String_2(key));
  }
  public function handleGetObject__Ljava_lang_String_2(key: String): Object { // abstract
    return null;
  }
  public function setParent__Ljava_util_ResourceBundle_2(parent_1: ResourceBundle): void {
    this.parent = parent_1;
  }
}
}
