package java.util {
import java.lang.JavaArray;
dynamic public class TimeZone {
  internal var id: String;
  public static var TimeZones: JavaArray;
  public function TimeZone() {
    return;
  }
  public static function getAvailableIDs__(): JavaArray {
    initTimeZones__();
    var ids: JavaArray = new JavaArray("[Ljava/lang/String;").lengths(TimeZones.length);
    for (var i: int = 0; i < ids.length; i++) {
      ids[i] = TimeZones[i].getID__();
    }
    return ids;
  }
  public static function getDefault__(): TimeZone {
    initTimeZones__();
    return TimeZones[TimeZones.length - 1];
  }
  public function getID__(): String {
    return id;
  }
  private static function getLocalTimeZone__(): TimeZone {
    var date:Date = new Date();
    var str:String = date.toString();
    var end:int = str.lastIndexOf(" ");
    var start:int = str.lastIndexOf(" ", end - 1);
    return new SimpleTimeZone(str.substring(start + 1, end), date.timezoneOffset * -60000);
  }
  public function getOffset__IIIIII(era: int, year: int, month: int, day: int, dayOfWeek: int, millis: int): int { // abstract
    return 0;
  }
  public function getRawOffset__(): int { // abstract
    return 0;
  }
  public static function getTimeZone__Ljava_lang_String_2(ID: String): TimeZone {
    initTimeZones__();
    for (var i: int = 0; i < TimeZones.length; i++) {
      if (Object(TimeZones[i].getID__()).equals__Ljava_lang_Object_2(ID))
        return TimeZones[i];
    }
    return null;
  }
  private static function initTimeZones__(): void {
    if (TimeZones !== null)
      return;
    var gmt: TimeZone = new SimpleTimeZone("GMT", 0);
    var local: TimeZone = getLocalTimeZone__();
    if (local === null) {
      TimeZones = new JavaArray("[Ljava/util/TimeZone;").values(gmt);
    } else {
      TimeZones = new JavaArray("[Ljava/util/TimeZone;").values(gmt, local);
    }
    return;
  }
  public function useDaylightTime__(): Boolean { // abstract
    return false;
  }
}
}
