package java.util {
import java.lang.Math__;
import java.lang.System;
import java.lang.IllegalStateException;
import java.lang.Arguments;
dynamic public class Timer {
  internal var cancelled: Boolean;
  public function Timer__(): Object {
    return this;
  }
  public function Timer__Z(isDaemon: Boolean): Object {
    return this;
  }
  public function cancel__(): void {
    cancelled = true;
    return;
  }
  public function schedule__Ljava_util_TimerTask_2Ljava_util_Date_2(task: TimerTask, time: Date__): void {
    this.schedule__Ljava_util_TimerTask_2J(task, Math__.max__JJ(0, time.getTime__() - System.currentTimeMillis__()));
    return;
  }
  public function schedule__Ljava_util_TimerTask_2Ljava_util_Date_2J(task: TimerTask, firstTime: Date__, period: Number): void {
    this.schedule__Ljava_util_TimerTask_2JJ(task, Math__.max__JJ(0, firstTime.getTime__() - System.currentTimeMillis__()), period);
    return;
  }
  public function schedule__Ljava_util_TimerTask_2J(task: TimerTask, delay: Number): void {
    this.schedule__Ljava_util_TimerTask_2JJ(task, delay, 0);
    return;
  }
  public function schedule__Ljava_util_TimerTask_2JJ(task: TimerTask, delay: Number, period: Number): void {
    if (task.timer !== null || task.canceled || cancelled) {
      throw new IllegalStateException(new Arguments(java.lang.IllegalStateException.IllegalStateException__, []));
    }
    task.start__Ljava_util_Timer_2JJ(this, delay, period);
    return;
  }
  public function scheduleAtFixedRate__Ljava_util_TimerTask_2Ljava_util_Date_2J(task: TimerTask, firstTime: Date__, period: Number): void {
    this.scheduleAtFixedRate__Ljava_util_TimerTask_2JJ(task, Math__.max__JJ(0, firstTime.getTime__() - System.currentTimeMillis__()), period);
    return;
  }
  public function scheduleAtFixedRate__Ljava_util_TimerTask_2JJ(task: TimerTask, delay: Number, period: Number): void {
    this.schedule__Ljava_util_TimerTask_2JJ(task, delay, period);
    return;
  }
  public function Timer(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Boolean) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        args1 = [false];
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Timer__Z(args1[0]);
        Timer__();
        break;
      case 1:
        Timer__Z(args1[0]);
        break;
    }
  }
  public static const Timer__ : int = 0;
  public static const Timer__Z : int = 1;
}
}
