package java.util {
import java.lang.IllegalArgumentException;
import java.lang.Comparable;
import java.lang.NullPointerException;
import java.lang.RuntimeException;
import java.lang.Arguments;
import java.lang.Class__;
import java.lang.Enum;
import java.lang.JavaArray;
import java.lang.System;
dynamic public class TreeMap extends AbstractMap implements SortedMap {
  public static var DEFAULT_COMPARATOR: Comparator = new java.util.TreeMap$1();
  public static const LEFT: int = 0;
  public static const RIGHT: int = 1;
  private var cmp: java.util.Comparator;
  private var root: java.util.TreeMap$Node;
  private var size: int = 0;
  private static function otherChild__I(child: int): int {
    if (!((child == 0 || child == 1))) {
      throw new java.lang.AssertionError(new Arguments(0, []));
    }
    return 1 - child;
  }
  private static function throwNSE__Ljava_util_TreeMap$Node_2(node: TreeMap$Node): TreeMap$Node {
    if (node === null) {
      throw new NoSuchElementException(new Arguments(java.util.NoSuchElementException.NoSuchElementException__, []));
    }
    return node;
  }
  public function TreeMap__(): Object {
    return this;
  }
  public function TreeMap__Ljava_util_Comparator_2(c: java.util.Comparator): Object {
    root = null;
    if (c === null) {
      c = Comparator(DEFAULT_COMPARATOR);
    }
    cmp = c;
    return this;
  }
  public function TreeMap__Ljava_util_Map_2(map: Map): Object {
    this.putAll__Ljava_util_Map_2(map);
    return this;
  }
  public function TreeMap__Ljava_util_SortedMap_2(map: SortedMap): Object {
    this.putAll__Ljava_util_Map_2(map);
    return this;
  }
  public override function clear__(): void {
    root = null;
    size = 0;
    return;
  }
  public function comparator__(): java.util.Comparator {
    if (cmp === DEFAULT_COMPARATOR) {
      return null;
    }
    return cmp;
  }
  public override function containsKey__Ljava_lang_Object_2(key: Object): Boolean {
    return this.getEntry__Ljava_lang_Object_2(Object(key)) !== null;
  }
  public override function entrySet__(): java.util.Set {
    return new TreeMap$EntrySet(this);
  }
  public function firstKey__(): Object {
    return java.util.TreeMap.throwNSE__Ljava_util_TreeMap$Node_2(this.getFirstNode__()).key;
  }
  public override function get__Ljava_lang_Object_2(k: Object): Object {
    var key: Object = Object(k);
    var entry: java.util.TreeMap$Node = this.getEntry__Ljava_lang_Object_2(key);
    return entry !== null ? entry.getValue__() : null;
  }
  public function headMap__Ljava_lang_Object_2(toKey: Object): SortedMap {
    return new java.util.TreeMap$SubMap(this, TreeMap$SubMapType.Head, null, toKey);
  }
  public function lastKey__(): Object {
    return java.util.TreeMap.throwNSE__Ljava_util_TreeMap$Node_2(this.getLastNode__()).key;
  }
  public override function put__Ljava_lang_Object_2Ljava_lang_Object_2(key: Object, value: Object): Object {
    var node: java.util.TreeMap$Node = new java.util.TreeMap$Node(new Arguments(java.util.TreeMap$Node.TreeMap$Node__Ljava_lang_Object_2Ljava_lang_Object_2, [key, value]));
    var state: TreeMap$State = new TreeMap$State();
    root = this.insert__Ljava_util_TreeMap$Node_2Ljava_util_TreeMap$Node_2Ljava_util_TreeMap$State_2(root, node, state);
    if (!state.found) {
      ++size;
    }
    root.isRed = false;
    return state.value;
  }
  public override function remove__Ljava_lang_Object_2(keyObj: Object): Object {
    var key: Object = Object(keyObj);
    var state: TreeMap$State = new TreeMap$State();
    this.removeWithState__Ljava_lang_Object_2Ljava_util_TreeMap$State_2(key, state);
    return state.value;
  }
  public override function size__(): int {
    return size;
  }
  public function subMap__Ljava_lang_Object_2Ljava_lang_Object_2(fromKey: Object, toKey: Object): SortedMap {
    return new java.util.TreeMap$SubMap(this, TreeMap$SubMapType.Range, fromKey, toKey);
  }
  public function tailMap__Ljava_lang_Object_2(fromKey: Object): SortedMap {
    return new java.util.TreeMap$SubMap(this, TreeMap$SubMapType.Tail, fromKey, null);
  }
  public function getNodeAtOrAfter__Ljava_lang_Object_2(key: Object): java.util.TreeMap$Node {
    var foundNode: java.util.TreeMap$Node = null;
    var node: java.util.TreeMap$Node = root;
    while (node !== null) {
      var c: int = cmp.compare__Ljava_lang_Object_2Ljava_lang_Object_2(key, node.key);
      if (c == 0) {
        return node;
      } else if (c > 0) {
        node = node.child[1];
      } else {
        foundNode = node;
        node = node.child[0];
      }
    }
    return foundNode;
  }
  public function getNodeBefore__Ljava_lang_Object_2(key: Object): java.util.TreeMap$Node {
    var foundNode: java.util.TreeMap$Node = null;
    var node: java.util.TreeMap$Node = root;
    while (node !== null) {
      var c: int = cmp.compare__Ljava_lang_Object_2Ljava_lang_Object_2(key, node.key);
      if (c <= 0) {
        node = node.child[0];
      } else {
        foundNode = node;
        node = node.child[1];
      }
    }
    return foundNode;
  }
  public function assertCorrectness__(): void {
    this.assertCorrectness__Ljava_util_TreeMap$Node_2Z(root, true);
  }
  private function assertCorrectness__Ljava_util_TreeMap$Node_2Z(tree: java.util.TreeMap$Node, isRed: Boolean): int {
    if (tree === null) {
      return 0;
    }
    if (isRed && tree.isRed) {
      throw new RuntimeException(new Arguments(java.lang.RuntimeException.RuntimeException__Ljava_lang_String_2, ["Two red nodes adjacent"]));
    }
    if (tree.child[0] !== null && cmp.compare__Ljava_lang_Object_2Ljava_lang_Object_2(tree.child[0].key, tree.key) > 0) {
      throw new RuntimeException(new Arguments(java.lang.RuntimeException.RuntimeException__Ljava_lang_String_2, ["Left child " + java.lang.System.stringValueOf(tree.child[0]) + " larger than " + java.lang.System.stringValueOf(tree)]));
    }
    if (tree.child[1] !== null && cmp.compare__Ljava_lang_Object_2Ljava_lang_Object_2(tree.child[1].key, tree.key) < 0) {
      throw new RuntimeException(new Arguments(java.lang.RuntimeException.RuntimeException__Ljava_lang_String_2, ["Right child " + java.lang.System.stringValueOf(tree.child[1]) + " smaller than " + java.lang.System.stringValueOf(tree)]));
    }
    var leftHeight: int = this.assertCorrectness__Ljava_util_TreeMap$Node_2Z(tree.child[0], tree.isRed);
    var rightHeight: int = this.assertCorrectness__Ljava_util_TreeMap$Node_2Z(tree.child[1], tree.isRed);
    if (leftHeight != 0 && rightHeight != 0 && leftHeight != rightHeight) {
      throw new RuntimeException(new Arguments(java.lang.RuntimeException.RuntimeException__Ljava_lang_String_2, ["Black heights don\'t match"]));
    }
    return tree.isRed ? leftHeight : leftHeight + 1;
  }
  private function getEntry__Ljava_lang_Object_2(key: Object): java.util.TreeMap$Node {
    var tree: java.util.TreeMap$Node = root;
    while (tree !== null) {
      var c: int = cmp.compare__Ljava_lang_Object_2Ljava_lang_Object_2(key, tree.key);
      if (c == 0) {
        return tree;
      }
      if (c < 0) {
        tree = tree.child[0];
      } else {
        tree = tree.child[1];
      }
    }
    return null;
  }
  private function getFirstNode__(): java.util.TreeMap$Node {
    if (root === null) {
      return null;
    }
    var node: java.util.TreeMap$Node = root;
    while (node.child[0] !== null) {
      node = node.child[0];
    }
    return node;
  }
  private function getLastNode__(): java.util.TreeMap$Node {
    if (root === null) {
      return null;
    }
    var node: java.util.TreeMap$Node = root;
    while (node.child[1] !== null) {
      node = node.child[1];
    }
    return node;
  }
  private function insert__Ljava_util_TreeMap$Node_2Ljava_util_TreeMap$Node_2Ljava_util_TreeMap$State_2(tree: java.util.TreeMap$Node, newNode: java.util.TreeMap$Node, state: TreeMap$State): java.util.TreeMap$Node {
    if (tree === null) {
      return newNode;
    } else {
      var c: int = cmp.compare__Ljava_lang_Object_2Ljava_lang_Object_2(tree.key, newNode.key);
      if (c == 0) {
        state.value = tree.value;
        state.found = true;
        tree.value = newNode.value;
        return tree;
      }
      var childNum: int = (c > 0) ? 0 : 1;
      tree.child[childNum] = this.insert__Ljava_util_TreeMap$Node_2Ljava_util_TreeMap$Node_2Ljava_util_TreeMap$State_2(tree.child[childNum], newNode, state);
      if (this.isRed__Ljava_util_TreeMap$Node_2(tree.child[childNum])) {
        if (this.isRed__Ljava_util_TreeMap$Node_2(tree.child[java.util.TreeMap.otherChild__I(childNum)])) {
          tree.isRed = true;
          tree.child[0].isRed = false;
          tree.child[1].isRed = false;
        } else {
          if (this.isRed__Ljava_util_TreeMap$Node_2(tree.child[childNum].child[childNum])) {
            tree = this.rotateSingle__Ljava_util_TreeMap$Node_2I(tree, java.util.TreeMap.otherChild__I(childNum));
          } else if (this.isRed__Ljava_util_TreeMap$Node_2(tree.child[childNum].child[java.util.TreeMap.otherChild__I(childNum)])) {
            tree = this.rotateDouble__Ljava_util_TreeMap$Node_2I(tree, java.util.TreeMap.otherChild__I(childNum));
          }
        }
      }
    }
    return tree;
  }
  private function isRed__Ljava_util_TreeMap$Node_2(node: java.util.TreeMap$Node): Boolean {
    return node !== null && node.isRed;
  }
  private function removeWithState__Ljava_lang_Object_2Ljava_util_TreeMap$State_2(key: Object, state: TreeMap$State): Boolean {
    if (root === null) {
      return false;
    }
    var node: java.util.TreeMap$Node;
    var found: java.util.TreeMap$Node = null;
    var parent: java.util.TreeMap$Node = null;
    var grandparent: java.util.TreeMap$Node = null;
    var head: java.util.TreeMap$Node = new java.util.TreeMap$Node(new Arguments(java.util.TreeMap$Node.TreeMap$Node__Ljava_lang_Object_2Ljava_lang_Object_2, [null, null]));
    var dir: int = 1;
    head.child[1] = root;
    node = head;
    while (node.child[dir] !== null) {
      var last: int = dir;
      grandparent = parent;
      parent = node;
      node = node.child[dir];
      var c: int = cmp.compare__Ljava_lang_Object_2Ljava_lang_Object_2(node.key, key);
      dir = c < 0 ? 1 : 0;
      if (c == 0 && (!state.matchValue || Object(node.value).equals__Ljava_lang_Object_2(state.value))) {
        found = node;
      }
      if (!this.isRed__Ljava_util_TreeMap$Node_2(node) && !this.isRed__Ljava_util_TreeMap$Node_2(node.child[dir])) {
        if (this.isRed__Ljava_util_TreeMap$Node_2(node.child[java.util.TreeMap.otherChild__I(dir)])) {
          parent = parent.child[last] = this.rotateSingle__Ljava_util_TreeMap$Node_2I(node, dir);
        } else if (!this.isRed__Ljava_util_TreeMap$Node_2(node.child[java.util.TreeMap.otherChild__I(dir)])) {
          var sibling: java.util.TreeMap$Node = parent.child[java.util.TreeMap.otherChild__I(last)];
          if (sibling !== null) {
            if (!this.isRed__Ljava_util_TreeMap$Node_2(sibling.child[java.util.TreeMap.otherChild__I(last)]) && !this.isRed__Ljava_util_TreeMap$Node_2(sibling.child[last])) {
              parent.isRed = false;
              sibling.isRed = true;
              node.isRed = true;
            } else {
              var dir2: int = grandparent.child[1] === parent ? 1 : 0;
              if (this.isRed__Ljava_util_TreeMap$Node_2(sibling.child[last])) {
                grandparent.child[dir2] = this.rotateDouble__Ljava_util_TreeMap$Node_2I(parent, last);
              } else if (this.isRed__Ljava_util_TreeMap$Node_2(sibling.child[java.util.TreeMap.otherChild__I(last)])) {
                grandparent.child[dir2] = this.rotateSingle__Ljava_util_TreeMap$Node_2I(parent, last);
              }
              node.isRed = grandparent.child[dir2].isRed = true;
              grandparent.child[dir2].child[0].isRed = false;
              grandparent.child[dir2].child[1].isRed = false;
            }
          }
        }
      }
    }
    if (found !== null) {
      if (state !== null) {
        state.found = true;
        state.value = found.value;
      }
      found.key = node.key;
      found.value = node.value;
      parent.child[parent.child[1] === node ? 1 : 0] = node.child[node.child[0] === null ? 1 : 0];
      size--;
    }
    root = head.child[1];
    if (root !== null) {
      root.isRed = false;
    }
    return state.found;
  }
  private function rotateDouble__Ljava_util_TreeMap$Node_2I(tree: java.util.TreeMap$Node, rotateDirection: int): java.util.TreeMap$Node {
    tree.child[java.util.TreeMap.otherChild__I(rotateDirection)] = this.rotateSingle__Ljava_util_TreeMap$Node_2I(tree.child[java.util.TreeMap.otherChild__I(rotateDirection)], java.util.TreeMap.otherChild__I(rotateDirection));
    return this.rotateSingle__Ljava_util_TreeMap$Node_2I(tree, rotateDirection);
  }
  private function rotateSingle__Ljava_util_TreeMap$Node_2I(tree: java.util.TreeMap$Node, rotateDirection: int): java.util.TreeMap$Node {
    var save: java.util.TreeMap$Node = tree.child[java.util.TreeMap.otherChild__I(rotateDirection)];
    tree.child[java.util.TreeMap.otherChild__I(rotateDirection)] = save.child[rotateDirection];
    save.child[rotateDirection] = tree;
    tree.isRed = true;
    save.isRed = false;
    return save;
  }
  public static function access$0(arg0: java.util.TreeMap): java.util.TreeMap$Node {
    return arg0.root;
  }
  public static function access$1(arg0: java.util.TreeMap): java.util.Comparator {
    return arg0.cmp;
  }
  public static function access$2(arg0: java.util.TreeMap, arg1: Object): java.util.TreeMap$Node {
    return arg0.getEntry__Ljava_lang_Object_2(arg1);
  }
  public static function access$3(arg0: java.util.TreeMap, arg1: Object, arg2: TreeMap$State): Boolean {
    return arg0.removeWithState__Ljava_lang_Object_2Ljava_util_TreeMap$State_2(arg1, arg2);
  }
  public static function access$4(arg0: TreeMap$Node): TreeMap$Node {
    return throwNSE__Ljava_util_TreeMap$Node_2(arg0);
  }
  public static function access$5(arg0: java.util.TreeMap): java.util.TreeMap$Node {
    return arg0.getFirstNode__();
  }
  public static function access$6(arg0: java.util.TreeMap): java.util.TreeMap$Node {
    return arg0.getLastNode__();
  }
  public function TreeMap(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is java.util.Comparator) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 1 && vargs[0] is Map) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 1 && vargs[0] is SortedMap) {
        args = vargs;
        id = 3;
      }
    }
    switch (id) {
      case 0:
        args1 = [Comparator(null)];
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
      case 2:
        var args2: Array = [args[0]];
        args1 = [Comparator(null)];
        break;
      case 3:
        var args3: Array = [args[0]];
        args1 = [args3[0].comparator__()];
        break;
    }
    super();
    switch (id) {
      case 0:
        TreeMap__Ljava_util_Comparator_2(args1[0]);
        TreeMap__();
        break;
      case 1:
        TreeMap__Ljava_util_Comparator_2(args1[0]);
        break;
      case 2:
        TreeMap__Ljava_util_Comparator_2(args1[0]);
        TreeMap__();
        TreeMap__Ljava_util_Map_2(args2[0]);
        break;
      case 3:
        TreeMap__Ljava_util_Comparator_2(args1[0]);
        TreeMap__Ljava_util_SortedMap_2(args3[0]);
        break;
    }
  }
  public static const TreeMap__ : int = 0;
  public static const TreeMap__Ljava_util_Comparator_2 : int = 1;
  public static const TreeMap__Ljava_util_Map_2 : int = 2;
  public static const TreeMap__Ljava_util_SortedMap_2 : int = 3;
}
}
