package java.util {
import java.io.Serializable;
import java.lang.Cloneable;
import java.lang.IndexOutOfBoundsException;
import java.lang.ArrayIndexOutOfBoundsException;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Vector extends AbstractList implements List, RandomAccess, Cloneable, Serializable {
  private var arrayList: ArrayList;
  private var exposeElement: Object;
  public function Vector__(): Object {
    arrayList = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    return this;
  }
  public function Vector__Ljava_util_Collection_2(c: Collection): Object {
    arrayList = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    this.addAll__Ljava_util_Collection_2(c);
    return this;
  }
  public function Vector__I(initialCapacity: int): Object {
    arrayList = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__I, [initialCapacity]));
    return this;
  }
  public function Vector__II(initialCapacity: int, ignoredCapacityIncrement: int): Object {
    return this;
  }
  public override function add__Ljava_lang_Object_2(o: Object): Boolean {
    return arrayList.add__Ljava_lang_Object_2(o);
  }
  public override function add__ILjava_lang_Object_2(index: int, o: Object): void {
    arrayList.add__ILjava_lang_Object_2(index, o);
  }
  public override function addAll__Ljava_util_Collection_2(c: Collection): Boolean {
    return arrayList.addAll__Ljava_util_Collection_2(c);
  }
  public override function addAll__ILjava_util_Collection_2(index: int, c: Collection): Boolean {
    return arrayList.addAll__ILjava_util_Collection_2(index, c);
  }
  public function addElement__Ljava_lang_Object_2(o: Object): void {
    this.add__Ljava_lang_Object_2(o);
  }
  public function capacity__(): int {
    return arrayList.capacity__();
  }
  public override function clear__(): void {
    arrayList.clear__();
  }
  public function clone__(): Object {
    return new Vector(new Arguments(java.util.Vector.Vector__Ljava_util_Collection_2, [this]));
  }
  public override function contains__Ljava_lang_Object_2(elem: Object): Boolean {
    return arrayList.contains__Ljava_lang_Object_2(elem);
  }
  public override function containsAll__Ljava_util_Collection_2(c: Collection): Boolean {
    return arrayList.containsAll__Ljava_util_Collection_2(c);
  }
  public function copyInto___3Ljava_lang_Object_2(objs: JavaArray): void {
    var i: int = -1;
    var n: int = this.size__();
    while (++i < n) {
      objs[i] = this.get__I(i);
    }
    return;
  }
  public function elementAt__I(index: int): Object {
    return this.get__I(index);
  }
  public function elements__(): Enumeration {
    return Collections.enumeration__Ljava_util_Collection_2(arrayList);
  }
  public function ensureCapacity__I(capacity: int): void {
    arrayList.ensureCapacity__I(capacity);
  }
  public function firstElement__(): Object {
    return this.get__I(0);
  }
  public override function get__I(index: int): Object {
    return arrayList.get__I(index);
  }
  public override function indexOf__Ljava_lang_Object_2(elem: Object): int {
    return arrayList.indexOf__Ljava_lang_Object_2(elem);
  }
  public function indexOf__Ljava_lang_Object_2I(elem: Object, index: int): int {
    if (index < 0) {
      AbstractList.indexOutOfBounds__II(index, this.size__());
    }
    return arrayList.indexOf__Ljava_lang_Object_2I(elem, index);
  }
  public function insertElementAt__Ljava_lang_Object_2I(o: Object, index: int): void {
    this.add__ILjava_lang_Object_2(index, o);
  }
  public override function isEmpty__(): Boolean {
    return (arrayList.size__() == 0);
  }
  public override function iterator__(): java.util.Iterator {
    return Iterator(arrayList.iterator__());
  }
  public function lastElement__(): Object {
    if (this.isEmpty__()) {
      throw new IndexOutOfBoundsException(new Arguments(java.lang.IndexOutOfBoundsException.IndexOutOfBoundsException__Ljava_lang_String_2, ["last"]));
    } else {
      return this.get__I(this.size__() - 1);
    }
    return null;
  }
  public override function lastIndexOf__Ljava_lang_Object_2(o: Object): int {
    return arrayList.lastIndexOf__Ljava_lang_Object_2(o);
  }
  public function lastIndexOf__Ljava_lang_Object_2I(o: Object, index: int): int {
    if (index >= this.size__()) {
      AbstractList.indexOutOfBounds__II(index, this.size__());
    }
    return arrayList.lastIndexOf__Ljava_lang_Object_2I(o, index);
  }
  public override function remove__I(index: int): Object {
    return arrayList.remove__I(index);
  }
  public override function removeAll__Ljava_util_Collection_2(c: Collection): Boolean {
    return arrayList.removeAll__Ljava_util_Collection_2(c);
  }
  public function removeAllElements__(): void {
    this.clear__();
  }
  public function removeElement__Ljava_lang_Object_2(o: Object): Boolean {
    return this.remove__Ljava_lang_Object_2(o);
  }
  public function removeElementAt__I(index: int): void {
    this.remove__I(index);
  }
  public override function set__ILjava_lang_Object_2(index: int, elem: Object): Object {
    return arrayList.set__ILjava_lang_Object_2(index, elem);
  }
  public function setElementAt__Ljava_lang_Object_2I(o: Object, index: int): void {
    this.set__ILjava_lang_Object_2(index, o);
  }
  public function setSize__I(size: int): void {
    if (size < 0) {
      throw new ArrayIndexOutOfBoundsException(new Arguments(java.lang.ArrayIndexOutOfBoundsException.ArrayIndexOutOfBoundsException__, []));
    }
    arrayList.setSize__I(size);
    return;
  }
  public override function size__(): int {
    return arrayList.size__();
  }
  public override function toArray__(): JavaArray {
    return arrayList.toArray__();
  }
  public override function toArray___3Ljava_lang_Object_2(a: JavaArray): JavaArray {
    return JavaArray(arrayList.toArray___3Ljava_lang_Object_2(a));
  }
  public override function toString__(): String {
    return arrayList.toString__();
  }
  public function trimToSize__(): void {
    arrayList.trimToSize__();
  }
  public override function removeRange__II(fromIndex: int, endIndex: int): void {
    arrayList.removeRange__II(fromIndex, endIndex);
  }
  public function Vector(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Collection) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 1 && vargs[0] is int) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 2 && vargs[0] is int && vargs[1] is int) {
        args = vargs;
        id = 3;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
      case 2:
        var args2: Array = [args[0]];
        break;
      case 3:
        var args3: Array = [args[0], args[1]];
        args2 = [args3[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Vector__();
        break;
      case 1:
        Vector__Ljava_util_Collection_2(args1[0]);
        break;
      case 2:
        Vector__I(args2[0]);
        break;
      case 3:
        Vector__I(args2[0]);
        Vector__II(args3[0], args3[1]);
        break;
    }
  }
  public static const Vector__ : int = 0;
  public static const Vector__Ljava_util_Collection_2 : int = 1;
  public static const Vector__I : int = 2;
  public static const Vector__II : int = 3;
}
}
