/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class PropertyChangeSupport {
	
	Object source;
	ArrayList allPropertyListeners;
	HashMap propertyListeners;
	
public PropertyChangeSupport(Object sourceBean) {
	this.source = sourceBean;
	allPropertyListeners = new ArrayList();
	propertyListeners = new HashMap();
}

public void addPropertyChangeListener(PropertyChangeListener listener) {
	allPropertyListeners.add(listener);
}

public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
	ArrayList listeners = (ArrayList)propertyListeners.get(propertyName);
	if (listeners == null) propertyListeners.put(propertyName, listeners = new ArrayList());
	listeners.add(listener);
}

public void firePropertyChange(PropertyChangeEvent event) {
	if (event.getNewValue() != null && event.getOldValue() != null) {
		if (event.getNewValue().equals(event.getOldValue())) return;
	}
	String propertyName = event.getPropertyName();
	ArrayList listeners;
	if (propertyName != null) {
		listeners = (ArrayList)propertyListeners.get(propertyName);
		if (listeners != null) {
			Iterator iter = listeners.iterator();
			while (iter.hasNext()) {
				PropertyChangeListener listener = (PropertyChangeListener)iter.next();
				if (listener != null) listener.propertyChange(event);
			}
		}
	}
	listeners = allPropertyListeners;
	if (listeners != null) {
		Iterator iter = listeners.iterator();
		while (iter.hasNext()) {
			PropertyChangeListener listener = (PropertyChangeListener)iter.next();
			if (listener != null) listener.propertyChange(event);
		}
	}
}

public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
	firePropertyChange(propertyName, new Boolean(oldValue), new Boolean(newValue));
}

public void firePropertyChange(String propertyName, int oldValue, int newValue) {
	firePropertyChange(propertyName, new Integer(oldValue), new Integer(newValue));
}

public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
	firePropertyChange(new PropertyChangeEvent(source, propertyName, oldValue, newValue));
}

public PropertyChangeListener[] getPropertyChangeListeners() {
	PropertyChangeListener[] result = new PropertyChangeListener[allPropertyListeners.size()];
	return (PropertyChangeListener[])allPropertyListeners.toArray(result);
}

public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
	ArrayList listeners = (ArrayList)propertyListeners.get(propertyName);
	if (listeners == null) return new PropertyChangeListener[0];
	PropertyChangeListener[] result = new PropertyChangeListener[listeners.size()];
	return (PropertyChangeListener[])listeners.toArray(result);
}

public void removePropertyChangeListener(PropertyChangeListener listener) {
	allPropertyListeners.remove(listener);
}

public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
	ArrayList listeners = (ArrayList)propertyListeners.get(propertyName);
	if (listeners != null) listeners.remove(listener); 
	
}
}
