/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.io;

public interface DataInput {

public boolean readBoolean() throws IOException;

public byte readByte() throws IOException;

public char readChar() throws IOException;

public double readDouble() throws IOException;

public float readFloat() throws IOException;

public void readFully(byte[] b) throws IOException;

public void readFully(byte[] b, int off, int len) throws IOException;

public int readInt() throws IOException;

public long readLong() throws IOException;

public short readShort() throws IOException;

public int readUnsignedByte() throws IOException;

public int readUnsignedShort() throws IOException;

public String readUTF() throws IOException;

public int skipBytes(int n) throws IOException;
}