/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.io;

public interface DataOutput {

public void write(byte[] b) throws IOException;

public void write(byte[] b, int off, int len) throws IOException;

public void write(int b) throws IOException;

public void writeBoolean(boolean v) throws IOException;

public void writeByte(int v) throws IOException;

public void writeChar(int v) throws IOException;

public void writeChars(String s) throws IOException;

public void writeDouble(double v) throws IOException;

public void writeFloat(float v) throws IOException;

public void writeInt(int v) throws IOException;

public void writeLong(long v) throws IOException;

public void writeShort(int v) throws IOException;

public void writeUTF(String s) throws IOException;

}