/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.lang;

public class AssertionError extends Error {

	public AssertionError() {
	}

	private AssertionError(String message) {
		super(message);
	}

	public AssertionError(Object message) {
		super(String.valueOf(message), message instanceof Throwable ? (Throwable) message : null);
	}
	
	public AssertionError(boolean message) {
		this(String.valueOf(message));
	}

	public AssertionError(char message) {
		this(String.valueOf(message));
	}

	public AssertionError(int message) {
		this(String.valueOf(message));
	}


	public AssertionError(long message) {
		this(String.valueOf(message));
	}
	
	public AssertionError(float message) {
		this(String.valueOf(message));
	}
	
	public AssertionError(double message) {
		this(String.valueOf(message));
	}
}
