/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.lang;

public class StackTraceElement {

	private String className, fileName, methodName;
	private int lineNumber = -1;
	private boolean isNative;

	public String getClassName() {
		return className;
	}

	public String getFileName() {
		return fileName;
	}

	public int getLineNumber() {
		return lineNumber;
	}

	public String getMethodName() {
		return methodName;
	}
	
	public boolean isNativeMethod () {
		return isNative;
	}
	
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append(getClassName());
		buffer.append(".");
		buffer.append(getMethodName());
		buffer.append("(");
		if (isNativeMethod()) {
			buffer.append("Native Code");
		} else {
			buffer.append(fileName != null ? fileName : "Unknown Source");
			if (fileName != null && lineNumber != -1) {
				buffer.append(":");
				buffer.append(lineNumber);
			}
		}
		buffer.append(")");
		return buffer.toString();
	}
}
