/*
 * Copyright 2006 Google Inc.
 * This file contains modifications that are Copyright IBM Corp. 2008.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package java.lang;

import java.io.PrintStream;

/**
 * General-purpose low-level utility methods. GWT only supports a limited subset
 * of these methods due to browser limitations. Only the documented methods are
 * available.
 */
public final class System {

  /**
   * Does nothing in web mode. To get output in web mode, subclass PrintStream
   * and call {@link #setErr(PrintStream)}.
   */
  public static final PrintStream err = new PrintStream(null);

  /**
   * Does nothing in web mode. To get output in web mode, subclass
   * {@link PrintStream} and call {@link #setOut(PrintStream)}.
   */
  public static final PrintStream out = new PrintStream(null);

  public static native long currentTimeMillis() /*-{
    return (new Date()).getTime();
  }-*/;

  /**
   * Has no effect; just here for source compatibility.
   * 
   * @skip
   */
  public static native void gc() /*-{
  }-*/;

  public static native int identityHashCode(Object o) /*-{
    return @com.google.gwt.core.client.Impl::getHashCode(Ljava/lang/Object;)(o);
  }-*/;
  public static native void setErr(PrintStream err) /*-{
    @java.lang.System::err = err;
  }-*/;

  public static native void setOut(PrintStream out) /*-{
    @java.lang.System::out = out;
  }-*/;

  public static native int arraycopy(Object src, int srcPos, Object dest, int destPos, int length) /*-{
    //TODO: Needed to compile SWT
  	var end, i, j;
	if (srcPos < destPos) {
		end = srcPos;
		j = destPos + length - 1;
		i = srcPos + length - 1;
		while (i>=end) {
			dest[j--] = src[i--];
		}
	} else {
		end = srcPos + length;
		j = destPos;
		i = srcPos;
		while (i<end) {
			dest[j++] = src[i++];
		}
	}
  }-*/;
  
  public static String getProperty(String key){
	  //TODO: Needed to compile SWT
	  return null;
  }

}
