/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.io;

public class DataOutputStream extends OutputStream implements DataOutput {

	protected OutputStream out;

public DataOutputStream(OutputStream out) {
	this.out = out;
}

public void close() throws IOException {
	out.close();
}

public void flush() throws IOException {
	out.flush();
}

public void write(byte[] b, int off, int len) throws IOException {
	out.write(b, off, len);
}

public void write(int b) throws IOException {
	out.write(b);
}

public void writeBoolean(boolean v) throws IOException {
	write(v ? 1 : 0);
}

public void writeByte(int v) throws IOException {
	out.write(v);
}

public void writeChar(int v) throws IOException {
	out.write(v >> 8);
	out.write(v);
}

public void writeChars(String s) throws IOException {
	int length = s.length();
	for (int i = 0; i < length; i++) {
		int v = s.charAt(i);
		out.write(v >> 8);
		out.write(v);
	}
}

public void writeDouble(double v) throws IOException {
	writeLong(Double.doubleToLongBits(v));
}

public void writeFloat(float v) throws IOException {
	writeInt(Float.floatToIntBits(v));
}

public void writeInt(int v) throws IOException {
	out.write(v >> 24);
	out.write(v >> 16);
	out.write(v >> 8);
	out.write(v);
}

public void writeLong(long v) throws IOException {
	writeInt((int)(v >> 32));
	writeInt((int)v);
}

public void writeShort(int v) throws IOException {
	out.write(v >> 8);
	out.write(v);
}

public void writeUTF(String s) throws IOException {
	byte[] buffer = new byte[s.length() * 2 + 2];
	int len = convert(s, buffer);
	out.write(buffer, 0, len);
}

private native int convert(String s, byte[] buffer)/*{
	buffer.array.writeUTF(s);
	return buffer.array.position;
}*/;
}