/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.io;

public class PrintStream extends OutputStream {

	private OutputStream out;
	private boolean error;
	private String delimiter, encoding;
	
public PrintStream(OutputStream out) {
	if (out == null) throw new NullPointerException();
	this.out = out;
}

public boolean checkError() {
	flush();
	return error;
}

public void close() {
	try {
		out.flush();
		out.close();
	} catch (IOException e) {
		setError();
	}
}

private native int convert(String s, String encoding, byte[] buffer)/*{
	buffer.array.writeMultiByte(s, encoding);
	return buffer.array.position;
}*/;

public void flush() {
	try {
		out.flush();
	} catch (IOException e) {
		setError();
	}
}

private void newline() {
	if (delimiter == null) delimiter = System.getProperty("line.separator");
	print(delimiter);
}

public void print(boolean b) {
	print(String.valueOf(b));
}

public void print(char c) {
	print(String.valueOf(c));
}

public void print(char[] s) {
	if (s == null) throw new NullPointerException();
	print(String.valueOf(s));
}

public void print(double d) {
	print(String.valueOf(d));
}

public void print(float f) {
	print(String.valueOf(f));
}

public void print(int i) {
	print(String.valueOf(i));
}

public void print(long l) {
	print(String.valueOf(l));
}

public void print(Object obj) {
	print(String.valueOf(obj));
}

public void print(String s) {
	if (encoding == null) encoding = System.getProperty("file.encoding");
	if (s == null) s = "null";
	byte[] buffer = new byte[s.length() * 2];
	int len = convert(s, encoding, buffer);
	write(buffer, 0, len);
}

public void println() {
	newline();
}

public void println(boolean b) {
	println(String.valueOf(b));
}

public void println(char c) {
	println(String.valueOf(c));
}

public void println(char[] s) {
	if (s == null) throw new NullPointerException();
	println(String.valueOf(s));
}

public void println(double d) {
	println(String.valueOf(d));
}

public void println(float f) {
	println(String.valueOf(f));
}

public void println(int i) {
	println(String.valueOf(i));
}

public void println(long l) {
	println(String.valueOf(l));
}

public void println(Object obj) {
	println(String.valueOf(obj));
}

public void println(String s) {
	print(s);
	newline();
}

protected void setError() {
	error = true;
}

public void write(int b) {
	try {
		out.write(b);
	} catch (IOException e) {
		setError();
	}
}

public void write(byte[] b, int off, int len) {
	try {
		out.write(b, off, len);
	} catch (IOException e) {
		setError();
	}
}
}