/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.lang;

public final class Boolean {

	private final boolean value;
	
	public static Boolean FALSE = new Boolean(false);
	
	public static Boolean TRUE = new Boolean(true);
	
	public static final Class TYPE = new Class("boolean");

    public static boolean parseBoolean(String s) {
    	return fromString(s);
	}
    
    private static boolean fromString(String str) {
    	return str != null && str.equalsIgnoreCase("true");
    }

	public static String toString(boolean x) {
		return String.valueOf(x);
	}

	public static Boolean valueOf(boolean bool) {
		return bool ? TRUE : FALSE;
	}

	public static Boolean valueOf(String str) {
		return fromString(str) ? TRUE : FALSE;
	}

	public Boolean(boolean value) {
		this.value = value;
	}

	public Boolean(String str) {
		this(fromString(str));
	}

	public boolean booleanValue() {
		return value;
	}

	public boolean equals(Object obj) {
		return (obj instanceof Boolean) && (((Boolean)obj).value == value);
	}

	public int hashCode() {
		return value ? 1231 : 1237;
	}

	public String toString() {
		return value ? "true" : "false";
	}
}
