/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.lang;

public final class Byte extends Number implements Comparable {

	private final byte value;

	public static final byte MIN_VALUE = -128;

	public static final byte MAX_VALUE = 127;

	public static final Class TYPE = new Class("byte");

	public static Byte decode(String s) throws NumberFormatException {
		return new Byte((byte)toLongDecode(s, MIN_VALUE, MAX_VALUE));
	}

	public static byte parseByte(String s) throws NumberFormatException {
		return parseByte(s, 10);
	}

	public static byte parseByte(String s, int radix) throws NumberFormatException {
		return (byte)toLong(s, radix, MIN_VALUE, MAX_VALUE);
	}

	public static String toString(byte b) {
		return String.valueOf(b);
	}

	public static Byte valueOf(String s) throws NumberFormatException {
		return new Byte(Byte.parseByte(s));
	}

	public static Byte valueOf(String s, int radix) throws NumberFormatException {
		return new Byte(Byte.parseByte(s, radix));
	}

	public Byte(byte value) {
		this.value = value;
	}

	public Byte(String s) {
		value = parseByte(s);
	}

	public byte byteValue() {
		return value;
	}

	public int compareTo(Byte b) {
		if (value < b.value) return -1;
		if (value > b.value) return 1;
		return 0;
	}

	public int compareTo(Object o) {
		return compareTo((Byte) o);
	}

	public double doubleValue() {
		return value;
	}

	public boolean equals(Object obj) {
		return (obj instanceof Byte) && (((Byte) obj).value == value);
	}

	public float floatValue() {
		return value;
	}

	public int hashCode() {
		return value;
	}

	public int intValue() {
		return value;
	}

	public long longValue() {
		return value;
	}

	public short shortValue() {
		return value;
	}

	public String toString() {
		return toString(value);
	}
}
