/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.lang;

import intrinsic.flash.utils.ByteArray;

public final class Double extends Number implements Comparable {

	private final double value;
	
	public static final double MAX_VALUE = /* 1.7976931348623157e+308 */
		1.79769313486231e+308; // PREMATURE will have to change this

	public static final double MIN_VALUE = /* 4.9e-324 */
		1.0e-323; // PREMATURE will have to change this

	public static final double NaN = 0d / 0d;

	public static final double NEGATIVE_INFINITY = -1d / 0d;

	public static final double POSITIVE_INFINITY = 1d / 0d;

	public static final Class TYPE = new Class("double");

	public static int compare(double x, double y) {
		if (x < y) return -1;
		if (x > y) return 1;
		return 0;
	}
	
	public static long doubleToLongBits(double value) {
		ByteArray array = new ByteArray();
		array.writeDouble(value);
		return (long)array.readInt() << 32 | array.readInt();
	}

	public static boolean isInfinite(double x) {
		return isInfiniteImpl(x);
	}

	public static boolean isNaN(double x) {
		return isNaNImpl(x);
	}
	
	public static double longBitsToDouble(long bits) {
		ByteArray array = new ByteArray();
		array.writeInt((int)(bits >> 32));
		array.writeInt((int)bits);
		return array.readDouble();
	}

	public static double parseDouble(String str) throws NumberFormatException {
		return toDouble(str, MIN_VALUE, MAX_VALUE);
	}

	public static String toString(double b) {
		return String.valueOf(b);
	}

	public static Double valueOf(String s) throws NumberFormatException {
		return new Double(Double.parseDouble(s));
	}

	public Double(double value) {
		this.value = value;
	}

	public Double(String s) {
		value = parseDouble(s);
	}

	public byte byteValue() {
		return (byte) value;
	}

	public int compareTo(Double b) {
		if (value < b.value) return -1;
		if (value > b.value) return 1;
		return 0;
	}

	public int compareTo(Object o) {
		return compareTo((Double) o);
	}

	public double doubleValue() {
		return value;
	}

	public boolean equals(Object o) {
		return (o instanceof Double) && (((Double) o).value == value);
	}

	public float floatValue() {
		return (float) value;
	}

	public int hashCode() {
		return (int) value;
	}

	public int intValue() {
		return (int) value;
	}

	public boolean isInfinite() {
		return isInfinite(value);
	}

	public boolean isNaN() {
		return isNaN(value);
	}

	public long longValue() {
		return (long) value;
	}

	public short shortValue() {
		return (short) value;
	}

	public String toString() {
		return toString(value);
	}

}
