/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.lang;

import intrinsic.flash.utils.ByteArray;

public final class Float extends Number implements Comparable {

	private final float value;
	
	public static final float MAX_VALUE = 3.4028235e+38f;

	public static final float MIN_VALUE = 1.4e-45f;

	public static final float NaN = 0f / 0f;

	public static final float NEGATIVE_INFINITY = -1f / 0f;

	public static final float POSITIVE_INFINITY = 1f / 0f;

	public static final Class TYPE = new Class("float");

	public static int compare(float x, float y) {
		if (x < y) return -1;
		if (x > y) return 1;
		return 0;
	}
	
	public static int floatToIntBits(float value) {
		ByteArray array = new ByteArray();
		array.writeFloat(value);
		return array.readInt();
	}
	
	public static float intBitsToFloat(int bits) {
		ByteArray array = new ByteArray();
		array.writeInt(bits);
		return (float)array.readFloat();
	}

	public static boolean isInfinite(double x) {
		return isInfiniteImpl(x);
	}

	public static boolean isNaN(double x) {
		return isNaNImpl(x);
	}

	public static float parseFloat(String str) throws NumberFormatException {
		return toDouble(str, MIN_VALUE, MAX_VALUE);
	}

	public static String toString(float b) {
		return String.valueOf(b);
	}

	public static Float valueOf(String s) throws NumberFormatException {
		return new Float(Float.parseFloat(s));
	}

	public Float(float value) {
		this.value = value;
	}

	public Float(String s) {
		value = parseFloat(s);
	}

	public byte byteValue() {
		return (byte) value;
	}

	public int compareTo(Float b) {
		if (value < b.value) return -1;
		if (value > b.value) return 1;
		return 0;
	}

	public int compareTo(Object o) {
		return compareTo((Float) o);
	}

	public double doubleValue() {
		return value;
	}

	public boolean equals(Object obj) {
		return (obj instanceof Float) && (((Float) obj).value == value);
	}

	public float floatValue() {
		return value;
	}

	public int hashCode() {
		return (int) value;
	}

	public int intValue() {
		return (int) value;
	}

	public boolean isInfinite() {
		return isInfinite(value);
	}

	public boolean isNaN() {
		return isNaN(value);
	}

	public long longValue() {
		return (long) value;
	}

	public short shortValue() {
		return (short) value;
	}

	public String toString() {
		return toString(value);
	}

}
