/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.lang;

public final class Integer extends Number implements Comparable {

	private final transient int value;
	
	//TODO - flex does not like 0x80000000
	public static final int MIN_VALUE = -2147483648;//0x80000000;

	public static final int MAX_VALUE = 2147483647;//0x7fffffff;

	public static final Class TYPE = new Class("int");

	public static Integer decode(String s) throws NumberFormatException {
		return new Integer((int)toLongDecode(s, MIN_VALUE, MAX_VALUE));
	}

	public static int parseInt(String s) throws NumberFormatException {
		return parseInt(s, 10);
	}

	public static int parseInt(String s, int radix) throws NumberFormatException {
		return (int)toLong(s, radix, MIN_VALUE, MAX_VALUE);
	}

	public static String toBinaryString(int x) {
		return Long.toBinaryString(x);
	}

	public static String toHexString(int x) {
		return Long.toHexString(x);
	}

	public static String toString(int b) {
		return String.valueOf(b);
	}

	public static Integer valueOf(String s) throws NumberFormatException {
		return new Integer(Integer.parseInt(s));
	}

	public static Integer valueOf(String s, int radix) throws NumberFormatException {
		return new Integer(Integer.parseInt(s, radix));
	}

	public Integer(int value) {
		this.value = value;
	}

	public Integer(String s) {
		value = parseInt(s);
	}

	public byte byteValue() {
		return (byte) value;
	}

	public int compareTo(Integer b) {
		if (value < b.value) return -1;
		if (value > b.value) return 1;
		return 0;
	}

	public int compareTo(Object o) {
		return compareTo((Integer) o);
	}

	public double doubleValue() {
		return value;
	}

	public boolean equals(Object obj) {
		return (obj instanceof Integer) && (((Integer) obj).value == value);
	}

	public float floatValue() {
		return value;
	}

	public int hashCode() {
		return value;
	}

	public int intValue() {
		return value;
	}

	public long longValue() {
		return value;
	}

	public short shortValue() {
		return (short) value;
	}

	public String toString() {
		return toString(value);
	}
}
