/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.lang;

import intrinsic.flash.utils.*;

public class JavaArray extends Proxy {

public String type;
public Object array;

public JavaArray(String type) {
	this.type = type;
}
	
native void dummy()/*{
}

private function newArray(len:int):Object {
	if (type == "[B") {
		var result:ByteArray = new ByteArray();
		result.length = len;
		return result;
	} else {
		return new Array(len);
	}
}

public function values(... values):JavaArray {
	this.array = newArray(values.length);
	for (var i:int=0; i<values.length; i++) {
		array[i] = values[i];
	}
	return this;
}

public function lengths(... lengths):JavaArray {
	var len:int = lengths[0];
	this.array =  newArray(len);
	var i:int = 0;
	if (lengths.length > 1) {
		lengths.shift();
		for (; i<len; i++) {
			array[i] = new JavaArray(type.substring(1)).lengths(lengths);
		}
	} else {
		var value:Object = type.length != 2 ? null : 0;
		for (; i<len; i++) array[i] = value;
	}
	return this; 
}

override flash_proxy function callProperty(methodName:*, ... args):* {
	switch (methodName.toString()) {
		case 'getClass__':
			return java.lang.Class__.forName__Ljava_lang_String_2(type);
		case 'toString__':
			return type + "@" + this.hashCode__();
		case 'equals__':
			return this === args[0];
			break;
		case 'finalize__':
			return;
	}
	return array[methodName].apply(array, args);
}

override flash_proxy function getProperty(name:*):* {
	if (name == "length") return array.length;
	var index:int = Number(name);
	if (!(0 <= index && index < array.length)) {
		throw new ArrayIndexOutOfBoundsException(index);
	}
	return array[index];
}

override flash_proxy function setProperty(name:*, value:*):void {
	var index:int = Number(name);
	if (!(0 <= index && index < array.length)) {
		throw new ArrayIndexOutOfBoundsException(index);
	}
    array[index] = value;
}

*/;
}
