/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.lang;

public final class Long extends Number implements Comparable {

	public static final long MIN_VALUE = /* 0x8000000000000000L */
		-9007199254740992L; // PREMATURE will have to change this

	public static final long MAX_VALUE = /* 0x7fffffffffffffffL */
		9007199254740992L; // PREMATURE will have to change this
	
	public static final Class TYPE = new Class("long");

	private static final String[] HEX = {"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

	public static Long decode(String s) throws NumberFormatException {
		return new Long(toLongDecode(s, MIN_VALUE, MAX_VALUE));
	}

	public static long parseLong(String s) throws NumberFormatException {
		return parseLong(s, 10);
	}

	public static long parseLong(String s, int radix) throws NumberFormatException {
		return toLong(s, radix, MIN_VALUE, MAX_VALUE);
	}

	public static String toBinaryString(long x) {
		if (x == 0) return "0";
		String str = "";
		while (x != 0) {
			int bit = (int) x & 0x1;
			str = HEX[bit] + str;
			x = x >>> 1;
		}
		return str;
	}

	public static String toHexString(long x) {
		if (x == 0)  return "0";
	    String str = "";
	    while (x != 0) {
	    	int nibble = (int) x & 0xF;
	    	str = HEX[nibble] + str;
	    	x = x >>> 4;
	    }
	    return str;
	}

	public static String toString(long b) {
		return String.valueOf(b);
	}

	public static Long valueOf(String s) throws NumberFormatException {
		return new Long(Long.parseLong(s));
	}

	public static Long valueOf(String s, int radix)
			throws NumberFormatException {
		return new Long(Long.parseLong(s, radix));
	}

	private final transient long value;

	public Long(long value) {
		this.value = value;
	}

	public Long(String s) {
		value = parseLong(s);
	}

	public byte byteValue() {
		return (byte) value;
	}

	public int compareTo(Long b) {
		if (value < b.value) return -1;
		if (value > b.value) return 1;
		return 0;
	}

	public int compareTo(Object o) {
		return compareTo((Long) o);
	}

	public double doubleValue() {
		return value;
	}

	public boolean equals(Object obj) {
		return (obj instanceof Long) && (((Long) obj).value == value);
	}

	public float floatValue() {
		return value;
	}

	public int hashCode() {
		return (int) value;
	}

	public int intValue() {
		return (int) value;
	}

	public long longValue() {
		return value;
	}

	public short shortValue() {
		return (short) value;
	}

	public String toString() {
		return toString(value);
	}
}
